﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientGoodsConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientGoods clientGoods = new ClientGoods();

        GridView1.DataSource = clientGoods.GetClientGoodsByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientGoodsInfo> clientGoodsinfo = new List<ClientGoodsInfo>();

        ClientGoods clientGoods = new ClientGoods();
        clientGoodsinfo = clientGoods.GetClientGoodsById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientGoodsinfo.Count > 0)
        {
            txtClientGoodsName.Text = clientGoodsinfo[0].商品名称;
            txtClientGoodsNo.Text = clientGoodsinfo[0].序号.ToString();
            txtClientGoodsPrice.Text = clientGoodsinfo[0].商品价格.ToString();
            txtClientGoodsNumber.Text = clientGoodsinfo[0].商品数量.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientGoods clientGoods = new ClientGoods();
        clientGoods.ClientGoodsDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientGoodsInfo clientGoodsinfo = new ClientGoodsInfo();

        clientGoodsinfo.商品名称 = txtClientGoodsName.Text.ToString();
        clientGoodsinfo.序号 = Int32.Parse(txtClientGoodsNo.Text.Trim());
        clientGoodsinfo.商品价格 = Int32.Parse(txtClientGoodsPrice.Text.Trim());
        clientGoodsinfo.商品数量 = Int32.Parse(txtClientGoodsNumber.Text.Trim());
        clientGoodsinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientGoods clientGoods = new ClientGoods();
        clientGoods.ClientGoodsAdd(clientGoodsinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientGoodsInfo clientGoodsinfo = new ClientGoodsInfo();

        clientGoodsinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clientGoodsinfo.商品名称 = txtClientGoodsName.Text.ToString();
        clientGoodsinfo.序号 = Int32.Parse(txtClientGoodsNo.Text.Trim());
        clientGoodsinfo.商品价格 = Int32.Parse(txtClientGoodsPrice.Text.Trim());
        clientGoodsinfo.商品数量 = Int32.Parse(txtClientGoodsNumber.Text.Trim());

        ClientGoods clientGoods = new ClientGoods();
        clientGoods.ClientGoodsUpdateById(clientGoodsinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}
