﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientIndustryConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientIndustry clientIndustry = new ClientIndustry();

        GridView1.DataSource = clientIndustry.GetClientIndustryByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientIndustryInfo> clientIndustryinfo = new List<ClientIndustryInfo>();

        ClientIndustry clientIndustry = new ClientIndustry();
        clientIndustryinfo = clientIndustry.GetClientIndustryById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientIndustryinfo.Count > 0)
        {
            txtClientIndustryName.Text = clientIndustryinfo[0].客户行业;
            txtClientIndustryNo.Text = clientIndustryinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientIndustry clientIndustry = new ClientIndustry();
        clientIndustry.ClientIndustryDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientIndustryInfo clientIndustryinfo = new ClientIndustryInfo();

        clientIndustryinfo.客户行业 = txtClientIndustryName.Text.ToString();
        clientIndustryinfo.序号 = Int32.Parse(txtClientIndustryNo.Text.Trim());
        clientIndustryinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientIndustry clientIndustry = new ClientIndustry();
        clientIndustry.ClientIndustryAdd(clientIndustryinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientIndustryInfo clientIndustryinfo = new ClientIndustryInfo();

        clientIndustryinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clientIndustryinfo.客户行业 = txtClientIndustryName.Text.ToString();
        clientIndustryinfo.序号 = Int32.Parse(txtClientIndustryNo.Text.Trim());

        ClientIndustry clientIndustry = new ClientIndustry();
        clientIndustry.ClientIndustryUpdateById(clientIndustryinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}
