﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientPhaseConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientPhase clientPhase = new ClientPhase();

        GridView1.DataSource = clientPhase.GetClientPhaseByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientPhaseInfo> clientPhaseinfo = new List<ClientPhaseInfo>();

        ClientPhase clientPhase = new ClientPhase();
        clientPhaseinfo = clientPhase.GetClientPhaseById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientPhaseinfo.Count > 0)
        {
            txtClientPhaseName.Text = clientPhaseinfo[0].客户阶段;
            txtClientPhaseNo.Text = clientPhaseinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientPhase clientPhase = new ClientPhase();
        clientPhase.ClientPhaseDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientPhaseInfo clientPhaseinfo = new ClientPhaseInfo();

        clientPhaseinfo.客户阶段 = txtClientPhaseName.Text.ToString();
        clientPhaseinfo.序号 = Int32.Parse(txtClientPhaseNo.Text.Trim());
        clientPhaseinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientPhase clientPhase = new ClientPhase();
        clientPhase.ClientPhaseAdd(clientPhaseinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientPhaseInfo clientPhaseinfo = new ClientPhaseInfo();

        clientPhaseinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clientPhaseinfo.客户阶段 = txtClientPhaseName.Text.ToString();
        clientPhaseinfo.序号 = Int32.Parse(txtClientPhaseNo.Text.Trim());

        ClientPhase clientPhase = new ClientPhase();
        clientPhase.ClientPhaseUpdateById(clientPhaseinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}
