﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientRankConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientRank clientRank = new ClientRank();

        GridView1.DataSource = clientRank.GetClientRankByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientRankInfo> clientRankinfo = new List<ClientRankInfo>();

        ClientRank clientRank = new ClientRank();
        clientRankinfo = clientRank.GetClientRankById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientRankinfo.Count > 0)
        {
            txtClientRankName.Text = clientRankinfo[0].客户级别;
            txtClientRankNo.Text = clientRankinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientRank clientRank = new ClientRank();
        clientRank.ClientRankDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientRankInfo clientRankinfo = new ClientRankInfo();

        clientRankinfo.客户级别 = txtClientRankName.Text.ToString();
        clientRankinfo.序号 = Int32.Parse(txtClientRankNo.Text.Trim());
        clientRankinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientRank clientRank = new ClientRank();
        clientRank.ClientRankAdd(clientRankinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientRankInfo clientRankinfo = new ClientRankInfo();

        clientRankinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clientRankinfo.客户级别 = txtClientRankName.Text.ToString();
        clientRankinfo.序号 = Int32.Parse(txtClientRankNo.Text.Trim());

        ClientRank clientRank = new ClientRank();
        clientRank.ClientRankUpdateById(clientRankinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}
