﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientRateConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientRate clientRate = new ClientRate();

        GridView1.DataSource = clientRate.GetClientRateByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientRateInfo> clientRateinfo = new List<ClientRateInfo>();

        ClientRate clientRate = new ClientRate();
        clientRateinfo = clientRate.GetClientRateById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientRateinfo.Count > 0)
        {
            txtClientRateName.Text = clientRateinfo[0].进度名称;
            txtClientRateContent.Text = clientRateinfo[0].进度描述;
            txtClientRateNo.Text = clientRateinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientRate clientRate = new ClientRate();
        clientRate.ClientRateDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientRateInfo clientRateinfo = new ClientRateInfo();

        clientRateinfo.进度名称 = txtClientRateName.Text.ToString();
        clientRateinfo.进度描述 = txtClientRateContent.Text.ToString();
        clientRateinfo.序号 = Int32.Parse(txtClientRateNo.Text.Trim());
        clientRateinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientRate clientRate = new ClientRate();
        clientRate.ClientRateAdd(clientRateinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientRateInfo clientRateinfo = new ClientRateInfo();

        clientRateinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clientRateinfo.进度名称 = txtClientRateName.Text.ToString();
        clientRateinfo.进度描述 = txtClientRateContent.Text.ToString();
        clientRateinfo.序号 = Int32.Parse(txtClientRateNo.Text.Trim());

        ClientRate clientRate = new ClientRate();
        clientRate.ClientRateUpdateById(clientRateinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}
