﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientStatusConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientStatus clientStatus = new ClientStatus();

        GridView1.DataSource = clientStatus.GetClientStatusByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientStatusInfo> clientStatusinfo = new List<ClientStatusInfo>();

        ClientStatus clientStatus = new ClientStatus();
        clientStatusinfo = clientStatus.GetClientStatusById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientStatusinfo.Count > 0)
        {
            txtClientStatusName.Text = clientStatusinfo[0].客户状态;
            txtClientStatusNo.Text = clientStatusinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientStatus clientStatus = new ClientStatus();
        clientStatus.ClientStatusDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientStatusInfo clientStatusinfo = new ClientStatusInfo();

        clientStatusinfo.客户状态 = txtClientStatusName.Text.ToString();
        clientStatusinfo.序号 = Int32.Parse(txtClientStatusNo.Text.Trim());
        clientStatusinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientStatus clientStatus = new ClientStatus();
        clientStatus.ClientStatusAdd(clientStatusinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientStatusInfo clientStatusinfo = new ClientStatusInfo();

        clientStatusinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clientStatusinfo.客户状态 = txtClientStatusName.Text.ToString();
        clientStatusinfo.序号 = Int32.Parse(txtClientStatusNo.Text.Trim());

        ClientStatus clientStatus = new ClientStatus();
        clientStatus.ClientStatusUpdateById(clientStatusinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}
