﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ClientTypeConfig : System.Web.UI.Page
{
    protected void Bind() {
        ClientType clientType= new ClientType();

        GridView1.DataSource = clientType.GetClientTypeByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] {"id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientTypeInfo> clienttypeinfo = new List<ClientTypeInfo>();

        ClientType clientType = new ClientType();
        clienttypeinfo = clientType.GetClientTypeById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clienttypeinfo.Count > 0)
        {
            txtClientTypeName.Text = clienttypeinfo[0].客户类型;
            txtClientTypeNo.Text = clienttypeinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientType clientType = new ClientType();
        clientType.ClientTypeDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientTypeInfo clienttypeinfo = new ClientTypeInfo();

        clienttypeinfo.客户类型 = txtClientTypeName.Text.ToString();
        clienttypeinfo.序号 = Int32.Parse(txtClientTypeNo.Text.Trim());
        clienttypeinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientType clientType = new ClientType();
        clientType.ClientTypeAdd(clienttypeinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientTypeInfo clienttypeinfo = new ClientTypeInfo();

        clienttypeinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        clienttypeinfo.客户类型 = txtClientTypeName.Text.ToString();
        clienttypeinfo.序号 = Int32.Parse(txtClientTypeNo.Text.Trim());

        ClientType clientType = new ClientType();
        clientType.ClientTypeUpdateById(clienttypeinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack) {
            Bind();
        }

    }
}
