﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_DepartmentConfig : System.Web.UI.Page
{
    protected void Init_TreeView(string IsInit, string fid)
    {

        IList<CRM.Model.DepartmentInfo> departments;
        CRM.BLL.Department department = new CRM.BLL.Department();
        departments = department.GetDepartmentByFid(Session["CID"].ToString(),fid);

        for (int i = 0; i < departments.Count; i++)
        {
            TreeNode node = new TreeNode();
            node.Text = departments[i].部门名称;
            node.Value = departments[i].ID.ToString();
            node.SelectAction = TreeNodeSelectAction.Select;
            //node.Target = "Right";
            TreeView1.Nodes.Add(node);

            CreateNode(node, departments[i].ID.ToString());
        }
    }

    protected void CreateNode(TreeNode node, string fid)
    {
        IList<CRM.Model.DepartmentInfo> departments;
        CRM.BLL.Department department = new CRM.BLL.Department();
        departments = department.GetDepartmentByFid(Session["CID"].ToString(),fid);

        for (int i = 0; i < departments.Count; i++)
        {
            TreeNode childNode = new TreeNode();
            childNode.Text = departments[i].部门名称;
            childNode.Value = departments[i].ID.ToString();
            childNode.SelectAction = TreeNodeSelectAction.Select;
            node.ChildNodes.Add(childNode);
            CreateNode(childNode, departments[i].ID.ToString());

        }

    }

    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        IList<CRM.Model.DepartmentInfo> departments;
        CRM.BLL.Department department = new CRM.BLL.Department();
        departments = department.GetDepartmentById(Session["CID"].ToString(), TreeView1.SelectedNode.Value.ToString());
        if (departments.Count > 0) {
            txtDepartmentName.Text = departments[0].部门名称;
            txtNo.Text = departments[0].序号.ToString();
            if (departments[0].上级部门.ToString() != "0")
            {
                ddlPreDepart.SelectedValue = departments[0].上级部门.ToString();
            }
            else {
                ddlPreDepart.SelectedValue = "0";
            }
        }
  
    }

    protected void Init_Data (){
        ddlPreDepart.Items.Clear();
        DataTable dt = CRM.Common.InitData.GetDepartmentByCid(Session["Cid"].ToString());
        ddlPreDepart.Items.Add(new ListItem("无上级","0"));
        for (int i = 0; i < dt.Rows.Count; i++) {
            ddlPreDepart.Items.Add(new ListItem(dt.Rows[i]["部门名称"].ToString(),dt.Rows[i]["id"].ToString()));
        }      

    }

    protected void Button1_Click(object sender,EventArgs e) {
        string id = TreeView1.SelectedValue;

        if (String.IsNullOrEmpty(id)) {
            if (!IsClientScriptBlockRegistered("Edit"))
            {
                RegisterClientScriptBlock("Edit","<script>alert('未选择部门!')</script>");
                return;
            }
        }

        DepartmentInfo departmentinfo = new DepartmentInfo();
        departmentinfo.ID = Int32.Parse(id);
        departmentinfo.部门名称 = txtDepartmentName.Text.Trim();
        departmentinfo.序号 = Int32.Parse(txtNo.Text.Trim());
        departmentinfo.上级部门 = Int32.Parse(ddlPreDepart.SelectedValue);

        Department department = new Department();
        department.DepartmentUpdateById(departmentinfo);

        TreeView1.Nodes.Clear();
        Init_TreeView("1","0");
        TreeView1.ExpandAll();
    }
    protected void Button2_Click(object sender, EventArgs e) {
        string id = TreeView1.SelectedValue;

        if (String.IsNullOrEmpty(id))
        {
            if (!IsClientScriptBlockRegistered("Edit"))
            {
                RegisterClientScriptBlock("Edit", "<script>alert('未选择部门!')</script>");
                return;
            }
        }

        Department department = new Department();
        department.DepartmentDeleteById(Session["CID"].ToString(),id);

        TreeView1.Nodes.Clear();
        Init_TreeView("1", "0");
        TreeView1.ExpandAll();
        Init_Data();
    }
    protected void Button3_Click(object sender,EventArgs e) {
        DepartmentInfo departmentinfo = new DepartmentInfo();

        departmentinfo.CID = Int32.Parse(Session["CID"].ToString());
        departmentinfo.部门名称 = txtDepartmentName.Text.Trim();
        departmentinfo.序号 = Int32.Parse(txtNo.Text.Trim());
        departmentinfo.上级部门 = Int32.Parse(ddlPreDepart.SelectedValue);

        Department department = new Department();
        department.DepartmentAdd(departmentinfo);

        Init_Data();

        TreeView1.Nodes.Clear();
        Init_TreeView("1", "0");
        TreeView1.ExpandAll();

    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Init_TreeView("1", "0");
            Init_Data();
        }
    }
}
