﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_FeedbackTypeConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();

        GridView1.DataSource =clientFeedbackType.GetClientFeedbackTypeByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<ClientFeedbackTypeInfo> clientFeedbackTypeinfo = new List<ClientFeedbackTypeInfo>();

        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();
        clientFeedbackTypeinfo = clientFeedbackType.GetClientFeedbackTypeById(GridView1.DataKeys[index].Values["id"].ToString());

        if (clientFeedbackTypeinfo.Count > 0)
        {
            txtFeedbackTypeName.Text = clientFeedbackTypeinfo[0].联系类型;
            txtFeedbackTypeNo.Text = clientFeedbackTypeinfo[0].序号.ToString();
        }

    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();
        clientFeedbackType.ClientFeedbackTypeDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientFeedbackTypeInfo ClientFeedbackTypeinfo = new ClientFeedbackTypeInfo();

        ClientFeedbackTypeinfo.联系类型 = txtFeedbackTypeName.Text.ToString();
        ClientFeedbackTypeinfo.序号 = Int32.Parse(txtFeedbackTypeNo.Text.Trim());
        ClientFeedbackTypeinfo.CID = Int32.Parse(Session["CID"].ToString());

        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();
        clientFeedbackType.ClientFeedbackTypeAdd(ClientFeedbackTypeinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        ClientFeedbackTypeInfo ClientFeedbackTypeinfo = new ClientFeedbackTypeInfo();

        ClientFeedbackTypeinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        ClientFeedbackTypeinfo.联系类型 = txtFeedbackTypeName.Text.ToString();
        ClientFeedbackTypeinfo.序号 = Int32.Parse(txtFeedbackTypeNo.Text.Trim());

        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();
        clientFeedbackType.ClientFeedbackTypeUpdateById(ClientFeedbackTypeinfo);

        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }

    }
}