﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_ProvinceConfig : System.Web.UI.Page
{
    #region 省份代码
    protected void Bind() {
        Province province = new Province();

        GridView1.DataSource = province.GetProvinceByCid(Session["CID"].ToString());
        GridView1.DataKeyNames = new string[] { "id"};
        GridView1.DataBind();
    }
    protected void GridView1_SelectedIndexChanging(object sender,GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;

        Province province = new Province();
        IList<ProvinceInfo> provinces = new List<ProvinceInfo>();
        provinces = province.GetProvinceById(GridView1.DataKeys[index].Values["id"].ToString());

        if (provinces.Count > 0) {
            txtProvinceName.Text = provinces[0].名称;
            txtProvinceNo.Text = provinces[0].序号.ToString();
        }

        Bind2(GridView1.DataKeys[index].Values["id"].ToString());
    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        Province province = new Province();
        province.ProvinceDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        ProvinceInfo Provinceinfo = new ProvinceInfo();

        Provinceinfo.名称 = txtProvinceName.Text.Trim();
        Provinceinfo.序号 = Int32.Parse(txtProvinceNo.Text.Trim());
        Provinceinfo.CID = Int32.Parse(Session["CID"].ToString());

        Province province = new Province();
        province.ProvinceAdd(Provinceinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e) {
        if (GridView1.SelectedIndex > -1)
        {
            ProvinceInfo Provinceinfo = new ProvinceInfo();

            Provinceinfo.名称 = txtProvinceName.Text.Trim();
            Provinceinfo.序号 = Int32.Parse(txtProvinceNo.Text.Trim());
            Provinceinfo.ID = Int32.Parse(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());

            Province province = new Province();
            province.ProvinceUpdateById(Provinceinfo);

            Bind();
        }
        else {
            if (IsClientScriptBlockRegistered("IsSelected")) {
                Page.RegisterClientScriptBlock("IsSelected","<script>alert('未选择省份');</script>");
            }
        }
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Bind();
        }
    }

    #endregion
    #region 地区代码
    protected void Bind2(string province) {
        //string province = GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString();
        City city = new City();

        GridView2.DataSource = city.GetCityByPrivince(province);
        GridView2.DataKeyNames = new string[] { "id" };
        GridView2.DataBind();
    }
    protected void GridView2_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;

        City city = new City();
        IList<CityInfo> citys = new List<CityInfo>();
        citys = city.GetCityById(GridView2.DataKeys[index].Values["id"].ToString());

        if (citys.Count > 0) {
            txtCityName.Text = citys[0].名称;
            txtCityNo.Text = citys[0].序号.ToString();
        }
    }
    protected void GridView2_RowDeleting(object sender,GridViewDeleteEventArgs e) {
        int index = e.RowIndex;

        City city = new City();
        city.CityDeleteById(GridView2.DataKeys[index].Values["id"].ToString());

        Bind2(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());

    }
    protected void Button3_Click(object sender,EventArgs e) {
        CityInfo cityinfo = new CityInfo();

        cityinfo.名称 = txtCityName.Text.Trim();
        cityinfo.序号 =Int32.Parse(txtCityNo.Text.Trim());
        cityinfo.省份 = Int32.Parse(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());

        City city = new City();
        city.CityAdd(cityinfo);

        Bind2(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
    }
    protected void Button4_Click(object sender, EventArgs e) {
        try{
            CityInfo cityinfo = new CityInfo();

            cityinfo.名称 = txtCityName.Text.Trim();
            cityinfo.序号 = Int32.Parse(txtCityNo.Text.Trim());
            cityinfo.省份 = Int32.Parse(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
            cityinfo.ID = Int32.Parse(GridView2.DataKeys[GridView2.SelectedIndex].Values["id"].ToString());

            City city = new City();
            city.CityUpdateById(cityinfo);
        }
        catch{
            if (IsClientScriptBlockRegistered("CityIsSelected"))
            {
                Page.RegisterClientScriptBlock("CityIsSelected", "<script>alert('未选择地区');</script>");
            }
        }
        Bind2(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
    }

    protected void GridView2_PageIndexChanging(object sender, GridViewPageEventArgs e) {
        GridView2.PageIndex = e.NewPageIndex;
        Bind2(GridView1.SelectedDataKey["id"].ToString());
    }
    #endregion
}
