﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Basic_RoleConfig : System.Web.UI.Page
{
    protected void Init_TreeView(string IsInit, string fid)
    {

        IList<CRM.Model.RoleInfo> roles;
        CRM.BLL.Role role = new CRM.BLL.Role();
        roles = role.GetRoleByFid(Session["CID"].ToString(), fid);

        for (int i = 0; i < roles.Count; i++)
        {
            TreeNode node = new TreeNode();
            node.Text = roles[i].角色名称;
            node.Value = roles[i].ID.ToString();
            node.SelectAction = TreeNodeSelectAction.Select;
            //node.Target = "Right";
            TreeView1.Nodes.Add(node);

            CreateNode(node, roles[i].ID.ToString());
        }
    }

    protected void CreateNode(TreeNode node, string fid)
    {
        IList<CRM.Model.RoleInfo> roles;
        CRM.BLL.Role role = new CRM.BLL.Role();
        roles = role.GetRoleByFid(Session["CID"].ToString(), fid);

        for (int i = 0; i < roles.Count; i++)
        {
            TreeNode childNode = new TreeNode();
            childNode.Text = roles[i].角色名称;
            childNode.Value = roles[i].ID.ToString();
            childNode.SelectAction = TreeNodeSelectAction.Select;
            node.ChildNodes.Add(childNode);
            CreateNode(childNode, roles[i].ID.ToString());

        }


    }

    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        IList<CRM.Model.RoleInfo> roles;
        CRM.BLL.Role role = new CRM.BLL.Role();
        roles = role.GetRoleById(Session["CID"].ToString(), TreeView1.SelectedNode.Value.ToString());

        if (roles.Count > 0)
        {
            txtRoleName.Text = roles[0].角色名称;
            txtNo.Text = roles[0].序号.ToString();
            if (roles[0].上级角色.ToString() != "0")
            {
                ddlPreRole.SelectedValue = roles[0].上级角色.ToString();
            }
            else
            {
                ddlPreRole.SelectedValue = "0";
            }
        }

    }

    protected void Init_Data()
    {
        ddlPreRole.Items.Clear();

        DataTable dt = CRM.Common.InitData.GetRoleByCid(Session["Cid"].ToString());
        ddlPreRole.Items.Add(new ListItem("无上级", "0"));
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ddlPreRole.Items.Add(new ListItem(dt.Rows[i]["角色名称"].ToString(), dt.Rows[i]["id"].ToString()));
        }

    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string id = TreeView1.SelectedValue;

        if (String.IsNullOrEmpty(id))
        {
            if (!IsClientScriptBlockRegistered("Edit"))
            {
                RegisterClientScriptBlock("Edit", "<script>alert('未选择角色!')</script>");
                return;
            }
        }

        RoleInfo roleinfo = new RoleInfo();
        roleinfo.ID = Int32.Parse(id);
        roleinfo.角色名称 = txtRoleName.Text.Trim();
        roleinfo.序号 = Int32.Parse(txtNo.Text.Trim());
        roleinfo.上级角色 = Int32.Parse(ddlPreRole.SelectedValue);

        Role role = new Role();
        role.RoleUpdateById(roleinfo);

        TreeView1.Nodes.Clear();
        Init_TreeView("1", "0");
        TreeView1.ExpandAll();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        string id = TreeView1.SelectedValue;

        if (String.IsNullOrEmpty(id))
        {
            if (!IsClientScriptBlockRegistered("Edit"))
            {
                RegisterClientScriptBlock("Edit", "<script>alert('未选择角色!')</script>");
                return;
            }
        }

        Role role = new Role();
        role.RoleDeleteById(Session["CID"].ToString(),id);

        TreeView1.Nodes.Clear();
        Init_TreeView("1", "0");
        TreeView1.ExpandAll();
    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        RoleInfo roleinfo = new RoleInfo();

        roleinfo.CID = Int32.Parse(Session["CID"].ToString());
        roleinfo.角色名称 = txtRoleName.Text.Trim();
        roleinfo.序号 = Int32.Parse(txtNo.Text.Trim());
        roleinfo.上级角色 = Int32.Parse(ddlPreRole.SelectedValue);

        Role role = new Role();
        role.RoleAdd(roleinfo);

        TreeView1.Nodes.Clear();
        Init_TreeView("1", "0");
        TreeView1.ExpandAll();

        Init_Data();

    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Init_TreeView("1", "0");
            Init_Data();
        }
    }
}
