﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Employees.aspx.cs" Inherits="Pages_System_Employees_Employees" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>左侧导航栏</title>
</head>
<body>
    <form id="form1" runat="server">
    <div style="margin:12px;">
        <asp:GridView ID=GridView1 runat=server Caption="员工列表"
                 OnSelectedIndexChanging=GridView1_SelectedIndexChanging
                 OnRowDeleting=GridView1_RowDeleting
                 OnRowDataBound=GridView1_RowDataBound
                 OnPageIndexChanging=GridView1_PageIndexChanging >
            <Columns>
                <asp:BoundField DataField="姓名" HeaderText="姓名" />
                <asp:BoundField DataField="登录名" HeaderText="登录名" />
                <asp:TemplateField HeaderText="部门">
                    <ItemTemplate>
                        <%#CRM.Common.InitData.GetDepartmentNameByID(Eval("部门").ToString())%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="角色">
                    <ItemTemplate>
                        <%#CRM.Common.InitData.GetRoleNameByID(Eval("角色").ToString())%>
                    </ItemTemplate>
                </asp:TemplateField>                 
                <asp:BoundField DataField="手机" HeaderText="手机" />
                <asp:BoundField DataField="住宅电话" HeaderText="住宅电话" />
                <asp:TemplateField HeaderText="所属权限组">
                    <ItemTemplate>
                        <%#CRM.Common.InitData.GetRightNameByID(Eval("所属权限组").ToString())%>
                    </ItemTemplate>
                </asp:TemplateField>                 
                <asp:TemplateField HeaderText="用户状态">
                    <ItemTemplate>
                        <%#Eval("用户状态").ToString().Replace("0","停用").Replace("1","正常")%>
                    </ItemTemplate>
                </asp:TemplateField>               
                <asp:BoundField DataField="备注" HeaderText="备注" />
                <asp:CommandField ShowSelectButton=True HeaderText="选择" ButtonType=image SelectImageUrl="../../../images/icon/edit.gif" ItemStyle-HorizontalAlign=center />            
                <asp:CommandField ShowDeleteButton=True HeaderText="删除" ButtonType=image DeleteImageUrl="../../../images/icon/del.gif" ItemStyle-HorizontalAlign=center/>
            </Columns>
        </asp:GridView>
    </div>
    <div style="margin:12px; margin-top:24px;">
        <table border=1 width=100%>
            <tr>
                <td>登录名</td><td><asp:TextBox ID=txtEmployeesLoginName runat=server /></td><td colspan=6><asp:Label ID=Lable1 runat=server ForeColor=red />
                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="登录名不能为空" ControlToValidate="txtEmployeesLoginName" Display="Dynamic"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="txtEmployeesLoginName"
                        Display="Dynamic" ErrorMessage="登录名长度6-24。合法符号0-9,a-z,A-Z" ValidationExpression="\w{6,24}"></asp:RegularExpressionValidator></td>
            </tr>
            <tr>
                <td width=8%>姓名</td><td width=16%><asp:TextBox ID=txtEmployeesName runat=server width=80/></td>
                <td width=8%>密码</td><td width=16%><asp:TextBox ID=txtEmployeesPWD runat=server width=80 TextMode=password Password=True/>
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="txtEmployeesPWD"
                        Display="Dynamic" ErrorMessage="密码长度为6-24" ValidationExpression="\w{6,24}"></asp:RegularExpressionValidator></td>
                <td width=9%>部门</td><td width=15%><asp:DropDownList ID=ddlDepartment runat=server /></td>
                <td width=8%>角色</td><td width=16%><asp:DropDownList ID=ddlRole runat=server /></td>
            </tr>
            <tr>
                <td>手机</td><td><asp:TextBox ID=txtMobile runat=server /></td>
                <td>住宅电话</td><td><asp:TextBox ID=txtTel runat=server /></td>
                <td >所属权限组</td><td><asp:DropDownList ID=ddlRight runat=server /></td>
                <td>用户状态</td><td><asp:DropDownList ID=ddlStatus runat=server >
                                          <asp:ListItem Text=正常 Value=1 />  
                                          <asp:ListItem Text="停用" Value=0 />                                        
                                       </asp:DropDownList>                
                </td>
            </tr>
            <tr>
                <td>备注</td><td colspan=7><asp:TextBox ID=txtBz runat=server Rows=3 TextMode=multiLine /></td>
            </tr>
            <tr>
                <td colspan=8 style="text-align:center;"><asp:Button ID=Button1 runat=server Text="添加" OnClick="Button1_Click" />
                    <asp:Button ID=Button2 runat=server Text=修改 OnClick=Button2_Click /></td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>

