﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using System.Text;
using CRM.BLL;
using CRM.Model;
using CRM.Common;


public partial class Pages_System_Employees_EmployeesRightConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        EmployeesRight employeesRight = new EmployeesRight();

        GridView1.DataSource = employeesRight.GetEmployeesRightByCid(Session["Cid"].ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;

        IList<EmployeesRightInfo> EmployeesRightinfo = new List<EmployeesRightInfo>();
        EmployeesRight employeesRight = new EmployeesRight();
        EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[index].Values["id"].ToString());

        if (EmployeesRightinfo.Count > 0)
        {
            txtEmployeesRightName.Text = EmployeesRightinfo[0].权限组名称;
            txtEmployeesRightNo.Text = EmployeesRightinfo[0].序号.ToString();
            if (EmployeesRightinfo[0].部门权限.IndexOf(",-1,") > -1) {
                rblDepartmentRight.SelectedValue = "-1";
            }
            else if (EmployeesRightinfo[0].部门权限.IndexOf(",0,") > -1)
            {
                rblDepartmentRight.SelectedValue = "0";
            }
            else {
                rblDepartmentRight.SelectedValue = "1";
                Panel1.Visible = true;
            }
        }
        TreeView1.Nodes.Clear();
        Init_TreeView("1", "0", index);

        TreeView2.Nodes.Clear();
        Init_TreeView2("1", "0", index);


    }
    protected void Init_Data(TreeNodeCollection tvNodes,int index)
    {
        //根据ID获取员工权限数据
        IList<EmployeesRightInfo> EmployeesRightinfo;
        EmployeesRight employeesRight = new EmployeesRight();
        EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[index].Values["id"].ToString());
        
        //if(EmployeesRightinfo.Count>0){
        string []  mRights = EmployeesRightinfo[0].权限.Split('|');
        //}        

        foreach (TreeNode temp in TreeView1.Nodes)
        {
            for (int i = 0; i < mRights.Length; i++) {
                if (temp.Value.IndexOf("p") > -1)
                {
                    if (mRights[i].IndexOf("|" + temp.Parent.Value.ToString() + ",") > -1)
                    {
                        if (mRights[i].IndexOf("," + temp.Value + ",") > -1)
                        {
                            temp.Checked = true;
                        }
                        else
                        {
                            temp.Checked = false;
                        }
                    }
                }
                else
                {
                    if (mRights[i].IndexOf("|" + temp.Value + ",") > -1)
                    {
                        temp.Checked = true;
                    }
                    else
                    {
                        temp.Checked = false;
                    }
                }
            }

            //if (temp.ChildNodes.Count > 0) {
            //    Init_Data(temp.ChildNodes,index);
            //}
            
        }
    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        EmployeesRight employeesRight = new EmployeesRight();
        employeesRight.EmployeesRightDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        EmployeesRightInfo EmployeesRightinfo = new EmployeesRightInfo();

        EmployeesRightinfo.权限组名称 = txtEmployeesRightName.Text.ToString();
        EmployeesRightinfo.序号 = Int32.Parse(txtEmployeesRightNo.Text.Trim());
        EmployeesRightinfo.权限 = "-1";
        EmployeesRightinfo.CID = Int32.Parse(Session["CID"].ToString());
        EmployeesRightinfo.员工权限 = ",";
        EmployeesRightinfo.部门权限 = ",";

        EmployeesRight employeesRight = new EmployeesRight();
        employeesRight.EmployeesRightAdd(EmployeesRightinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        IList<EmployeesRightInfo> EmployeesRightinfo;
        EmployeesRight employeesRight = new EmployeesRight();
        EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());

        if (EmployeesRightinfo.Count > 0)
        {

            EmployeesRightInfo employeesRightinfo = new EmployeesRightInfo();

            employeesRightinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
            employeesRightinfo.权限组名称 = txtEmployeesRightName.Text.ToString();
            employeesRightinfo.序号 = Int32.Parse(txtEmployeesRightNo.Text.Trim());
            employeesRightinfo.权限 = EmployeesRightinfo[0].权限;
            employeesRightinfo.部门权限 = EmployeesRightinfo[0].部门权限;
            employeesRightinfo.员工权限 = EmployeesRightinfo[0].员工权限;

            EmployeesRight employeesright = new EmployeesRight();
            employeesright.EmployeesRightUpdateById(employeesRightinfo);

            Bind();
        }
    }

    /// <summary>
    /// 初始化及重新绑定
    /// </summary>
    /// <param name="IsInit"></param>
    /// <param name="fid"></param>
    /// <param name="index"></param>
    protected void Init_TreeView(string IsInit, string fid,int index)
    {
        //如果index不为-1则为选择绑定权限组
        IList<EmployeesRightInfo> EmployeesRightinfo=new List<EmployeesRightInfo>();
        EmployeesRight employeesRight = new EmployeesRight();
        string mRights="";
        if (index != -1)
        {
            EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[index].Values["id"].ToString());
            mRights = EmployeesRightinfo[0].权限;
        }


        IList<CRM.Model.MenuInfo> menus;
        CRM.BLL.Menu menu = new CRM.BLL.Menu();
        menus = menu.GetMenuByFid(fid);

        for (int i = 0; i < menus.Count; i++)
        {
            TreeNode node = new TreeNode();
            node.Text = menus[i].菜单名称;
            node.Value = menus[i].ID.ToString();
            node.SelectAction = TreeNodeSelectAction.Expand;
            TreeView1.Nodes.Add(node);
            
            //判断是否选择左边权限组
            if (GridView1.SelectedIndex != null&&index!=-1) {
                if (EmployeesRightinfo.Count > 0)
                {
                    if (EmployeesRightinfo[0].权限.IndexOf("|" + node.Value + ",") > -1)
                    {
                        node.Checked = true;
                    }
                    else
                    {
                        node.Checked = false;
                    }
                }
            }
            
            //循环
            if (index != -1)
            {
                CreateNode(node, menus[i].ID.ToString(), index);
            }
            else
            {
                CreateNode(node, menus[i].ID.ToString(), -1);
            }

        }
    }

    protected void CreateNode(TreeNode node, string fid,int index)
    {
        IList<EmployeesRightInfo> EmployeesRightinfo = new List<EmployeesRightInfo>();
        EmployeesRight employeesRight = new EmployeesRight();
        string mRights = "";
        if (index != -1)
        {
            EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[index].Values["id"].ToString());
            mRights = EmployeesRightinfo[0].权限;
        }

        //IList<CRM.Model.PagesRightInfo> PagesRightinfo;
        //CRM.BLL.PagesRight pagesRight = new PagesRight();
        //PagesRightinfo = pagesRight.GetPagesRightByPid(node.Value.ToString());
        //for (int j = 0; j < PagesRightinfo.Count; j++)
        //{
        //    TreeNode pagesRightNode = new TreeNode();
        //    pagesRightNode.Text = PagesRightinfo[j].操作名称;
        //    pagesRightNode.Value = "p"+PagesRightinfo[j].ID.ToString();
        //    node.ChildNodes.Add(pagesRightNode);

        //    if (index != -1&&EmployeesRightinfo.Count>0)
        //    {
        //        string [] rights = mRights.Split('|');
        //        for (int i = 0; i < rights.Length; i++)
        //        {
        //            string str = "|" + rights[i];
        //            if (str.IndexOf("|" + node.Value.ToString() + ",") > -1)
        //            {
        //                if (str.IndexOf("," + pagesRightNode.Value + ",") > -1)
        //                {
        //                    pagesRightNode.Checked = true;
        //                }
        //                else
        //                {
        //                    pagesRightNode.Checked = false;
        //                }
        //                break;
        //            }
        //        }
        //    }

        //}

        IList<CRM.Model.MenuInfo> childs;
        CRM.BLL.Menu child = new CRM.BLL.Menu();
        childs = child.GetMenuByFid(fid);

        for (int i = 0; i < childs.Count; i++)
        {
            TreeNode childNode = new TreeNode();
            childNode.Text = childs[i].菜单名称;
            childNode.Value = childs[i].ID.ToString();
            childNode.SelectAction = TreeNodeSelectAction.Expand;

            node.ChildNodes.Add(childNode);
            //判断是否选择左边权限组
            if (index != -1)
            {
                if (EmployeesRightinfo.Count > 0)
                {
                    if (EmployeesRightinfo[0].权限.IndexOf("|" + childNode.Value + ",") > -1)
                    {
                        childNode.Checked = true;
                    }
                    else
                    {
                        childNode.Checked = false;
                    }
                }
            }
            //循环
            if (index != -1)
            {
                CreateNode(childNode, childs[i].ID.ToString(), index);
            }
            else {
                CreateNode(childNode, childs[i].ID.ToString(), -1);
            }
        }
    }

    protected void TreeView1_TreeNodeCheckChanged(object sender,TreeNodeEventArgs e) {
        if (GridView1.SelectedValue==null)
        {
            if (!IsClientScriptBlockRegistered("IsSelectRightGroup"))
                RegisterClientScriptBlock("IsSelectRightGroup", "<script>alert('请选择权限组!')</script>");
            return;
        }
        //清空员工权限数据
        IList<EmployeesRightInfo> EmployeesRightinfo;
        EmployeesRight employeesRight = new EmployeesRight();
        EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
        if (EmployeesRightinfo.Count > 0)
        {
            EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
            employeesrightinfo.ID = EmployeesRightinfo[0].ID;
            employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
            employeesrightinfo.权限 = ",";
            employeesrightinfo.序号 = EmployeesRightinfo[0].序号;
            employeesrightinfo.部门权限 = EmployeesRightinfo[0].部门权限;
            employeesrightinfo.员工权限 = EmployeesRightinfo[0].员工权限;

            employeesRight.EmployeesRightUpdateById(employeesrightinfo);
        }

        Check(TreeView1.CheckedNodes);
    }

    protected void Check(TreeNodeCollection tvNodes)
    {
        foreach (TreeNode temp in tvNodes)
        {
            #region  检查每一个选择框是否选中，选中的加入，没选中的去掉。
            if (temp.Checked == true)
            {
                //执行操作  
                #region 判断是菜单还是页面操作
                string id = temp.Value.ToString();
                if (id.IndexOf("p") > -1) //选择的是页面操作,只有1个P，索引为0，如果用id.IndexOf("p")>0则始终不行。
                {
                    string pid = temp.Parent.Value.ToString();

                    //根据ID获取员工权限数据
                    IList<EmployeesRightInfo> EmployeesRightinfo;
                    EmployeesRight employeesRight = new EmployeesRight();
                    EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
                    if (EmployeesRightinfo.Count > 0)
                    {
                        string rights = EmployeesRightinfo[0].权限;
                        string menurights = ",|" + pid + ",";
                        if (rights.IndexOf(menurights) > -1)
                        {
                            rights = rights.Replace("," + id + ",", ",");//不管是否已经添加此页面操作，先去掉后加。在页面操作与菜单上用在页面指令前添加"p"区分
                            rights = rights.Replace(menurights, menurights + id + ",");
                        }
                        else
                        {
                            rights = rights + "|" + pid + "," + id+ ",";
                        }
                        //rights = rights.Replace(menurights, menurights + id + ",");

                        EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
                        employeesrightinfo.ID = EmployeesRightinfo[0].ID;
                        employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
                        employeesrightinfo.权限 = rights;
                        employeesrightinfo.序号 = EmployeesRightinfo[0].序号;
                        employeesrightinfo.部门权限 = EmployeesRightinfo[0].部门权限;
                        employeesrightinfo.员工权限 = EmployeesRightinfo[0].员工权限;


                        employeesRight.EmployeesRightUpdateById(employeesrightinfo);
                    }

                }
                else  //选择的是菜单操作
                {
                    //根据ID获取员工权限数据
                    IList<EmployeesRightInfo> EmployeesRightinfo;
                    EmployeesRight employeesRight = new EmployeesRight();
                    EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
                    if (EmployeesRightinfo.Count > 0)
                    {
                        string rights = EmployeesRightinfo[0].权限;
                        string menurights = ",|" + temp.Value.ToString() + ",";
                        if (rights.IndexOf(menurights) < 0)
                        {
                            rights = rights + "|" + temp.Value.ToString() + ",";
                        }
                        //rights = rights.Replace(menurights, menurights + id + ",");

                        EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
                        employeesrightinfo.ID = EmployeesRightinfo[0].ID;
                        employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
                        employeesrightinfo.权限 = rights;
                        employeesrightinfo.序号 = EmployeesRightinfo[0].序号;
                        employeesrightinfo.部门权限 = EmployeesRightinfo[0].部门权限;
                        employeesrightinfo.员工权限 = EmployeesRightinfo[0].员工权限;


                        employeesRight.EmployeesRightUpdateById(employeesrightinfo);
                    }
                }
                #endregion
             }
                //else { 
                //    //执行操作
                //}
            #endregion
                if (temp.ChildNodes.Count != 0)
                {
                    Check(temp.ChildNodes);
                }
            }
        }

    protected void RadioButtonList_TextChanged(object sender,EventArgs e) {
        if (GridView1.SelectedValue==null)
        {
            if (!IsClientScriptBlockRegistered("IsSelectRightGroup"))
                RegisterClientScriptBlock("IsSelectRightGroup", "<script>alert('请选择权限组!')</script>");
            return;
        }

        if (rblDepartmentRight.SelectedValue == "1")
        {
            Panel1.Visible = true;
        }
        else {
            Panel1.Visible = false;

            //清空员工权限数据
            IList<EmployeesRightInfo> EmployeesRightinfo;
            EmployeesRight employeesRight = new EmployeesRight();
            EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
            if (EmployeesRightinfo.Count > 0)
            {
                EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
                employeesrightinfo.ID = EmployeesRightinfo[0].ID;
                employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
                employeesrightinfo.权限 = EmployeesRightinfo[0].权限;
                employeesrightinfo.部门权限 = "," + rblDepartmentRight.SelectedValue + ",";
                employeesrightinfo.员工权限 = ",";
                employeesrightinfo.序号 = EmployeesRightinfo[0].序号;

                employeesRight.EmployeesRightUpdateById(employeesrightinfo);
            }
        }
    }

    protected void Init_TreeView2(string IsInit, string fid, int index)
    {
        //如何index不为-1则为选择绑定权限组
        IList<EmployeesRightInfo> EmployeesRightinfo = new List<EmployeesRightInfo>();
        EmployeesRight employeesRight = new EmployeesRight();
        string mRights = "";
        if (index != -1)
        {
            EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[index].Values["id"].ToString());
            mRights = EmployeesRightinfo[0].权限;
        }


        IList<CRM.Model.DepartmentInfo> departments;
        CRM.BLL.Department department = new CRM.BLL.Department();
        departments = department.GetDepartmentByFid(Session["CID"].ToString(), fid);

        for (int i = 0; i < departments.Count; i++)
        {
            TreeNode node = new TreeNode();
            node.Text = departments[i].部门名称;
            node.Value = departments[i].ID.ToString();
            node.SelectAction = TreeNodeSelectAction.Expand;
            TreeView2.Nodes.Add(node);

            #region 判断是否选择左边权限组
            if (GridView1.SelectedIndex != null && index != -1)
            {
                if (EmployeesRightinfo.Count > 0)
                {
                    if (EmployeesRightinfo[0].部门权限.IndexOf("," + node.Value + ",") > -1)
                    {
                        node.Checked = true;
                    }
                    else
                    {
                        node.Checked = false;
                    }
                }
            }
            #endregion

            //循环
            if (index != -1)
            {
                CreateNode2(node, departments[i].ID.ToString(), index);
            }
            else
            {
                CreateNode2(node, departments[i].ID.ToString(), -1);
            }

        }
    }

    protected void CreateNode2(TreeNode node, string fid, int index)
    {
        IList<EmployeesRightInfo> EmployeesRightinfo = new List<EmployeesRightInfo>();
        EmployeesRight employeesRight = new EmployeesRight();
        string mRights = "";
        string eRights = "";
        if (index != -1)
        {
            EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[index].Values["id"].ToString());
            mRights = EmployeesRightinfo[0].部门权限;
            eRights = EmployeesRightinfo[0].员工权限;
            
        }

        #region 员工选择
        IList<CRM.Model.EmployeesInfo> Employeesinfo;
        CRM.BLL.Employees employees = new Employees();
        Employeesinfo =employees.GetEmployeesByDepatID(Session["CID"].ToString(),node.Value.ToString());
        for (int j = 0; j < Employeesinfo.Count; j++)
        {
            TreeNode pagesRightNode = new TreeNode();
            pagesRightNode.Text = Employeesinfo[j].姓名;
            pagesRightNode.Value = "e" + Employeesinfo[j].EID.ToString();
            node.ChildNodes.Add(pagesRightNode);
            if (index != -1 && Employeesinfo.Count > 0)
            {
                
              if (eRights.IndexOf("," + Employeesinfo[j].EID.ToString() + ",") > -1)
              {
                  pagesRightNode.Checked = true;
              }
              else
              {
                  pagesRightNode.Checked = false;
              }
            }
        }

        #endregion

        IList<CRM.Model.DepartmentInfo> departments;
        CRM.BLL.Department department = new CRM.BLL.Department();
        departments = department.GetDepartmentByFid(Session["CID"].ToString(), fid);

        for (int i = 0; i < departments.Count; i++)
        {
            TreeNode childNode = new TreeNode();
            childNode.Text = departments[i].部门名称;
            childNode.Value = departments[i].ID.ToString();
            childNode.SelectAction = TreeNodeSelectAction.Expand;

            node.ChildNodes.Add(childNode);
            //判断是否选择左边权限组
            if (index != -1)
            {
                if (EmployeesRightinfo.Count > 0)
                {
                    if (EmployeesRightinfo[0].部门权限.IndexOf("," + childNode.Value + ",") > -1)
                    {
                        childNode.Checked = true;
                    }
                    else
                    {
                        childNode.Checked = false;
                    }
                }
            }
            //循环
            if (index != -1)
            {
                CreateNode2(childNode, departments[i].ID.ToString(), index);
            }
            else
            {
                CreateNode2(childNode, departments[i].ID.ToString(), -1);
            }
        }
    }

    protected void TreeView2_TreeNodeCheckChanged(object sender, TreeNodeEventArgs e)
    {
        if (GridView1.SelectedValue==null)
        {
            if (!IsClientScriptBlockRegistered("IsSelectRightGroup"))
                RegisterClientScriptBlock("IsSelectRightGroup", "<script>alert('请选择权限组!')</script>");
            return;
        }
        //清空员工权限数据
        IList<EmployeesRightInfo> EmployeesRightinfo;
        EmployeesRight employeesRight = new EmployeesRight();
        EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
        if (EmployeesRightinfo.Count > 0)
        {
            EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
            employeesrightinfo.ID = EmployeesRightinfo[0].ID;
            employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
            employeesrightinfo.权限 = EmployeesRightinfo[0].权限;
            employeesrightinfo.部门权限 = ",";
            employeesrightinfo.员工权限 = ",";
            employeesrightinfo.序号 = EmployeesRightinfo[0].序号;

            employeesRight.EmployeesRightUpdateById(employeesrightinfo);
        }

        Check2(TreeView2.CheckedNodes);
    }

    protected void Check2(TreeNodeCollection tvNodes)
    {
        foreach (TreeNode temp in tvNodes)
        {
            #region  检查每一个选择框是否选中，选中的加入，没选中的去掉。
            if (temp.Checked == true)
            {
                //执行操作  
                #region 判断是部门还是员工
                string id = temp.Value.ToString();
                if (id.IndexOf("e") > -1) //选择的是员工操作,只有1个e，索引为0，如果用id.IndexOf("e")>0则始终不行。
                {
                    string pid = temp.Parent.Value.ToString();

                    //根据ID获取员工权限数据
                    IList<EmployeesRightInfo> EmployeesRightinfo;
                    EmployeesRight employeesRight = new EmployeesRight();
                    EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
                    if (EmployeesRightinfo.Count > 0)
                    {
                        string rights = EmployeesRightinfo[0].员工权限;
                        if (rights.IndexOf(","+id.Replace("e","")+",") <0)
                        {
                            rights = rights + id.Replace("e", "") + ",";
                        }

                        EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
                        employeesrightinfo.ID = EmployeesRightinfo[0].ID;
                        employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
                        employeesrightinfo.权限 = EmployeesRightinfo[0].权限;
                        employeesrightinfo.序号 = EmployeesRightinfo[0].序号;
                        employeesrightinfo.部门权限 = EmployeesRightinfo[0].部门权限;
                        employeesrightinfo.员工权限 = rights;

                        employeesRight.EmployeesRightUpdateById(employeesrightinfo);
                    }

                }
                else  //选择的是部门权限
                {
                    //根据ID获取员工权限数据
                    IList<EmployeesRightInfo> EmployeesRightinfo;
                    EmployeesRight employeesRight = new EmployeesRight();
                    EmployeesRightinfo = employeesRight.GetEmployeesRightById(GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString());
                    if (EmployeesRightinfo.Count > 0)
                    {
                        string rights = EmployeesRightinfo[0].部门权限;
                        string menurights = "," + temp.Value.ToString() + ",";
                        if (rights.IndexOf(menurights) < 0)
                        {
                            rights = rights + temp.Value.ToString() + ",";
                        }

                        EmployeesRightInfo employeesrightinfo = new EmployeesRightInfo();
                        employeesrightinfo.ID = EmployeesRightinfo[0].ID;
                        employeesrightinfo.权限组名称 = EmployeesRightinfo[0].权限组名称;
                        employeesrightinfo.权限 = EmployeesRightinfo[0].权限;
                        employeesrightinfo.序号 = EmployeesRightinfo[0].序号;
                        employeesrightinfo.部门权限 = rights;
                        employeesrightinfo.员工权限 = EmployeesRightinfo[0].员工权限;

                        employeesRight.EmployeesRightUpdateById(employeesrightinfo);
                    }
                }
                #endregion
            }
            //else { 
            //    //执行操作
            //}
            #endregion
            if (temp.ChildNodes.Count != 0)
            {
                Check(temp.ChildNodes);
            }
        }
    }
        
    protected void Page_Load(object sender, EventArgs e)
    {
        TreeView1.Attributes.Add("onclick", "postBackCheckBox()");
        TreeView2.Attributes.Add("onclick", "postBackCheckBox()");
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Init_TreeView2("1", "0",-1);
            Init_TreeView("1", "0",-1);
            Bind();
        }
    }
}
