﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using System.Text;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_System_Employees_PagesRightConfig : System.Web.UI.Page
{
    protected void Bind()
    {
        PagesRight pagesRight = new PagesRight();

        GridView1.DataSource = pagesRight.GetPagesRightByPid(TreeView1.SelectedValue.ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        int index = e.NewSelectedIndex;


        IList<PagesRightInfo> PagesRightinfo = new List<PagesRightInfo>();

        PagesRight pagesRight = new PagesRight();
        PagesRightinfo = pagesRight.GetPagesRightById(GridView1.DataKeys[index].Values["id"].ToString());

        if (PagesRightinfo.Count > 0)
        {
            txtPagesRightName.Text = PagesRightinfo[0].操作名称;
            txtPagesRightNo.Text = PagesRightinfo[0].序号.ToString();
        }
    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        PagesRight PagesRight = new PagesRight();
        PagesRight.PagesRightDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        PagesRightInfo PagesRightinfo = new PagesRightInfo();

        PagesRightinfo.操作名称 = txtPagesRightName.Text.ToString();
        PagesRightinfo.序号 = Int32.Parse(txtPagesRightNo.Text.Trim());
        PagesRightinfo.PID = Int32.Parse(TreeView1.SelectedValue.ToString());

        PagesRight pagesRight = new PagesRight();
        pagesRight.PagesRightAdd(PagesRightinfo);

        Bind();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        int index = GridView1.SelectedIndex;

        PagesRightInfo PagesRightinfo = new PagesRightInfo();

        PagesRightinfo.ID = Int32.Parse(GridView1.DataKeys[index].Values["id"].ToString());
        PagesRightinfo.操作名称 = txtPagesRightName.Text.ToString();
        PagesRightinfo.序号 = Int32.Parse(txtPagesRightNo.Text.Trim());

        PagesRight eagesRight = new PagesRight();
        eagesRight.PagesRightUpdateById(PagesRightinfo);

        Bind();
    }

    protected void Init_TreeView(string IsInit, string fid)
    {

        IList<CRM.Model.MenuInfo> menus;
        CRM.BLL.Menu menu = new CRM.BLL.Menu();
        menus = menu.GetMenuByFid(fid);

        for (int i = 0; i < menus.Count; i++)
        {
            TreeNode node = new TreeNode();
            node.Text = menus[i].菜单名称;
            node.Value = menus[i].ID.ToString();
            node.SelectAction = TreeNodeSelectAction.SelectExpand;
            //node.ImageUrl = menus[i].菜单图片;
            //DataTable dt = CRM.Common.InitData.GetEmployeesRight(Session["LoginID"].ToString());
            //if (dt.Rows[0]["权限"].ToString().IndexOf("|" + menus[i].ID.ToString() + ",") >= 0)
            //{
                TreeView1.Nodes.Add(node);
            //}

            CreateNode(node, menus[i].ID.ToString());
        }
    }

    protected void CreateNode(TreeNode node, string fid)
    {
        IList<CRM.Model.MenuInfo> childs;
        CRM.BLL.Menu child = new CRM.BLL.Menu();
        childs = child.GetMenuByFid(fid);

        for (int i = 0; i < childs.Count; i++)
        {
            TreeNode childNode = new TreeNode();
            childNode.Text = childs[i].菜单名称;
            childNode.Value = childs[i].ID.ToString();
            childNode.SelectAction = TreeNodeSelectAction.SelectExpand;

            node.ChildNodes.Add(childNode);

            CreateNode(childNode, childs[i].ID.ToString());

        }


    }

    protected void TreeView1_SelectedNodeChanged(object sender,EventArgs e) {
        txtSelectedPage.Text = TreeView1.SelectedNode.Text;
        Bind();
    }

    protected void TreeView1_TreeNodeCheckChanged(object sender, TreeNodeEventArgs e)
    {
        txtSelectedPage.Text = TreeView1.SelectedValue;

        Bind();
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Init_TreeView("1", "0");
            Bind();
        }
    }
}
