﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Register.aspx.cs" Inherits="Register" MasterPageFile="~/MasterPage.master" %>

<asp:Content ContentPlaceHolderID=contentPlaceHolder runat=server>
    <div>
        <table border=1 style=" margin-left:auto; margin-right:auto; width:400px;" >
                <tr>
                    <td colspan=2 class=Caption style="border:0px;">请填写注册信息</td>
                </tr>
                <tr>
                    <td>用户名</td><td><asp:TextBox ID=txtUsername runat=server EnableTheming=false Width=120 />
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" 
                                    ErrorMessage="用户名不能为空" 
                                    ControlToValidate="txtUsername" Display="Dynamic" />
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="txtUsername"
                            Display="Dynamic" ErrorMessage="用户名长度为6-24" ValidationExpression="\w{6,24}"></asp:RegularExpressionValidator></td>
                </tr>
                <tr>
                    <td>密码</td><td><asp:TextBox ID=txtPassword1 runat=server EnableTheming=false Width=120 TextMode="Password" />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="txtPassword1"
                            ErrorMessage="密码不能为空"></asp:RequiredFieldValidator></td>
                </tr>
                <tr>
                    <td>重复密码</td><td><asp:TextBox ID=txtPassword2 runat=server EnableTheming=false Width=120 TextMode="Password" /><asp:CompareValidator
                            ID="CompareValidator1" runat="server" ErrorMessage="两次输入的密码不一样！" ControlToCompare=txtPassword2 ControlToValidate=txtPassword1 Display="Dynamic"></asp:CompareValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="txtPassword2"
                            Display="Dynamic" ErrorMessage="密码长度为6-24" ValidationExpression="\w{6,24}"></asp:RegularExpressionValidator></td>
                </tr>
                <tr>
                    <td width=80>客户名称</td><td><asp:TextBox ID=txtClientName runat=server/></td>
                </tr>
                <tr style="display:none;">
                    <td>省份/地区</td><td><asp:DropDownList ID=ddlProvince runat=server OnTextChanged="ddlProvince_TextChanged" AutoPostBack=true Width=120 EnableTheming=false /><asp:DropDownList ID=ddlCity runat=server Width=120 EnableTheming=false /></td>
                </tr>
                <tr>
                    <td width=80>详细地址</td><td><asp:TextBox ID=txtAddr runat=server /></td>
                </tr>
                <tr>
                    <td width=80>主联系人</td><td><asp:TextBox ID=txtContacter runat=server /></td>
                </tr>
                <tr style="display:none;">
                    <td>部门</td><td><asp:TextBox ID=txtContactDepartment runat=server /></td>
                </tr>
                <tr style="display:none;">
                    <td>职务</td><td><asp:TextBox ID=txtContactRole runat=server /></td>
                </tr>
                <tr>
                    <td width=80>联系手机</td><td><asp:TextBox ID=txtContactMobile runat=server /></td>
                </tr>
                <tr>
                    <td >客户电话</td><td><asp:TextBox ID=txtClientTel runat=server /></td>
                </tr>
                <tr>
                    <td>客户传真</td><td ><asp:TextBox ID=txtClientSax runat=server /></td>
                </tr>
                <tr>
                    <td>电子邮箱</td><td><asp:TextBox ID=txtClientEmail runat=server />
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator3" runat="server" ControlToValidate="txtClientEmail"
                            Display="Dynamic" ErrorMessage="电子邮箱格式不对" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="txtClientEmail"
                            Display="Dynamic" ErrorMessage="电子邮件不能为空"></asp:RequiredFieldValidator></td>
                </tr>
                <tr style="display:none;">
                    <td>客户类型</td><td><asp:DropDownList ID=ddlClientType runat=server Width=120 /></td>
                </tr>
                <tr style="display:none;">
                    <td>客户阶段</td><td><asp:DropDownList ID=ddlClientPhase runat=server Width=120/></td>
                </tr>
                <tr style="display:none;">
                    <td>客户状态</td><td><asp:DropDownList ID=ddlClientStatus runat=server Width=120 /></td>
                </tr>
                <tr style="display:none;">
                    <td>客户级别</td><td><asp:DropDownList ID=ddlClientRank runat=server Width=120 /></td>
                </tr>
                <tr>
                    <td>备注</td><td><asp:TextBox ID=txtBz runat=server Rows=3 TextMode=multiLine /></td>
                </tr>
                    <tr>
                        <td>验证码</td><td><asp:TextBox ID=txtValidator runat=server EnableTheming=false Width=120 />                            
                            <asp:Image ID=Image1 runat=server src="ValidatorRegister.aspx" />
                        </td>
                    </tr>
                    <asp:Panel ID=Panel1 runat=server Visible=false >
                        <tr>
                            <td style="color:Red;" colspan=2>验证码输入错误！</td>
                        </tr>
                    </asp:Panel>
                <tr>
                    <td colspan=2 style="text-align:center;"><asp:Button ID=Button1 runat=server Text="提交" OnClick=Button1_Click/>
                        <asp:Button ID=Button2 runat=server Text=重置  />&nbsp;&nbsp;
                        </td>
                </tr>
            </table>            
    </div>
</asp:Content>

