﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;
using System.Data.SqlClient;

public partial class Register : System.Web.UI.Page
{

    protected void InitData()
    {
        ddlClientType.DataSource = CRM.Common.InitData.InitData_ClientType(Session["CID"].ToString());
        ddlClientType.DataTextField = "客户类型";
        ddlClientType.DataValueField = "id";
        ddlClientType.DataBind();

        ddlClientPhase.DataSource = CRM.Common.InitData.InitData_ClientPhase(Session["CID"].ToString());
        ddlClientPhase.DataTextField = "客户阶段";
        ddlClientPhase.DataValueField = "id";
        ddlClientPhase.DataBind();

        ddlClientStatus.DataSource = CRM.Common.InitData.InitData_ClientStatus(Session["CID"].ToString());
        ddlClientStatus.DataTextField = "客户状态";
        ddlClientStatus.DataValueField = "id";
        ddlClientStatus.DataBind();

        ddlClientRank.DataSource = CRM.Common.InitData.InitData_ClientRank(Session["CID"].ToString());
        ddlClientRank.DataTextField = "客户级别";
        ddlClientRank.DataValueField = "id";
        ddlClientRank.DataBind();

        ddlProvince.DataSource = CRM.Common.InitData.GetProvinceByCid(Session["CID"].ToString());
        ddlProvince.DataTextField = "名称";
        ddlProvince.DataValueField = "id";
        ddlProvince.DataBind();

        ddlCity.DataSource = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        ddlCity.DataTextField = "名称";
        ddlCity.DataValueField = "id";
        ddlCity.DataBind();


    }
    protected void ddlProvince_TextChanged(object sender, EventArgs e)
    {
        ddlCity.DataSource = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        ddlCity.DataTextField = "名称";
        ddlCity.DataValueField = "id";
        ddlCity.DataBind();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        if (txtValidator.Text.Trim() != Session["Validator"].ToString().Trim())
        {
            //Panel1.Visible = true;
            RegisterClientScriptBlock("", "<script>alert('验证码错误');window.location.href='Register.aspx'</script>");
        }
        #region 通过验证
        else
        {
            SystemUserInfo SystemUserinfo = new SystemUserInfo();

            SystemUserinfo.用户名 = txtUsername.Text.Trim();
            SystemUserinfo.密码 = txtPassword1.Text.Trim();
            SystemUserinfo.客户名称 = txtClientName.Text;
            SystemUserinfo.客户电话 = txtClientTel.Text;
            SystemUserinfo.客户传真 = txtClientSax.Text;
            SystemUserinfo.主联系人 = txtContacter.Text;
            SystemUserinfo.联系手机 = txtContactMobile.Text;
            SystemUserinfo.详细地址 = txtAddr.Text;
            SystemUserinfo.电子邮箱 = txtClientEmail.Text;
            SystemUserinfo.客户类型 = -1;
            SystemUserinfo.客户阶段 = -1;
            SystemUserinfo.客户状态 = -1;
            SystemUserinfo.客户级别 = -1;
            SystemUserinfo.备注 = txtBz.Text.Trim();
            SystemUserinfo.部门 = txtContactDepartment.Text.Trim();
            SystemUserinfo.职务 = txtContactRole.Text.Trim();
            SystemUserinfo.省份 = -1;
            SystemUserinfo.地区 = -1;

            string existence = CRM.Common.InitData.CheckLoginNameExistence(txtUsername.Text.Trim());
            if (existence == "")
            {
                SystemUser systemuser = new SystemUser();
                systemuser.SystemUserAdd(SystemUserinfo);
                string cid = CRM.Common.InitData.GetIDENTITY("cid", "系统用户表", "cid");

                string sql = "insert into 员工表(cid,登录名,密码,boss) values(@cid,@登录名,@密码,'1')";
                SqlParameter[] paras = new SqlParameter[4];
                paras[0] = new SqlParameter("cid", cid);
                paras[1] = new SqlParameter("登录名", txtUsername.Text.Trim());
                paras[2] = new SqlParameter("密码", txtPassword1.Text.Trim());
                CRM.DBUtility.SqlHelper.ExecuteNonQuery(CRM.DBUtility.SqlHelper.connstr, CommandType.Text, sql, paras);

                if (!Page.ClientScript.IsClientScriptBlockRegistered("AddUsername"))
                {
                    Page.RegisterClientScriptBlock("AddUsername", "<script>alert('注册成功！请登录');window.location.href='Default.aspx'</script>");
                }
            }
            else
            {
                if (!Page.ClientScript.IsClientScriptBlockRegistered("UsernameExistence"))
                {
                    Page.RegisterClientScriptBlock("UsernameExistence", "<script>alert('用户已存在!')</script>");
                }
            }
        }
        #endregion
        //ClearData();

    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) {
            string checkCode = CRM.Common.Validator.Validator.GetString(4);
            Session["Validator"] = checkCode;
        }
    }
}
