﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using System.Text;
namespace BLL.Models
{
    public class MClassModels
    {
        string[] str_files = new string[] { "ID", "ClassName", "ParentId", "Depth", "RootId", "OrderId", "Readme", "Child", "Intro" };

        /// <summary>
        /// 添加信息
        /// </summary>
        /// <param name="?"></param>
        /// <returns></returns>
        public bool AddClassinfo(MODEL.MClassInfo model) {
        
            bool ret=false;
            model.RootId = 0;
            model.Child = 0;
            model.Depth = GetDepth(model.ParentId.ToString()) ;
            model.Readme = "";
            model.OrderId = 0;
            string str_sql = "insert into [tb_mc_class] (ClassName, ParentId, Depth, RootId, OrderId, Readme, Child, Intro)values('"+model.ClassName+"', "+model.ParentId.ToString()+", "+model.Depth.ToString()+", "+model.RootId.ToString()+", "+model.OrderId.ToString()+", '"+model.Readme+"', "+model.Child.ToString()+", '"+model.Intro+"')";
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            try
            {
                db.ExecuteNonQuery(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql);
                ret = true;
            }
            catch (Exception ex) { }
            return ret;
        }
        /// <summary>
        /// 修改一条信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool EditClassInfo(MODEL.MClassInfo model) {

            bool ret = false;
            model.RootId = 0;
            model.Child = 0;
            model.Depth = 0;
            model.Readme = "";
            model.OrderId = 0;
            string str_sql = " update [tb_mc_class] set ClassName='"+model.ClassName+"', ParentId="+model.ParentId.ToString()+", Depth="+model.Depth.ToString()+", RootId="+model.RootId.ToString()+", OrderId="+model.OrderId.ToString()+", Readme='"+model.Readme+"', Child="+model.Child.ToString()+", Intro='"+model.Intro+"' where id= " + model.ID;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            try
            {
                db.ExecuteNonQuery(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql);
                ret = true;
            }
            catch (Exception ex) { }
            return ret;
        }
        /// <summary>
        /// 分页列表一个信息
        /// </summary>
        /// <param name="start"></param>
        /// <param name="limit"></param>
        /// <param name="fiter"></param>
        /// <returns></returns>
        public string GetAllInfo(string start,string limit,string fiter) {
            string fiternew = " 1=1 and " + fiter + " parentid=0 ";
            string ret = string.Empty;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_sql = "  select top " + limit + " * from [tb_mc_class] where " + fiternew + " and id not in ( select top " + start + " id from [tb_mc_class] where  " + fiternew + "  order by id  ) order by id   ";
            str_sql = start == "0" ? "  select top " + limit + " * from [tb_mc_class] where " + fiternew + "  order by id " : str_sql;
            DataTable dt = new DataTable();
            string tcount = "0";
            try
            {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
                tcount = db.ExecuteScalar(COMM.PucConfig.ConnectionStringA, CommandType.Text, "select count(*) from [tb_mc_class]").ToString();
            }
            catch (Exception ex) { }
            BLL.JSONHelper jsons = new BLL.JSONHelper();
            jsons.AddItem("ClassName","根分类");
            jsons.AddItem("ID","0");
            jsons.ItemOk();
            BuildAllClassJsons(ref jsons, dt, fiter);

            jsons.totlalCount = Convert.ToInt32(tcount);
            ret = jsons.ToString();
            return ret;
        }
        /// <summary>
        /// 构造jsons字符串
        /// </summary>
        /// <param name="jsons"></param>
        /// <param name="dt"></param>
        /// <param name="fiter"></param>
        private void BuildAllClassJsons(ref BLL.JSONHelper jsons,DataTable dt,string fiter) {

            if (dt.Rows.Count == 0) {

                return;
            } else {

                foreach (DataRow dr in dt.Rows)
                {

                    foreach (string s in str_files)
                    {
                        if (s == "ClassName")//处理分类名称树形结构
                        {

                            StringBuilder str_classnane = new StringBuilder();
                            str_classnane.Append("├");
                            str_classnane.Append("─");
                            int depth = Convert.ToInt32(dr["depth"].ToString());
                            for (int i = 0; i < depth; i++)
                            {

                                str_classnane.Append("├");
                                str_classnane.Append("─");
                            }
                            str_classnane.Append(dr["classname"].ToString());
                            jsons.AddItem(s, str_classnane.ToString());

                        }else{
                        
                            jsons.AddItem(s, dr[s].ToString());
                        }
                        
                    }
                    jsons.ItemOk();
                    DataTable dtn = GetClassByPidAndFiter(dr["id"].ToString(), fiter);
                    BuildAllClassJsons(ref jsons, dtn, fiter);
                }
            
            }
        }
        /// <summary>
        /// 构造字符串
        /// </summary>
        /// <param name="pid"></param>
        /// <param name="fiter"></param>
        /// <returns></returns>
        public DataTable GetClassByPidAndFiter(string pid,string fiter){
        
                        string fiternew = " 1=1 and " + fiter + " parentid="+pid;
            string ret = string.Empty;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_sql = "  select  * from [tb_mc_class] where " + fiternew + "  order by id   ";
            DataTable dt = new DataTable();
            try
            {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }
            return dt;
        }
        /// <summary>
        /// 取得一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetinfoById(string id) {

            string ret = string.Empty;
            string str_sql = " select * from [tb_mc_class] where id="+id;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            DataTable dt = new DataTable();
            try
            {
               dt= db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }
            BLL.FormJSONHelper jsons = new BLL.FormJSONHelper();
            jsons.success = true;


            foreach (DataRow dr in dt.Rows)
            {

                foreach (string s in str_files)
                {

                    jsons.AddItem(s, dr[s].ToString());
                }
                jsons.ItemOk();

            }



            ret = jsons.ToString();
            return ret;
        }
        /// <summary>
        /// 删除一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool DeleteById(string id) {

            bool ret = false;
            string str_sql = " delete from [tb_mc_class] where [issystem]<>1 and id in("+id+") ";
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            try
            {
                db.ExecuteNonQuery(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql);
                ret = true;
            }
            catch (Exception ex) { }
            return ret;

        }
        /// <summary>
        /// 根据父id取得内容
        /// </summary>
        /// <param name="Pid"></param>
        /// <returns></returns>
        public string GetInfoByPid(string Pid) {

            string ret = string.Empty;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            DataTable dt = new DataTable();
            dt = GetClassinfoByparentid(Convert.ToInt32(Pid));


            BLL.JSONHelper jsons = new BLL.JSONHelper();


            jsons.AddItem("ID", "0");
            jsons.AddItem("ClassName", "根分类");
            jsons.ItemOk();

            BuildClassInfo(ref jsons, dt);
            ret = jsons.ToString();
            return ret;
        }
        /// <summary>
        /// 获得商品分类
        /// </summary>
        /// <returns></returns>
        public string GetInfoProductinfo()
        {

            string ret = string.Empty;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            DataTable dt = new DataTable();
           
            dt = GetClassByPidAndFiter("0", " issystem=0 and ");


            BLL.JSONHelper jsons = new BLL.JSONHelper();


            jsons.AddItem("ID", "0");
            jsons.AddItem("ClassName", "根分类");
            jsons.ItemOk();

            BuildClassInfo(ref jsons, dt);
            ret = jsons.ToString();
            return ret;
        }
        /// <summary>
        /// 递归构造jsons字符串
        /// </summary>
        /// <param name="jsons"></param>
        /// <param name="dt"></param>
        private void BuildClassInfo(ref BLL.JSONHelper jsons, DataTable dt ){

            if (dt.Rows.Count == 0)
            {

                return;
            }
            else {

                foreach (DataRow dr in dt.Rows)
                {

                    jsons.AddItem("ID", dr["id"].ToString());
                    StringBuilder str_classnane = new StringBuilder();
                    str_classnane.Append("├");
                    str_classnane.Append("─");
                    int depth =Convert.ToInt32( dr["depth"].ToString());
                    for (int i = 0; i < depth;i++ ) {

                        str_classnane.Append("├");
                        str_classnane.Append("─");
                    }
                    str_classnane.Append(dr["classname"].ToString());
                   

                    jsons.AddItem("ClassName", str_classnane.ToString());
                    jsons.ItemOk();

                    
                    DataTable cdt = new DataTable();
                    cdt = GetClassinfoByparentid(Convert.ToInt32(dr["id"].ToString()));
                    BuildClassInfo( ref jsons, cdt);
                   

                }
            
            }
        }
        /// <summary>
        /// 取得全部分类通过父节点id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataTable GetClassinfoByparentid(int id){
        DataTable dt=new DataTable();

        Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
        string str_sql = "  select  * from [tb_mc_class] where parentid=" + id.ToString() + " order by id ";
        try
        {

            dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
        }
        catch (Exception ex) { }

            return dt;
        }
        /// <summary>
        /// 根据条件获得分类信息
        /// </summary>
        /// <param name="fiter"></param>
        /// <returns></returns>
        public DataTable GetInfoByFiter(string fiter) {

            DataTable dt = new DataTable();

            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_sql = "  select  * from [tb_mc_class] where "+fiter;
            try
            {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }

            return dt;
        }
        /// <summary>
        /// 通过父id取得所有子节点，重载，排除全站分类非商品分类
        /// </summary>
        /// <param name="id"></param>
        /// <param name="ISProduct">是否商品分类</param>
        /// <returns></returns>
        public DataTable GetClassinfoByparentid(int id,bool ISProduct)
        {
            DataTable dt = new DataTable();

            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_sql = "  select  * from [tb_mc_class] where [issystem] <> 1 and parentid=" + id.ToString() + " order by id ";
            try
            {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }

            return dt;
        }
        /// <summary>
        /// 取得当前节点深度
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public int GetDepth(string id) {
            int ret = 0;
            if(Convert.ToInt32(id)==0){// 如果为0，则深度为1

                ret = 0;
            }else{

                string str_sql = "select depth from [tb_mc_class] where id="+id;
                Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
                
                try { 
                
                    ret=int.Parse(db.ExecuteScalar(COMM.PucConfig.ConnectionStringA,CommandType.Text,str_sql).ToString())+1;
                }
                catch (Exception ex) { }
            
            }
            return ret;
        
        }
        /// <summary>
        /// 取得头部信息
        /// </summary>
        /// <returns></returns>
        public string GetClassInfoForTop() {
            StringBuilder str_top = new StringBuilder();
            string ret = string.Empty;
            DataTable dt = GetClassinfoByparentid(0,true);
            foreach(DataRow dr in dt.Rows){

                str_top.Append("<LI  class=beauty><A   href='/list.aspx?id=");
                str_top.Append(dr["id"].ToString());
                str_top.Append("'><SPAN>");
                str_top.Append(dr["ClassName"].ToString());
                str_top.Append("</SPAN></A></LI>");
                str_top.Append("<DIV class='navp f12 hp_nav_col3'><!--左侧分类-->");
                str_top.Append("<DIV class='fl tbrand-list'>");
                DataTable dtt = GetClassinfoByparentid(int.Parse(dr["ID"].ToString()));
                foreach(DataRow drt in dtt.Rows){

                    str_top.Append("<DIV class=wp><a  href = '/list.aspx?id=");
                    str_top.Append(drt["id"].ToString());
                    str_top.Append("' title='");
                    str_top.Append(drt["classname"].ToString());
                    str_top.Append("' >");
                    str_top.Append(drt["classname"].ToString());
                    str_top.Append("</a></DIV>");
                    str_top.Append("<UL>");
                    DataTable dts = new DataTable();
                    dts=GetClassinfoByparentid(Convert.ToInt32( drt["id"].ToString()));
                    foreach(DataRow drs in dts.Rows){

                        str_top.Append("<LI> <a href='/list.aspx?id=");
                        str_top.Append(drs["id"].ToString());
                        str_top.Append("'  title='");
                        str_top.Append(drs["classname"].ToString());
                        str_top.Append("'   style='color:#222222;' >");
                        str_top.Append(drs["classname"].ToString());
                        str_top.Append("</a></LI>");
                    }
                    str_top.Append("</UL>");
                }
                str_top.Append("</DIV><!--左侧分类结束--></DIV>");

            }
            ret = str_top.ToString();
            return ret;
        }
        /// <summary>
        /// 获得全部分类导航页面
        /// </summary>
        /// <returns></returns>
        public string GetClassInfoForClassMap() {
            StringBuilder str_map = new StringBuilder();
            string ret = string.Empty;
            str_map.Append("<DIV class=fllist id=store-tablest style='width:700px'><TABLE class=store-item num='1'><TBODY><TR><TD style='width:100%'>");
            DataTable dt = new DataTable();
            dt = GetClassinfoByparentid(0,true);
            foreach(DataRow dr in dt.Rows){

                str_map.Append("<H2><a  class=STYLE12  href = '/list.aspx?id=");
                str_map.Append(dr["id"].ToString());
                str_map.Append("' >");
                str_map.Append(dr["classname"].ToString());
                str_map.Append("</a></H2><div   style='list-style-type:none; width:100%' >");
                DataTable dtt=new DataTable();
                dtt=GetClassinfoByparentid(int.Parse(dr["id"].ToString()));
                GetClassMapm(ref str_map,dtt);
            }
            str_map.Append("</div></TD></TR></TBODY></TABLE></DIV></br></br>");
            ret = str_map.ToString();
            return ret;
        }
        public void GetClassMap(ref StringBuilder str,DataTable dt){
        
            if(dt.Rows.Count==0){

                return;
            }else{
                foreach(DataRow dr in dt.Rows){

                    str.Append("<LI><a   href = '/list.aspx?id=");
                    str.Append(dr["id"].ToString());
                    str.Append("' title='");
                    str.Append(dr["classname"].ToString());
                    str.Append("'>");
                    str.Append(dr["classname"].ToString());
                    str.Append("</a></LI>");
                DataTable dtn=new DataTable();
                dtn=GetClassinfoByparentid(Convert.ToInt32(dr["id"].ToString()),true);
                GetClassMap(ref str, dtn);
                
                    }
            }
        }
        public void GetClassMapm(ref StringBuilder str, DataTable dt)
        {

            if (dt.Rows.Count == 0)
            {

                return;
            }
            else
            {
                foreach (DataRow dr in dt.Rows)
                {

                    str.Append("<span><a   href = '/list.aspx?id=");
                    str.Append(dr["id"].ToString());
                    str.Append("' title='");
                    str.Append(dr["classname"].ToString());
                    str.Append("'>");
                    str.Append(dr["classname"].ToString());
                    str.Append("</a></span>");
                    DataTable dtn = new DataTable();
                    dtn = GetClassinfoByparentid(Convert.ToInt32(dr["id"].ToString()), true);
                    GetClassMapm(ref str, dtn);

                }
            }
        }
        /// <summary>
        /// 首页中间分类导航
        /// </summary>
        /// <returns></returns>
        public string GetClassForIndex() {

            string ret = string.Empty;
            StringBuilder str_html = new StringBuilder();
            DataTable dt = new DataTable();
            str_html.Append("<div style='clear:both;'></div><DIV class='hcatabox clearfix'  style='width:100%'>");
            dt = GetClassinfoByparentid(0,true);
            foreach(DataRow dr in dt.Rows){

                str_html.Append("<DIV class='f14 blod hcatabox-t  ht1' style='height:40px; width:100px' ><A href='/list.aspx?id=");
                str_html.Append(dr["id"].ToString());
                str_html.Append("'  style='height:40px; font-weight:bold; font-size:14px;line-height:40px; '>");
                str_html.Append(dr["classname"].ToString());
                str_html.Append("</A></DIV><DIV class='fl hcatabox-d' style='width:85%'><UL class='hcalist clearfix'>");
                DataTable dtt = new DataTable();
                dtt=GetClassinfoByparentid(Convert.ToInt32(dr["id"].ToString()));
                foreach(DataRow drt in dtt.Rows){

                    str_html.Append("<LI><a class=hl2    target=_blank href = '/list.aspx?id=");
                    str_html.Append(drt["id"].ToString());
                    str_html.Append("' title='");
                    str_html.Append(drt["classname"].ToString());
                    str_html.Append("' >");
                    str_html.Append(drt["classname"].ToString());
                    str_html.Append("</a></li>");
                    DataTable dts = new DataTable();
                    dts=GetClassinfoByparentid(int.Parse( drt["id"].ToString()));
                    foreach(DataRow drs in dts.Rows){

                        str_html.Append("<LI><a   target=_blank href = '/list.aspx?id=");
                        str_html.Append(drs["id"].ToString());
                        str_html.Append("' title='");
                        str_html.Append(drs["classname"].ToString());
                        str_html.Append("' >");
                        str_html.Append(drs["classname"].ToString());
                        str_html.Append("</a></li>");
                    }
                }
                str_html.Append("<li style='float:right' > <div style='float:right'><a href='/AllMC3ClassMpa.aspx' target='_blank'>全部>></a></div></li></UL><div style='clear:both;'></div></DIV>");

            }
            str_html.Append("<div style='clear:both;'></div></DIV>");
            ret = str_html.ToString();
            return ret;
        
        }
        /// <summary>
        /// 获取文章分类
        /// </summary>
        /// <param name="pid"></param>
        /// <returns></returns>
        public string GetArticleClassInfo(string pid) {

            string ret = string.Empty;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            DataTable dt = new DataTable();
            DataTable dtn = new DataTable();
            dt = GetClassinfoByparentid(Convert.ToInt32(pid));
            dtn = GetClassinfoByparentid(102);

            BLL.JSONHelper jsons = new BLL.JSONHelper();




            BuildClassInfo(ref jsons, dt);
            BuildClassInfo(ref jsons, dtn);
            ret = jsons.ToString();

            return ret;
        }
        /// <summary>
        /// 商品列表页面获得上边导航
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetPathById(string id) {

            string ret = string.Empty;
            StringBuilder str_daohang = new StringBuilder();
            DataTable dt = new DataTable();
            dt = GetInfoByFiter(" id="+id);
           

            BuildPath(dt.Rows[0]["parentid"].ToString(), ref str_daohang);
            str_daohang.Insert(str_daohang.Length, "&gt;&gt;");
            str_daohang.Insert(str_daohang.Length, dt.Rows[0]["classname"].ToString());
            str_daohang.Insert(str_daohang.Length, "&gt;");
            str_daohang.Insert(0, "<A class=hp href='/'>首页</A>");

            ret = str_daohang.ToString();
            return ret;
        }
        /// <summary>
        /// 递归通过id构造导航菜单
        /// </summary>
        /// <param name="id"></param>
        /// <param name="str_bu"></param>
        public void BuildPath(string id,ref StringBuilder str_bun) {


            if (id == "0")
            {
                return;
            }
            else {
                DataTable dt = new DataTable();
                dt = GetInfoByFiter(" id="+id);
                //str_bu.Insert(str_bu.Length,"&gt;&gt;<a href='/index/list?id=");
                //str_bu.Insert(str_bu.Length, dt.Rows[0]["id"].ToString());
                //str_bu.Insert(str_bu.Length, "' >");
                //str_bu.Insert(str_bu.Length, dt.Rows[0]["Classname"].ToString());
                //str_bu.Insert(str_bu.Length, "</a>");
                StringBuilder str_bu = new StringBuilder();
                str_bu.Append("&gt;&gt;<a href='/list.aspx?id=");
                str_bu.Append( dt.Rows[0]["id"].ToString());
                str_bu.Append( "' >");
                str_bu.Append( dt.Rows[0]["Classname"].ToString());
                str_bu.Append( "</a>");
                str_bun.Insert(0, str_bu.ToString());
                BuildPath(dt.Rows[0]["parentid"].ToString(), ref str_bun);
            }
        }
        /// <summary>
        /// 取得根id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="rootid"></param>
        public void GetRootId(int id,ref int rootid) {

            DataTable dt = GetInfoByFiter(" id="+id.ToString());
            if (dt.Rows[0]["parentid"].ToString() == "0")
            {
                rootid = id;
                return ;
            }
            else { 
            
                 GetRootId(Convert.ToInt32(dt.Rows[0]["parentid"].ToString()),ref rootid);
            }

        }
        /// <summary>
        /// 取得商品列表页分类列表
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetListClassInfo(string id) {
            string ret = string.Empty;
            StringBuilder str_html = new StringBuilder();
            str_html.Append("<UL>");
            if (string.IsNullOrEmpty(id)) {

                return ret;
            }
            int rootid=0; 
            GetRootId(Convert.ToInt32(id),ref rootid);
            DataTable dt = new DataTable();
            dt = GetInfoByFiter(" id="+rootid.ToString());

            str_html.Append("<LI><A href='/list.aspx?id=");
            str_html.Append(dt.Rows[0]["id"].ToString());
            str_html.Append(" ' >");
            str_html.Append(dt.Rows[0]["classname"].ToString());
            str_html.Append("</a></li><UL>");
            BuildListClassinfo(ref str_html,dt.Rows[0]["id"].ToString());
            str_html.Append("</UL>");

            ret = str_html.ToString();
            return ret;
        }


        public void BuildListClassinfo(ref StringBuilder str_html,string id) {

            DataTable dt = GetInfoByFiter(" parentid="+id);
            if(dt.Rows.Count==0){

                return;
            }
            foreach(DataRow dr in dt.Rows){

                str_html.Append("<li><a  href = '/list.aspx?id=");
                str_html.Append(dr["id"].ToString());
                str_html.Append("'  title='");
                str_html.Append(dr["classname"].ToString());
                str_html.Append("'   style='color:#222222;' >");
                str_html.Append(dr["classname"].ToString());
                str_html.Append("</a></li>");
                BuildListClassinfo(ref str_html, dr["id"].ToString());

            }


 

        
        }
        /// <summary>
        /// 取得列表页面全部分类
        /// </summary>
        /// <returns></returns>
        public string GetListClassAll() {

            string ret = string.Empty;
            StringBuilder str_html = new StringBuilder();
            DataTable dt = GetClassinfoByparentid(0, true);
            foreach(DataRow dr in dt.Rows){

                str_html.Append("<LI class=beauty><A   href='/list.aspx?id=");
                str_html.Append(dr["id"].ToString());
                str_html.Append("'><SPAN>");
                str_html.Append(dr["classname"].ToString());
                str_html.Append("</SPAN></A></LI>");
            }
            ret = str_html.ToString();
            return ret;

        }
        /// <summary>
        /// 帮助信息左边导航
        /// </summary>
        /// <returns></returns>
        public string GetHelpviews() { 
        
            StringBuilder str_footer=new StringBuilder();
            DataTable dt=new DataTable();
            Models.MClassModels models_class=new Models.MClassModels();
            dt=models_class.GetClassByPidAndFiter("102","");
            int i=1;
            foreach(DataRow dr in dt.Rows){
            
                str_footer.Append("<DL class=border-blue-b><DT class='border-blue-b f14 fb' id='hct-");
                str_footer.Append(i.ToString());
                str_footer.Append("'>");
                str_footer.Append(dr["classname"].ToString());
                DataTable dtt=new DataTable();
                dtt=models_class.GetClassByPidAndFiter(dr["id"].ToString(),"");
                foreach(DataRow drt in dtt.Rows){

                    str_footer.Append("<DD><A class=hm-1 href='/helpviews.aspx?id=");
                str_footer.Append(drt["id"].ToString());
                str_footer.Append("'>");
                str_footer.Append(drt["classname"].ToString());
                str_footer.Append("</A> ");

                }
                str_footer.Append("</DD></DL>");
                i=i+1;

            }


           string str_footers = str_footer.ToString();
           return str_footers;

        }
        /// <summary>
        /// 返回商品展示页分类
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetViewsLeft(string id) {
            StringBuilder str_html = new StringBuilder();
            str_html.Append("<DIV class='bor1 mb10' id='sort-nav'>");
            int rootid = 0;
            GetRootId(Convert.ToInt32(id),ref rootid);
            DataTable dt = GetInfoByFiter(" id=" + rootid.ToString());
            str_html.Append("<DIV class=backcata><A href='/list.aspx?id=");
            str_html.Append(dt.Rows[0]["id"].ToString());
            str_html.Append("'>返回所有");
            str_html.Append(dt.Rows[0]["classname"].ToString());
            str_html.Append("分类</A> </DIV><UL><LI><SPAN class=move>");
            str_html.Append(dt.Rows[0]["Classname"].ToString());
            str_html.Append("</SPAN><UL>");
            BuildStrForViewsClass(ref str_html, dt.Rows[0]["id"].ToString());
            str_html.Append("</LI></UL></UL></DIV>");
            return str_html.ToString();

        }

        private void BuildStrForViewsClass(ref StringBuilder str_html,string id) {

            DataTable dt = new DataTable();
            dt = GetInfoByFiter(" parentid="+id);
            if(dt.Rows.Count==0){

                return;
            }
            foreach(DataRow dr in dt.Rows){

                str_html.Append("<LI> <a href='/lis.aspxt?id=");
                str_html.Append(dr["id"].ToString());
                str_html.Append("'  title='");
                str_html.Append(dr["classname"].ToString());
                str_html.Append("'   style='color:#222222;' >");
                str_html.Append(dr["classname"].ToString());
                str_html.Append("</a>");
                BuildStrForViewsClass(ref str_html, dr["id"].ToString());
            }

        }
        /// <summary>
        /// 商品展示上部导航
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetViewsPathById(string id)
        {

            string ret = string.Empty;
            StringBuilder str_daohang = new StringBuilder();
            DataTable dt = new DataTable();
            dt = GetInfoByFiter(" id=" + id);
            
            BuildPathViews(dt.Rows[0]["parentid"].ToString(), ref str_daohang);
            str_daohang.Insert(str_daohang.Length, "&gt;&gt;<a href='/list.aspx?id=");
            str_daohang.Insert(str_daohang.Length, dt.Rows[0]["id"].ToString());
            str_daohang.Insert(str_daohang.Length, "' ><font color='#FF0000'>");
            str_daohang.Insert(str_daohang.Length, dt.Rows[0]["classname"].ToString());
            str_daohang.Insert(str_daohang.Length, "</font></a>");
            str_daohang.Insert(str_daohang.Length, "&gt;商品详情");
            str_daohang.Insert(0, "<A class=hp href='/'>首页</A>");

            ret = str_daohang.ToString();
            return ret;
        }
        /// <summary>
        /// 递归通过id构造导航菜单(商品展示)
        /// </summary>
        /// <param name="id"></param>
        /// <param name="str_bu"></param>
        public void BuildPathViews(string id, ref StringBuilder str_bun)
        {


            if (id == "0")
            {
                return;
            }
            else
            {
                DataTable dt = new DataTable();
                dt = GetInfoByFiter(" id=" + id);
                StringBuilder str_bu = new StringBuilder();
                str_bu.Insert(str_bu.Length, "&gt;&gt;<a href='/list.aspx?id=");
                str_bu.Insert(str_bu.Length, dt.Rows[0]["id"].ToString());
                str_bu.Insert(str_bu.Length, "' ><font color='#FF0000'>");
                str_bu.Insert(str_bu.Length, dt.Rows[0]["Classname"].ToString());
                str_bu.Insert(str_bu.Length, "</font></a>");
                str_bun.Insert(0, str_bu.ToString());
                BuildPathViews(dt.Rows[0]["parentid"].ToString(), ref str_bun);
            }
        }
        /// <summary>
        /// 获取所有子id列表包括本身
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetIdList(string id) {

            string ret = string.Empty;
            StringBuilder str_id = new StringBuilder();
            DataTable dt = new DataTable();
            str_id.Append(id);
            str_id.Append(",");
            dt = GetClassinfoByparentid(Convert.ToInt32(id));
            foreach(DataRow dr in dt.Rows){

                str_id.Append(dr["id"].ToString());
                str_id.Append(",");
                BuildIdList(ref str_id, dr["id"].ToString());
            }
            ret = str_id.ToString();
            ret = ret.Substring(0, (ret.Length - 1));
            return ret;

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="str_ids"></param>
        /// <param name="id"></param>
        public void BuildIdList(ref StringBuilder str_ids,string id) {

            DataTable dt = new DataTable();
            dt = GetClassinfoByparentid(Convert.ToInt32(id));
            foreach (DataRow dr in dt.Rows)
            {

                str_ids.Append(dr["id"].ToString());
                str_ids.Append(",");
                BuildIdList(ref str_ids, dr["id"].ToString());
            }
        }
    }
}
