﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using System.Text;

namespace BLL.Models
{
    public class ProductModels
    {
        public string[] files = { "ID", "ProductName", "ClassId", "Price", "State", "Stock", "Brand", "Img_Logo", "Img_Big", "Intro", "Content", "AddDate", "ClickCount", "BuyCount", "UserName", "Point", "IsHtml", "Url", "IntroMore" };
        /// <summary>
        /// 查询商品，单个
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public MODEL.MProduct GetProductById(string id) {

            MODEL.MProduct ret = new MODEL.MProduct();
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_sql = "select * from tb_mc_product where id="+id;
            DataTable dt = new DataTable();
            try {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }
           
            if(dt.Rows.Count>0){
                string logourl = string.Empty;
                GetLogoInfo(dt.Rows[0] ,ref logourl);
                ret.AddDate =Convert.IsDBNull(dt.Rows[0]["adddate"]) ==true  ? DateTime.MinValue:Convert.ToDateTime( dt.Rows[0]["adddate"].ToString());
                ret.Brand = Convert.IsDBNull(dt.Rows[0]["brand"]) == true ? 0 :Convert.ToInt32(dt.Rows[0]["brand"].ToString());
                ret.BuyCount = Convert.IsDBNull(dt.Rows[0]["buycount"]) == true ? 0 : Convert.ToInt32(dt.Rows[0]["buycount"].ToString());
                ret.Classid = Convert.IsDBNull(dt.Rows[0]["classid"]) == true ? 0 : Convert.ToInt32(dt.Rows[0]["classid"].ToString());
                ret.ClickCount = Convert.IsDBNull(dt.Rows[0]["clickcount"]) == true ? 0 : Convert.ToInt32(dt.Rows[0]["clickcount"].ToString());
                ret.Content = Convert.IsDBNull(dt.Rows[0]["content"]) == true ? "" : dt.Rows[0]["content"].ToString();
                ret.Id = Convert.IsDBNull(dt.Rows[0]["id"]) == true ? 0 :Convert.ToInt32( dt.Rows[0]["id"].ToString());
                ret.Img_Big = Convert.IsDBNull(dt.Rows[0]["img_big"]) == true ? "" : dt.Rows[0]["img_big"].ToString();
                ret.Img_Logo = Convert.IsDBNull(dt.Rows[0]["img_logo"]) == true ? "" : dt.Rows[0]["img_logo"].ToString();
                ret.Intro = Convert.IsDBNull(dt.Rows[0]["intro"]) == true ? "" : dt.Rows[0]["intro"].ToString();
                ret.IsHtml = Convert.IsDBNull(dt.Rows[0]["ishtml"]) == true ? false :dt.Rows[0]["ishtml"].ToString()=="1"?true:false;
                ret.Point = Convert.IsDBNull(dt.Rows[0]["point"]) == true ? 0 : Convert.ToDecimal(dt.Rows[0]["point"].ToString());
                ret.Price = Convert.IsDBNull(dt.Rows[0]["price"]) == true ? 0 : Convert.ToDecimal(dt.Rows[0]["price"].ToString());
                ret.ProductName = Convert.IsDBNull(dt.Rows[0]["productname"]) == true ? "" : dt.Rows[0]["productname"].ToString();
                ret.State = Convert.IsDBNull(dt.Rows[0]["state"]) == true ? 0 :Convert.ToInt32( dt.Rows[0]["state"].ToString());
                ret.Stock = Convert.IsDBNull(dt.Rows[0]["stock"]) == true ? 0 : Convert.ToInt32(dt.Rows[0]["stock"].ToString());
                ret.Url=Convert.IsDBNull(dt.Rows[0]["url"])==true?"":dt.Rows[0]["url"].ToString();
                ret.UserName = Convert.IsDBNull(dt.Rows[0]["username"]) == true ? 0:Convert.ToInt32( dt.Rows[0]["username"].ToString());
                ret.IntroMore = Convert.IsDBNull(dt.Rows[0]["IntroMore"]) == true ? "" : dt.Rows[0]["IntroMore"].ToString();
                ret.Img_Logo = logourl;
            }

            return ret;
        
        }
        /// <summary>
        /// 查询商品分页
        /// </summary>
        /// <param name="strartid"></param>
        /// <param name="endid"></param>
        /// <param name="fiter"></param>
        /// <param name="pagesize"></param>
        /// <returns></returns>
        public DataTable GetProductList(string start,ref string tcout,string sorder, string fiter,string pagesize) {

            DataTable ret = new DataTable();
            string str_sql = "select top  " + pagesize + " * from tb_mc_product where id not in(select top " + start + " id from tb_mc_product where 1=1" + fiter +  " " + sorder+") and 1=1 " + fiter + sorder;
            if(start=="0"){

                str_sql = "select top  " + pagesize + " * from tb_mc_product where  1=1 " + fiter+sorder;
            }
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_count = " select count(id) from tb_mc_product where 1=1 " + fiter;
            try {

                ret = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
                tcout = db.ExecuteScalar(COMM.PucConfig.ConnectionStringA,CommandType.Text,str_count).ToString();
            }
            catch (Exception ex) { }
            
            return ret;
        }
        /// <summary>
        /// 添加商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddProduct(MODEL.MProduct model) {

            bool ret = false;
            string str_sql = " insert into [tb_mc_product]( ProductName, ClassId, Price, State, Stock, Brand, Img_Logo, Img_Big, Intro, Content, AddDate, ClickCount, BuyCount, UserName, Point, IsHtml, Url,IntroMore)values ( '" + model.ProductName + "'," + model.Classid.ToString() + "," + model.Price.ToString() + " ," + model.State.ToString() + "," + model.Stock.ToString() + ", " + model.Brand.ToString() + ",'" + model.Img_Logo + "','" + model.Img_Big + "','" + model.Intro + "','" + model.Content + "', '" + model.AddDate.ToString() + "'," + model.ClickCount.ToString() + "," + model.BuyCount.ToString() + "," + model.UserName.ToString() + "," + model.Point.ToString() + "," + model.IsHtml.ToString() + ",'" + model.Url.ToString() + "','"+model.IntroMore+"') ";
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            try
            {

                db.ExecuteNonQuery(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql);
                ret = true;
            }
            catch (Exception ex) { }

            return ret;
        }
        /// <summary>
        /// 修改商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdateProduct(MODEL.MProduct model){

            bool ret = false;


            string str_sql = " update  [tb_mc_product] set ProductName='" + model.ProductName + "',Classid=" + model.Classid.ToString() + ",Price=" + model.Price.ToString() + " ,State=" + model.State.ToString() + ",Stock=" + model.Stock.ToString() + ", Brand=" + model.Brand.ToString() + ",Img_Logo='" + model.Img_Logo + "',Img_Big='" + model.Img_Big + "',Intro='" + model.Intro + "',Content='" + model.Content + "', ClickCount=" + model.ClickCount.ToString() + ",BuyCount=" + model.BuyCount.ToString() + ",UserName=" + model.UserName.ToString() + ",Point=" + model.Point.ToString() + ",IsHtml=" + model.IsHtml.ToString() + ",Url='" + model.Url.ToString() + "',IntroMore='"+model.IntroMore+"' where  id=" + model.Id.ToString();
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            try
            {

                db.ExecuteNonQuery(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql);
                ret = true;
            }
            catch (Exception ex) { }

            
            return ret;

        }
        /// <summary>
        /// 删除商品
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool DelProduct(string id) {

            bool ret = false;
            string str_sql = "delete from [tb_mc_product] where id in(" + id + ")";
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            try
            {
                db.ExecuteNonQuery(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql);
                ret = true;
            }
            catch (Exception ex) { }
            return ret;
        
        }
        /// <summary>
        /// 取得一条商品信息jsons
        /// </summary>
        /// <param name="id"></param>
        /// <param name="isjson"></param>
        /// <returns></returns>
        public string GetProductByid(string id, bool isjson) {

            string ret = string.Empty;
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string str_sql = "  select  * from [tb_mc_product] where id="+id;
            DataTable dt = new DataTable();
            string tcount = "0";
            try
            {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }
            BLL.FormJSONHelper jsons = new BLL.FormJSONHelper();
            jsons.success = true;





                foreach (string s in files)
                {

                    jsons.AddItem(s, dt.Rows[0][s].ToString().Replace("\r\n", "</br>").Replace("\r", "").Replace("\n", ""));
                }
                jsons.ItemOk();

    


            ret = jsons.ToString();
            return ret;
        

        }
        /// <summary>
        /// 取得商品列表jsons
        /// </summary>
        /// <param name="start"></param>
        /// <param name="limit"></param>
        /// <param name="fiter"></param>
        /// <returns></returns>
        public string AllProduct(string start,string limit,string fiter){
    
        string ret=string.Empty;
        Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
        string str_sql = "  select top " + limit + " * from [tb_mc_product] where id not in ( select top " + start + " id from [tb_mc_product] order by id desc ) order by id desc  ";
        str_sql = start == "0" ? "  select top " + limit + " * from [tb_mc_product] order by id desc" : str_sql;
        DataTable dt = new DataTable();
        string tcount = "0";
        try
        {

            dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            tcount = db.ExecuteScalar(COMM.PucConfig.ConnectionStringA, CommandType.Text, "select count(*) from [tb_mc_product]").ToString();
        }
        catch (Exception ex) { }
        BLL.JSONHelper jsons = new BLL.JSONHelper();



        foreach (DataRow dr in dt.Rows)
        {

            foreach (string s in files)
            {
                if (s == "Intro" || s == "Content" || s == "IntroMore")
                {
                    continue;
                }
                jsons.AddItem(s, dr[s].ToString());
            }
            jsons.ItemOk();

        }


        jsons.totlalCount = Convert.ToInt32(tcount);
        ret = jsons.ToString();
        return ret;
        
    }

        public DataTable GetProductByFiter(string tops,string fiter) {

            DataTable ret = new DataTable();
            Library.SqlProvider.OleDb db = new Library.SqlProvider.OleDb();
            string topss = tops == "0" ? " " : tops.IndexOf("top") > 0 ? tops : " top  " + tops;
            string str_sql = "  select " + topss + " * from [tb_mc_product] where " + fiter;
            DataTable dt = new DataTable();
          
            try
            {

                dt = db.ExecuteDataset(COMM.PucConfig.ConnectionStringA, CommandType.Text, str_sql).Tables[0];
            }
            catch (Exception ex) { }

            ret = dt;
            return ret;
        }
        /// <summary>
        /// 首页新品展示列表
        /// </summary>
        /// <returns></returns>
        public string GetProductNew() {
            string fiter = " 1=1 order by id desc ";
            DataTable dt = GetProductByFiter("5", fiter);
            StringBuilder str_new = new StringBuilder();
            string ret = string.Empty;
            foreach(DataRow dr in dt.Rows){
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_new.Append("<LI style='width:121px; float:left; overflow:hidden' ><a href='/views.aspx?Productid=");
                str_new.Append(dr["id"].ToString());
                str_new.Append("'><IMG  width='121' height='155'  alt='");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("' src='");
                str_new.Append(imgurl);
                str_new.Append("'><span  style='width:500px;  text-align:left;  float:left;  display:block;'>");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("</span><SPAN   class=price>￥");
                str_new.Append(dr["price"].ToString());
                str_new.Append("</SPAN></A> </LI>");




             
            }


            ret = str_new.ToString();
            return ret;
        
        }
        /// <summary>
        /// 首页热销
        /// </summary>
        /// <returns></returns>
        public string GetProductHot() {

            string ret = string.Empty;
            string fiter = " 1=1 order by buycount desc ";
            DataTable dt = GetProductByFiter("5", fiter);
            StringBuilder str_new = new StringBuilder();
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                i = i + 1;
                if(i==6){

                    break;
                }
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_new.Append("<LI  style='width:121px; float:left; overflow:hidden'  ><a href='/views.aspx?Productid=");
                str_new.Append(dr["id"].ToString());
                str_new.Append("'><IMG  width='121' height='155' alt='");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("' src='");
                str_new.Append(imgurl);
                str_new.Append("'><span  style='width:500px;  text-align:left;  float:left;  display:block;'>");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("</span><SPAN   class=price>￥");
                str_new.Append(dr["price"].ToString());
                str_new.Append("</SPAN></A> </LI>");


            }


            ret = str_new.ToString();
            return ret;
        }
        /// <summary>
        /// 取得左边列表热销
        /// </summary>
        /// <param name="count">条数</param>
        /// <returns></returns>
        public string GetProductHotLeft(int count) { 

            
            string ret = string.Empty;
            string fiter = " 1=1 order by buycount desc ";
            DataTable dt = GetProductByFiter(count.ToString(), fiter);
            StringBuilder str_new = new StringBuilder();
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                i = i + 1;
                if(i==6){

                    break;
                }
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_new.Append("<DD><a href='/views.aspx?Productid=");
                str_new.Append(dr["id"].ToString());
                str_new.Append("'   hm-31  target=_blank><IMG  style='margin-left:0px' width='160' alt='");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("' src='");
                str_new.Append(imgurl);
                str_new.Append("'><SPAN >");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("</SPAN></A>");



            }


            ret = str_new.ToString();
            return ret;
        
          
        }
        /// <summary>
        /// 取得展示页面下部列表
        /// </summary>
        /// <returns></returns>
        public string GetProductListForViewDown(string classid) {

            string ret = string.Empty;
            string fiter = " classid="+classid+" order by buycount desc ";
            DataTable dt = GetProductByFiter("5", fiter);
            StringBuilder str_new = new StringBuilder();
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                i = i + 1;
                if (i == 5)
                {

                    break;
                }
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_new.Append("<LI><a  target=_blank href='/views.aspx?Productid=");
                str_new.Append(dr["id"].ToString());
                str_new.Append("'><IMG alt='");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("' src='");
                str_new.Append(imgurl);
                str_new.Append("'> <SPAN class=title>");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("</SPAN> </A><P>现价：<SPAN   class=hl2>￥");
                str_new.Append(dr["price"].ToString());
                str_new.Append("</SPAN></P></LI>");


            }


            ret = str_new.ToString();
            return ret;
        
        }
        /// <summary>
        /// 取得左边列表最新
        /// </summary>
        /// <param name="count"></param>
        /// <returns></returns>
        public string GetProductnewLeft(int count)
        {


            string ret = string.Empty;
            string fiter = " 1=1 order by id desc ";
            DataTable dt = GetProductByFiter(count.ToString(), fiter);
            StringBuilder str_new = new StringBuilder();
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                i = i + 1;
                if (i == 6)
                {

                    break;
                }
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_new.Append("<DD><a href='/views.aspx?Productid=");
                str_new.Append(dr["id"].ToString());
                str_new.Append("'   hm-31  target=_blank><IMG  style='margin-left:0px' width='160' alt='");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("' src='");
                str_new.Append(imgurl);
                str_new.Append("'><SPAN >");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("</SPAN></A>");



            }


            ret = str_new.ToString();
            return ret;


        }
        /// <summary>
        /// 取得浏览历史
        /// </summary>
        /// <param name="count"></param>
        /// <param name="ids"></param>
        /// <returns></returns>
        public string GetProductHisLeft(int count, string ids) { 
        
       

            
            string ret = string.Empty;
            string fiter = " id in ("+ids+") order by buycount desc ";
            DataTable dt = GetProductByFiter(count.ToString(), fiter);
            StringBuilder str_new = new StringBuilder();
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                i = i + 1;
                if(i==6){

                    break;
                }
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_new.Append("<DD><a href='/views.aspx?Productid=");
                str_new.Append(dr["id"].ToString());
                str_new.Append("'   hm-31  target=_blank><IMG  style='margin-left:0px' width='160' alt='");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("' src='");
                str_new.Append(imgurl);
                str_new.Append("'><SPAN >");
                str_new.Append(dr["productname"].ToString());
                str_new.Append("</SPAN></A>");



            }


            ret = str_new.ToString();
            return ret;
        
          
      
        }
        /// <summary>
        /// 首页商主列表
        /// </summary>
        /// <returns></returns>
        public string GetIndexPrductlist() {

            string ret = string.Empty;
            StringBuilder str_html = new StringBuilder();
            DataTable dtclass = new DataTable();
            Models.MClassModels modles_class = new MClassModels();
            Models.MAdModels models_ad = new MAdModels();
            dtclass = modles_class.GetClassinfoByparentid(0,true);
            foreach(DataRow dr in dtclass.Rows){
                MODEL.MAD model_ad = new MODEL.MAD();
                model_ad = models_ad.GetAdByClassId(dr["id"].ToString());
                str_html.Append("<DIV class='mainboxc clearfix'><DIV class=clearfix><div  style='background:url(/");
                str_html.Append(dr["logo"].ToString());

                str_html.Append("); width:180px; float:left; height:55px;'></div><div style='float:left; width:700px;overflow:hidden;'><UL class='catalist mt10'  style=' display:block;width:1000px;'><LI class=bornone><A class=morelink   href='/list.aspx?action=tejia&id=");
                str_html.Append(dr["id"]);
                str_html.Append("  ' target=_blank>特卖</A> </LI> <LI><A href='/lis.aspxt?action=new&id=");
                str_html.Append(dr["id"]);
                str_html.Append("' target=_blank>新品</A> </LI> <LI><A href='/list.aspx?action=tejia&id=");
                str_html.Append(dr["id"]);
                str_html.Append("'  target=_blank>热卖</A> </LI>");
                DataTable dtt=new DataTable();
                dtt=modles_class.GetClassinfoByparentid(Convert.ToInt32( dr["id"].ToString()),true);
                modles_class.GetClassMap(ref str_html,dtt);
                str_html.Append("</UL></div><div style='clear:both; height:1px;'></div></DIV><DIV class=hot>");
                str_html.Append("<a href='");
                str_html.Append(model_ad.Adurl);
                str_html.Append("'><IMG width='195' height='406' alt='");
                str_html.Append(model_ad.Adtitle);
                str_html.Append("'  src='");
                str_html.Append(model_ad.Adpic);
                str_html.Append("'></A>   </DIV>");
                
                DataTable dtp=new DataTable();
                dtp=GetProductByFiter(" top 10 "," classid in("+GetIdList(dr["id"].ToString())+" ) ");
                str_html.Append("<UL class='item hotbox'>");
                foreach(DataRow drp in dtp.Rows){
                    string imgurl = string.Empty;
                    GetLogoInfo(drp, ref imgurl);
                    string price = string.Empty;
                    GetPriceShow(drp,ref price);
                    str_html.Append("<LI style='width:121px; float:left; overflow:hidden'><a href='/views.aspx?Productid=");
                    str_html.Append(drp["id"].ToString());
                    str_html.Append("'><IMG width='121' height='155' alt='");
                    str_html.Append(drp["productname"].ToString());
                    str_html.Append("' src='");
                    str_html.Append( imgurl);
                    str_html.Append("'><span  style='width:500px;  text-align:left;  float:left;  display:block;'>");
                    str_html.Append(drp["productname"].ToString());
                    str_html.Append("</span><SPAN   class='price'>￥");
                    str_html.Append(drp["price"].ToString());
                    str_html.Append("</SPAN></A> </LI>");


                }
                str_html.Append("</UL><div style='clear:both; height:1px;'></div></DIV>");
            }
            //str_html.Append();
            ret = str_html.ToString();
            return ret;
 
        }
        /// <summary>
        /// 首页特价商品
        /// </summary>
        /// <returns></returns>
        public string GetIndexTproduct() {

            string ret = string.Empty;
            StringBuilder str_htm=new StringBuilder();
            DataTable dt=new DataTable();
            dt=GetProductByFiter(" top 17 ", " 1=1 order by price desc ");
            foreach(DataRow dr in dt.Rows){
                string imgurl = string.Empty;
                GetLogoInfo(dr, ref imgurl);
                str_htm.Append("<li class='fl '  style=' list-style-type:none;width:109px; float:left; overflow:hidden' ><A href='/views.aspx?productid=");
                str_htm.Append(dr["id"].ToString());
                str_htm.Append("'   target=_blank><IMG width='108' height='115' border='0' alt='");
                str_htm.Append(dr["productname"].ToString());
                str_htm.Append("'   src='");
                str_htm.Append(imgurl);
                str_htm.Append("'>");         
                str_htm.Append("<span  style='width:500px;  text-align:left;  float:left;  display:block;'>");
                str_htm.Append(dr["productname"].ToString());
                str_htm.Append("</span></A></li>");


            }
            ret = str_htm.ToString();
            return ret;
        }
        /// <summary>
        /// 取得logo信息
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="logourl"></param>
        private void GetLogoInfo(DataRow dr,ref string logourl ) {

            string tempstr = dr["img_big"].ToString();
            if(!string.IsNullOrEmpty(tempstr)&&tempstr.IndexOf(",")>-1){

                string[] tempstrs = tempstr.Split(new char[]{','});
                foreach(string s in tempstrs){

                    if (s.Length < 2) {

                        continue;
                    }
                    logourl = s;
                    break;
                }
            }
        
        }
        
        /// <summary>
        /// 获得价格,虚报的
        /// </summary>
        /// <param name="dr"></param>
        /// <param name="price"></param>
        private void GetPriceShow(DataRow dr ,ref string price){

            decimal pricenow = Convert.ToDecimal(dr["price"].ToString());
            price = (Convert.ToDecimal("1.3") * pricenow).ToString();
        }
        /// <summary>
        /// 取得分类下所有子节点id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetIdList(string id)
        {
            string ret=string.Empty;
            MClassModels models = new MClassModels();
            ret = models.GetIdList(id);
            return ret;

        }
    }
}
