﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace IMODELS
{
    public interface IProduct
    {
        /// <summary>
        /// 查询商品，单个
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
         MODEL.MProduct GetProductById(string id);
        /// <summary>
        /// 查询商品分页
        /// </summary>
        /// <param name="strartid"></param>
        /// <param name="endid"></param>
        /// <param name="fiter"></param>
        /// <param name="pagesize"></param>
        /// <returns></returns>
        // DataTable GetProductList(string strartid, string endid, string fiter, string pagesize);
        /// <summary>
        /// 添加商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
         bool AddProduct(MODEL.MProduct model);
        /// <summary>
        /// 修改商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
         bool UpdateProduct(MODEL.MProduct model);
        /// <summary>
        /// 删除商品
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
         bool DelProduct(string id);
        /// <summary>
        /// 取得一条商品信息jsons
        /// </summary>
        /// <param name="id"></param>
        /// <param name="isjson"></param>
        /// <returns></returns>
         string GetProductByid(string id, bool isjson);
        /// <summary>
        /// 取得商品列表jsons
        /// </summary>
        /// <param name="start"></param>
        /// <param name="limit"></param>
        /// <param name="fiter"></param>
        /// <returns></returns>
         string AllProduct(string start, string limit, string fiter);
        
    }
}
