﻿//品牌管理
// JScript 文件


//000000品牌管理列表开始
var BrandInfoStore;
BrandInfoManage = function(node) {//分页每页显示数量	 
    var pageSize = 12;
    //指定列参数

    var BrandInfoFields = ["ID", "Name", "Content", "Img_Logo", "Img_LogoB", "Intro"];
    BrandInfoStore = new Ext.data.GroupingStore({
        proxy: new Ext.data.HttpProxy(
           {
               url: "/MCScriptManageServices/AllBrand.aspx",
               method: "POST"
           }),
        reader: new Ext.data.JsonReader(
           {
               fields: BrandInfoFields,
               root: "data",
               id: "ID",
               totalProperty: "totalCount"

           }),
        //groupField:'id', 
        sortInfo: { field: 'ID', direction: "DESC" }
    });
    BrandInfoStore.load({ params: { start: 0, limit: pageSize} });




    //--------------------------------------------------列选择模式
    var sm = new Ext.grid.CheckboxSelectionModel({
    //dataIndex:"id"
});
//--------------------------------------------------列头
var cm = new Ext.grid.ColumnModel([
		sm,
{
    header: "品牌名称",
    dataIndex: "Name",
    tooltip: "品牌名称",
    sortable: true
}, {
    header: "简介",
    tooltip: "简介",
    dataIndex: "Intro",
    sortable: true
}]);


    var BrandInfoGrid = new Ext.grid.GridPanel({
        id: "BrandInfoGrid",
        store: BrandInfoStore,
        sm: sm,
        cm: cm,
        loadMask: true,
        stripeRows: true,
        //autoExpandColumn:7,
        //超过长度带自动滚动条
        autoScroll: true,
        border: false,
        view: new Ext.grid.GroupingView({
            //自动填充
            forceFit: true,
            sortAscText: '正序排列',
            sortDescText: '倒序排列',
            columnsText: '列显示/隐藏',
            groupByText: '根据本列分组',
            showGroupsText: '是否采用分组显示',
            groupTextTpl: '{text} (<font color=red><b>{[values.rs.length]}</b></font> {[values.rs.length > 0 ? "条器件信息" : "暂无器件信息"]})'
        }),
        //分页
        bbar: new Ext.PagingToolbar({
            store: BrandInfoStore,
            pageSize: pageSize,
            //显示右下角信息
            displayInfo: true,
            displayMsg: '当前记录 {0} -- {1} 条 共 {2} 条记录',
            emptyMsg: "No results to display",
            prevText: "上一页",
            nextText: "下一页",
            refreshText: "刷新",
            lastText: "最后页",
            firstText: "第一页",
            beforePageText: "当前页",
            afterPageText: "共{0}页"

        }),
        tbar: [
		new Ext.Toolbar.Fill()
		, "", "-", "",
			{
			    text: "刷新信息",
			    //默认样式为按下
			    //pressed:true,
			    tooltip: "刷新当前页面信息",
			    iconCls: "refreshicon",
			    handler: function() {
			        BrandInfoStore.reload();
			    }
			}, "", "-"
		,
		{
		    text: "添加",
		    tooltip: "添加信息",
		    iconCls: "addicon",
		    handler: AddBrandInfoFN
		}, "", "-", "", {
		    text: "编辑",
		    tooltip: "编辑信息",
		    iconCls: "editicon",
		    handler: EditBrandInfoFN
		}, "", "-", "", {
		    text: "删除",
		    tooltip: "删除信息",
		    iconCls: "deleteicon",
		    handler: DelBrandInfoFN

		}, "-"], listeners: {
		    'contextmenu': function(e) {
		        e.stopEvent();
		    },
		    'rowcontextmenu': function(grid, rowIndex, e) {
		        e.stopEvent();
		    }
		}
    });



    GridMain(node, BrandInfoGrid, "usericon");
}

function DelBrandInfoFN() {
    var row = Ext.getCmp("BrandInfoGrid").getSelectionModel().getSelections();
    if (row.length == 0) {
        Ext.Msg.alert("提示信息", "请您至少选择一个!");
    }
    else {
        Ext.Msg.confirm("提示!", "您确定要删除该信息吗?", function(btn) {
            if (btn == "yes") {
                DelBrandInfoFNs(row);
            }
            else {

            }
        })
    }
}

function EditBrandInfoFN() {
    var row = Ext.getCmp("BrandInfoGrid").getSelectionModel().getSelections();
    if (row.length == 0) {
        Ext.Msg.alert("提示信息", "您没有选中任何行!");
    }
    else if (row.length > 1) {

        Ext.Msg.alert("提示信息", "对不起只能选择一个!");
    } else if (row.length == 1) {

        EditBrandInfos(row[0]); //传行一行记录直接加载
    }
}

//000000品牌管理管理结束
//000000品牌管理添加开始


AddBrandInfoFN = function() {
    //------品牌类型

    //    var AddUserRoleFields = Ext.data.Record.create([
    //        { name: 'roleid', mapping: 'roleid' }, { name: 'rolename', mapping: 'rolename' }, { name: 'roledesc', mapping: 'roledesc' }
    //    ]);

    //    var AddUserRoleStore = new Ext.data.Store({
    //        proxy: new Ext.data.HttpProxy({
    //            url: 'services/system/RoleInfo/GetRoleInfo.aspx'
    //        }),
    //        reader: new Ext.data.JsonReader({
    //            root: 'data',
    //            id: 'roleid'
    //        },
    //        AddUserRoleFields
    //        )
    //    });
    //    AddUserRoleStore.load();


    var AddBrandInfoForm = new Ext.form.FormPanel({
        width: 315,
        plain: true,
        layout: "form",
        defaultType: "textfield",
        labelWidth: 60,
        baseCls: "x-plain",
        defaults: { anchor: "95%", msgTarget: "side" },
        buttonAlign: "center",
        bodyStyle: "padding:0 0 0 0",
        items: [
			{//["Id", "Name", "Content", "Img_Logo", "Img_LogoB", "Intro"]
			    name: "Name",
			    fieldLabel: "品牌名称",
			    allowBlank: false,
			    blankText: "品牌名称"
			}, {
			name: "Content",
			    fieldLabel: "品牌内容",
			    allowBlank: false,
			    blankText: "品牌内容"
			}, {
			name: "Img_Logo",
			    fieldLabel: "品牌logo",
			    allowBlank: false,
			    blankText: "品牌logo"
			}, {
			name: "Img_LogoB",
			    fieldLabel: "品牌大图",
			    allowBlank: false,
			    blankText: "品牌大图"
			}, {
			name: "Intro",
			    fieldLabel: "品牌简介",
			    allowBlank: false,
			    blankText: "品牌简介"
			}
        //			{

        //			    xtype: "combo",
        //			    tpl: '<tpl for="."><div ext:qtip="{rolename}. {roledesc}" class="x-combo-list-item">{rolename}</div></tpl>',
        //			    store: AddUserRoleStore,
        //			    typeAhead: true,
        //			    fieldLabel: '角色',
        //			    hiddenName: 'roleid',
        //			    name: 'roleid',
        //			    forceSelection: true,
        //			    triggerAction: 'all',
        //			    emptyText: '选择角色类型',
        //			    selectOnFocus: true,
        //			    width: 130,
        //			    editable: false,
        //			    allowBlank: false,
        //			    blankText: '请选择角色类型',
        //			    displayField: 'rolename',
        //			    valueField: 'roleid',
        //			    mode: 'remote'
        //			}, 

			]
    });


    var AddBrandInfoWin = new Ext.Window({
        title: "添加品牌",
        width: 350,
        plain: true,
        layout: "form",
        iconCls: "addicon",
        //不可以随意改变大小
        resizable: false,
        //是否可以拖动
        //draggable:false,
        defaultType: "textfield",
        labelWidth: 100,
        collapsible: true, //允许缩放条
        closeAction: 'hide',
        closable: true,
        //弹出模态窗体
        modal: 'true',
        buttonAlign: "center",
        bodyStyle: "padding:10px 0 0 15px",
        items: [AddBrandInfoForm],
        listeners: {
            "show": function() {
                AddBrandInfoForm.getForm().reset();
            }
        },
        buttons: [{
            text: "保存信息",
            minWidth: 70,
            handler: function() {
                if (AddBrandInfoForm.getForm().isValid()) {
                    //弹出效果
                    Ext.MessageBox.show
                                (
                                    {
                                        msg: '正在保存，请稍等...',
                                        progressText: 'Saving...',
                                        width: 300,
                                        wait: true,
                                        waitConfig: { interval: 200 },
                                        icon: 'download',
                                        animEl: 'saving'
                                    }
                                );
                    setTimeout(function() { }, 1000);
                    AddBrandInfoForm.form.submit({
                        url: "/MCScriptManageServices/AddBrand.aspx",
                        method: "POST",
                        success: function(form, action) {
                            //成功后
                            var flag = action.result.success;
                            if (flag == "true") {
                                Ext.MessageBox.alert("恭喜", "添加成功!");
                                BrandInfoStore.reload();
                                AddBrandInfoWin.hide();
                            } else if (flag == "false") {

                                var reson = action.result.reson;
                                //Ext.MessageBox.alert("提示",""+reson+"!");
                                if (reson != "undefined")
                                    Ext.MessageBox.alert("提示", "系统已存在此名!");
                            }
                        },
                        failure: function(form, action) {
                            Ext.MessageBox.alert("提示!", "添加失败!");
                        }
                    });
                }
            }
        }, {
            text: "重置",
            minWidth: 70,
            qtip: "重置数据",
            handler: function() {
                AddBrandInfoForm.getForm().reset();
            }
        }, {
            text: "取 消",
            minWidth: 70,
            handler: function() {
                AddBrandInfoWin.hide();
            }
}]

        });
        AddBrandInfoWin.show();
    }

    //000000品牌管理添加结束
    //000000品牌管理编辑开始
    EditBrandInfos = function(row) {
        //------品牌类型

        //        var EditUserRoleFields = Ext.data.Record.create([
        //        { name: 'roleid', mapping: 'roleid' }, { name: 'rolename', mapping: 'rolename' }, { name: 'roledesc', mapping: 'roledesc' }
        //    ]);

        //        var EditUserRoleStore = new Ext.data.Store({
        //            proxy: new Ext.data.HttpProxy({
        //            url: '/MCScriptManageServices/GetRoleInfoByid'
        //            }),
        //            reader: new Ext.data.JsonReader({
        //                root: 'data',
        //                id: 'roleid'
        //            },
        //        EditUserRoleFields
        //        )
        //        });
        //        EditUserRoleStore.load();

        var EditBrandInfoForm = new Ext.form.FormPanel({
            width: 315,
            plain: true,
            layout: "form",
            defaultType: "textfield",
            labelWidth: 60,
            baseCls: "x-plain",
            defaults: { anchor: "95%", msgTarget: "side" },
            buttonAlign: "center",
            bodyStyle: "padding:0 0 0 0",
            items: [
						{
						    xtype: 'hidden',
						    name: "ID",
						    fieldLabel: "登录帐号",
						    allowBlank: false,
						    blankText: "帐号不允许为空",
						    readOnly: true
						}	,		{//["Id", "Name", "Content", "Img_Logo", "Img_LogoB", "Intro"]
			    name: "Name",
			    fieldLabel: "品牌名称",
			    allowBlank: false,
			    blankText: "品牌名称"
			}, {
			name: "Content",
			    fieldLabel: "品牌内容",
			    allowBlank: false,
			    blankText: "品牌内容"
			}, {
			name: "Img_Logo",
			    fieldLabel: "品牌logo",
			    allowBlank: false,
			    blankText: "品牌logo"
			}, {
			name: "Img_LogoB",
			    fieldLabel: "品牌大图",
			    allowBlank: false,
			    blankText: "品牌大图"
			}, {
			name: "Intro",
			    fieldLabel: "品牌简介",
			    allowBlank: false,
			    blankText: "品牌简介"
			}
			]
        });


        var EditBrandInfoWin = new Ext.Window({
            title: "编辑品牌信息",
            width: 350,
            plain: true,
            //layout:"form",
            iconCls: "addicon",
            //不可以随意改变大小
            resizable: false,
            //是否可以拖动
            //draggable:false,
            defaultType: "textfield",
            labelWidth: 100,
            collapsible: true, //允许缩放条
            closeAction: 'hide',
            closable: true,
            //弹出模态窗体
            modal: 'true',
            buttonAlign: "center",
            bodyStyle: "padding:10px 0 0 15px",
            items: [EditBrandInfoForm],
            listeners: {
                "show": function() {

                    EditBrandInfoForm.getForm().reset();
                    var classid_input = row.data.ID;
                    EditBrandInfoForm.form.load(
                                {
                                    url: "/MCScriptManageServices/GetBrandById.aspx?id=" + classid_input,
                                    method: "get",
                                    success: function(form, action) {

                                    },
                                    failure: function(form, action) {
                                        Ext.Msg.alert("提示信息", "对不起加载数据失败!请联系管理员");
                                    }
                                }
                    );
                }
            },
            buttons: [{
                text: "保存信息",
                minWidth: 70,
                handler: function() {
                    if (EditBrandInfoForm.getForm().isValid()) {
                        //弹出效果
                        Ext.MessageBox.show
                                (
                                    {
                                        msg: '正在保存，请稍等...',
                                        progressText: 'Saving...',
                                        width: 300,
                                        wait: true,
                                        waitConfig: { interval: 200 },
                                        icon: 'download',
                                        animEl: 'saving'
                                    }
                                );
                        setTimeout(function() { }, 1000);
                        EditBrandInfoForm.form.submit({
                            url: "/MCScriptManageServices/UpdateBrand.aspx",
                            method: "POST",
                            success: function(form, action) {
                                //成功后
                                var flag = action.result.success;
                                if (flag == "true") {
                                    Ext.MessageBox.alert("恭喜", "保存品牌信息成功!");
                                    BrandInfoStore.reload();
                                    EditBrandInfoWin.hide();
                                } else if (flag == "false") {

                                    Ext.MessageBox.alert("提示", "您的品牌名可能系统中已经存在，请换一个品牌名试下!");
                                    BrandInfoStore.reload();
                                    EditBrandInfoWin.hide();
                                }
                            },
                            failure: function(form, action) {
                                Ext.MessageBox.alert("提示!", "保存品牌信息失败!");
                            }
                        });
                    }
                }
            }, {
                text: "重置",
                minWidth: 70,
                qtip: "重置数据",
                handler: function() {
                    var classid_input = row.data.ID;
                    EditBrandInfoForm.form.load(
                                {
                                    url: "/MCScriptManageServices/GetBrandById.aspx?loginid=" + classid_input,
                                    method: "get",
                                    success: function(form, action) {

                                    },
                                    failure: function(form, action) {
                                        Ext.Msg.alert("提示信息", "对不起加载数据失败!请联系管理员");
                                    }
                                }
                    );
                }
            }, {
                text: "取 消",
                minWidth: 70,
                handler: function() {
                    EditBrandInfoWin.hide();
                }
}]

            });
            EditBrandInfoWin.show();
        }

        //000000品牌管理编辑结束
        //000000品牌管理删除开始

        DelBrandInfoFNs = function(row) {
            var deletesplit = "";
            for (var i = 0; i < row.length; i++) {
                if (row.length == 1) {
                    deletesplit = row[i].data.ID;
                }
                else {

                    if (i < (row.length - 1)) {
                        deletesplit = row[i].data.ID + "," + deletesplit;
                    }
                    if (i == (row.length - 1)) {
                        deletesplit = deletesplit + row[i].data.ID;
                    }
                }
            }
            Ext.Ajax.request({
                url: "/MCScriptManageServices/DelBrand.aspx",
                method: "POST",
                params: {
                    id: deletesplit
                },
                success: function() {
                    BrandInfoStore.reload();
                },
                failure: function() {
                    Ext.Msg.alert("提 示", "删除失败了!");
                }
            });
        }

        //000000品牌管理删除结束