﻿
/// <summary>
/// 本方法通过异步程序来处理单品页最近浏览商品的展示和对cookie的操作
/// </summary>
function ShowLastestViewedItems() {
    //0、清除以前的cookie
    if (typeof ($.cookie("LatestViewedItem")) != undefined && $.cookie("LatestViewedItem") != null) {
        $.cookie("LatestViewedItem", "", { expires: -1, path: "/", domain: "m18.com", secure: true });
    }

    //1、异步读取cookie并展示
    if (typeof ($.cookie("LastView")) != undefined && $.cookie("LastView") != null) {
        //获取cookie
        var viewedItemArray = $.cookie("LastView").split("$");
        //1. 读取Cookie
        //获取每次浏览记录的数组
        var viewedItemRetunArray = new Array();

        //使用Ajax方式
        //构建Ajax请求的参数
        var params = "'styleIds':'";
        for (var i in viewedItemArray) {
            //若当前浏览记录为空，则跳过进行下次循环
            if (viewedItemArray[i] == null) {
                continue;
            }

            params += viewedItemArray[i];
            if (i != viewedItemArray.length - 1) {
                params += ",";
            }
        }
        params += "'";

        $.ajax(
        {
            type: "POST",
            contentType: "application/json",
            url: ajaxServiceAddress.GetLastView,
            data: "{" + params + "}",
            dataType: 'json', //返回的类型为Json
            success: function(result) {
                var styleList = eval("(" + result.d + ")");

                //构建来自服务端的List<LastViewStyleBizeEntity>数据
                for (var i in styleList) {
                    styleList[i].ImgPath = "http://img.m18.com/GOODS/LARGEMAP/" + styleList[i].ImgPath;
                    var href = "http://product.m18.com";
                    switch (styleList[i].StyleType) {
                        case "Sku":
                            href += "/p-" + styleList[i].StyleId + ".htm";
                            break;
                        case "Kit":
                            href += "/k-" + styleList[i].StyleId + ".htm";
                            break;
                        case "Fix":
                            href += "/f-" + styleList[i].StyleId + ".htm";
                            break;
                        default:
                            href += "/#";
                            break;
                    }
                    styleList[i].Href = href;
                    viewedItemRetunArray.push(styleList[i]);
                }

                //展示cookie
                FillViewedItems(viewedItemRetunArray);
            },
            error: function(result, status) { //如果没有上面的捕获出错会执行这里的回调函数
                if (status == 'error') {
                    return;
                }
            }
        });
    }

    //为清除cookie链接绑定事件
    BindClearCookieButton();


};

function BindClearCookieButton() {
    $("#viewed .handle").bind("click", function() {
        $.cookie("LastView", "", { expires: -1, path: "/", domain: "m18.com", secure: true });
        $("#viewed ul").eq(0).hide();
        return false;
    });
};

/// <summary>
/// 向最近浏览商品区域填充显示数据
/// </summary>
function FillViewedItems(jsonObj) {
    if (jsonObj == undefined || jsonObj == null) {
        return;
    }

    $("#viewed .h2").eq(0).after("<ul></ul>");
    for (var index in jsonObj) {
        $("#viewed ul").eq(0).append("<li></li>");
        $("#viewed ul li:last-child").append("<a title='" + jsonObj[index].StyleName + "' href='" + jsonObj[index].Href + "' target='_blank'></a>");
        $("#viewed ul li:last-child a").append("<img src='" + jsonObj[index].ImgPath + "' alt='" + jsonObj[index].StyleName + "Y01' class='s-pic'/>");
        $("#viewed ul li:last-child a").append("<span>" + jsonObj[index].StyleName + "</span>");
        $("#viewed ul li:last-child a").append("<span>￥" + jsonObj[index].Price + "</span>");
        $("#viewed ul li:last-child a").append("<span class='lower'>" + jsonObj[index].StyleBrand + "</span>");
    }
};

//页面初始化加载
$(document).ready(function() {
    ShowLastestViewedItems();
})

function PrecisionSearch() {
    if (queryJson != undefined && queryJson != "") {
        var url = "http://list.m18.com/";
        url = url + queryJson.ClassId1 + "-" + queryJson.CurrentClassId + "-";
        var tempSortField = "1";
        var tempSortType = "2";
        var material = "0";
        var pageNumber = $(".goto&fr input[class=text]").eq(0).val();
        try {
            pageNumber = parseInt(pageNumber);
            if (isNaN(pageNumber)) {
                $(".goto&fr input[class=text]").eq(0).val(queryJson.Pager.PageNumber);
                alert("索引页不是合法的数值!");
                return;
            }
            var pageCount = Math.ceil((queryJson.Pager.TotalCount * 1.0) / queryJson.Pager.PageSize);
            if (pageNumber > pageCount || pageNumber <= 0) {
                $(".goto&fr input[class=text]").eq(0).val(queryJson.Pager.PageNumber);
                alert("页索引页超出范围!");
                return;
            }
        } catch (e) {
            $(".goto&fr input[class=text]").eq(0).val(queryJson.Pager.PageNumber);
            alert("索引页不是合法的数值!");
            return;
        }
        if (queryJson.SortField == "SaleQuantity") {
            tempSortField = "1";
        }
        else if (queryJson == "SaleDate") {
            tempSortField = "2";
        }
        else if (queryJson == "WebSalePrice") {
            tempSortField = "3";
        }
        if (queryJson.SortType == "ASC") {
            tempSortType = "1";
        }
        else {
            tempSortType = "2";
        }
        if (queryJson.MaterialName == null || queryJson.MaterialName == "") {
            material = "0";
        }
        url = url + tempSortField + tempSortType + "-" + queryJson.Pager.PageSize + "-" + pageNumber + "-" + queryJson.TradeMarkId + "-" + queryJson.ItemType + "-" + material + "-" + "0.htm";
        window.location.href = url;
    }


}
$(document).ready(function() {
    $(this).keydown(function(event) {
        switch (event.keyCode) {
            case 13:
                if ($(this).length > 0) {
                    $("#precisionSearchBtn").click();
                }
                break;
        }
    });

    $('.item li').hover(
		function() { $(this).addClass('hover') },
		function() { $(this).removeClass('hover') })
})
$(document).ready(function() {
    $('.brandbox li>a:contains("欧梦达")').remove();
    num = $('.brandbox ul li').length;
    if (num > 5) {
        $('.brandbox ul').children('li:gt(4)').hide();
        $('<div class="key"><a href="#">展开</a></div>').appendTo('.brandbox');
        $('.key a').toggle(
			function() {
			    $(this).addClass('close').text('收拢');
			    $('.brandbox ul').children('li:gt(4)').show();
			},
			function() {
			    $(this).removeClass('close').text('展开');
			    $('.brandbox ul').children('li:gt(4)').hide();
			})
    };
})