﻿///<reference path="lib\jquery-1.3.2-vsdoc2.js" />
///<reference path="lib\jquery.cookie.js" />
///<reference path="StyleCommon.js" />

var loadCount = 0;
function LoadSKU() {
	//若单卖文字不存在，则不执行单卖逻辑判断（放到styleCommon）
	if (typeof (aloneMessage) != undefined && aloneMessage != null && aloneMessage.length > 0) {
		//是单卖产品，执行返回操作
		$(".choicebox").html(aloneMessage);
		$(".choicebox").attr("class", "error");
		return;
	}
	else {
		try {
			//1、库存处理
			CombSKUAndWH(styleEntityListJson, styleSKUItemsJson, productWarehouseJson);
		}
		catch (e) {
			loadCount++;
			if (loadCount <= 50) {
				setTimeout("LoadSKU()", 100);
				return;
			}
		}

		//2、天天抢逻辑判断
		if (scareBuyingItem != undefined || scareBuyingItem != null) { //判断是否是天天抢
			//是天天抢但无法购买
			if (scareBuyingItem.ErrorMsg != null && scareBuyingItem.ErrorMsg.length > 0 && scareBuyingItem.ErrorMsg != "0") {
				var errorMsg = "";
				if (scareBuyingItem.ErrorMsg == "1") {
					errorMsg = "对不起，天天抢活动尚未开始或已结束";
				}

				if (scareBuyingItem.ErrorMsg == "2") {
					errorMsg = "对不起，商品已经被其他人抢购完了";
				}

				$("div.choicebox").html(errorMsg);
				$("div.choicebox").attr("class", "error");
				return;
			}
			else {
				//该天天抢可以购买，更改最大购买数量
				$(".choicebox").attr("maxqty", scareBuyingItem.MaxQtyPerUser);
			}
		}

		//初始化Dimention1
		InitDimention1();
		//5、特殊分类商品逻辑
		SpecialClassLogic();
	}
};


$(document).ready(function() {
	//1、PO逻辑
	var skuItemLists = GetSKUItems(styleEntityListJson[0].StyleId, styleSKUItemsJson);
	//隐藏人气区域
	if ($("div[styleid]").eq(0).attr("class") == "error") {
		//隐藏人气区域
		$(".gh-frame").hide();
	}

	//1、默认选中largemap图
	$(".thumbpic li a").eq(0).attr("class", "cur");
	//2、为Largemap图片绑定over事件和Click事件
	BindPicEvent();
	//3、绑定页面tab切换事件
	BindSwitchTab();

	//5、加载购买记录、评论、问答
	ShowPageInfo();
	//6、加载单品页左侧模块
	LoadStyleDetailLeft(styleEntityListJson[0].StyleId);
	//7、绑定页面事件
	BindEvent();

	document.domain = "m18.com";

	//8、Large图默认图片是第一个小色块所对应的图
	var $li = $("ul.sku-color-select li:first");
	var imgSrc = $li.find("img").eq(0).attr("src");
	if (imgSrc && imgSrc.indexOf("COLOR") > -1) {
		var newPic = imgSrc.replace(/COLOR/, "LARGE");
		$(".bigpic&.fl img").eq(0).attr("src", newPic);
		$("#skuDiv .fl img").eq(0).attr("src", newPic);
	}

	//将天天抢对象放入jquery缓存，方便购物车等逻辑调用
	jQueryCache("divCache", "scareBuyingList", scareBuyingItem);
});

/// <summary>
/// 加载单品页左侧模块
/// </summary>
function LoadStyleDetailLeft(styleId) {
	$.get("http://product.m18.com/pl-" + styleId + ".htm", function(data) {
		$('.col_2_a').append(data);
		//4、为清除cookie链接绑定事件
		BindClearCookieButton();
		
		//7、最近浏览记录加载
		try {
			ShowLastestViewedItems();
		}
		catch (e) {

		}

		//9、绑定品牌订阅区域
		$('.subscribeA').click(function() {
			if ($('#subscribe').length == 0) {
				var isrc = $(this).attr('href');
				$('<div id="subMask" style="background:#000;position:absolute;top:0;left:0;z-index:90;"></div>').appendTo('body').css({ opacity: 0.5 }).width($(document).width()).height($(document).height());
				$('<iframe id="subscribe" frameborder="0" style="width:550px;height:400px;position:absolute;top:50%;left:50%;margin-left:-275px;z-index:100;"></iframe>').attr('src', isrc).appendTo('body').css({ marginTop: $(window).scrollTop() - 200 });
			}
			return false;
		});
	});
}

/// <summary>
/// 为页面上的元素绑定事件
/// </summary>
function BindEvent() {
	//1、搭配区域的 下一套 链接
	if ($("#btnMatchingPn").size() > 0) {
		$("#btnMatchingPn").bind("click", function() {
			var matchingNumber = new Number($("#matchingDl").attr("matchingNumber"));

			$("#matchingDl").fadeOut(300, function() {
				ChangeMatching(matchingNumber, "next");
				$("#matchingDl").fadeIn(300);
			});
			return false;
		});
	}

	//2、搭配区域的 上一套 链接
	if ($("#btnMatchingPu").size() > 0) {
		$("#btnMatchingPu").bind("click", function() {
			var matchingNumber = $("#matchingDl").attr("matchingNumber");
			$("#matchingDl").fadeOut(300, function() {
				ChangeMatching(matchingNumber, "prev");
				$("#matchingDl").fadeIn(300);
			});
			return false;
		});
	}

	//3、为body绑定按esc时的事件
	$("body").bind("keypress", function(event) { 
		if (event.keyCode==27)
		{
			CloseSKUDiv();
		}
	});

	//4、为页面中的人气区域 放入购物车 添加事件
	$(".sku-PopSKU").bind("click", function() {
		PopSKUDiv();
		return false;
	});

	//5、购买记录事件
	$(".alsoSaled").bind("click", function() {
		$("#id-buy-annal").trigger("click");
		window.location.hash = "#tab";
	});
	
}

/// <summary>
/// 为页面上的元素绑定事件
/// </summary>
///	<param name="number" type="int">
///		每个Matching所对应的编号，Number由1开始
///	</param>
///	<param name="type" type="string">
///		点击按钮的类型
///		"next": 下一套；"prev"：上一套
///	</param>
function ChangeMatching(number, type) {
	var arrNumber = new Array();
	//此处的matchingJson必是多个Matching的集合
	for (var index in matchingJson) {
		arrNumber.push(matchingJson[index].Number);
	}

	var matchingEntity = new Object();

	var paramNumber = new Number();
	if ("next" == type) {
		//下一套
		paramNumber = 1;
		if (IsInArray(number + 1, arrNumber)) {
			paramNumber = number + 1;
		}
	}
	else {
		//上一套
		paramNumber = arrNumber[arrNumber.length - 1];
		if (IsInArray(number - 1, arrNumber)) {
			paramNumber = number - 1;
		}
	}
	matchingEntity = GetMatchingByNumber(paramNumber, matchingJson);
	//利用matchingEntity来填充搭配区域
	FillMatching(matchingEntity);
}

/// <summary>
/// 根据number获取
/// </summary>
///	<param name="number" type="int">
///		每个Matching所对应的编号
///	</param>
///	<param name="matchingJson" type="Element">
///		Mathcing所对应的复杂Json对象，具体请在StyleDetail.aspx查看属性MatchingJson
///	</param>
function GetMatchingByNumber(number, matchingList) {
	for (var i in matchingList) {
		if (number == matchingList[i].Number) {
			return matchingList[i];
		}
	}
	return null;
}

function FillMatching(matchingEntity) {
	//1、更改 更多搭配 链接的地址
	var matchingHref = "http://product.m18.com/mc-" + matchingEntity.MatchingClassId + ".htm";
	$("#matchingHref").attr("href", matchingHref);

	//2、清空matchingDl中的所有html内容
	$("#matchingDl").html("");
	$("#matchingDl").attr("matchingNumber", matchingEntity.Number);

	//3、进行填充
	if (matchingEntity.ImageFileName != null && matchingEntity.ImageFileName != "") {
		$("#matchingDl").append("<dt class='mt01'></dt>");
		$("#matchingDl dt.mt01").append("<img src='http://img.m18.com/matching/SuperMap/"
										+ matchingEntity.MatchingClassId + "/"
										+ matchingEntity.MatchingId + "M"
										+ matchingEntity.ImageFileName
										+ "' width='90' height='120' />");
		$("#matchingDl dt.mt01").append("<span>搭配效果</span>");
	}

	
	if (matchingEntity != null && matchingEntity.KitStyleId != "") {
		$("#matchingDl dt.mt01").append("<a href='http://product.m18.com/k-" + matchingEntity.KitStyleId + ".htm' class='block'>整套一起购买</a>");
	}

	for (var i in matchingEntity.MatchingStyleList) {
		var item = matchingEntity.MatchingStyleList[i];
		$("#matchingDl").append("<dd styleId='" + item.StyleId + "'></dd>");
		$("#matchingDl dd[styleId='" + item.StyleId + "']").append("<a target='_blank' href='http://www.m18.com/app/AdEntrance.aspx?from=MNZ009C&amp;targetURL=http://product.m18.com/p-"
				+ item.StyleId + ".htm'><img alt='" + item.ChineseName
				+ "' src='http://img.m18.com/GOODS/SuperMap/" + item.ClassId3 + "/" + item.StyleId
				+ "M" + item.ImageFileName + "' width='90' height='120' />" + item.ChineseName + "</a>");

		//显示原价
		if (item.IsShowOriginalPrice == 1) {
			$("#matchingDl dd[styleId='" + item.StyleId + "']").append("<p class='opr'><del>" + item.OriginalPrice + "</del></p>");
		}

		var priceClass = item.IsShowOriginalPrice == 1 ? "npr" : "ipr";
		var gPPriceHtml = "";
		if (item.GPPrice != null && item.GPPrice != "0") {
			gPPriceHtml += "<span class='hl'>+" + item.GPPrice + "积分</span>";
		}

		$("#matchingDl dd[styleId='" + item.StyleId + "']").append("<p class='" + priceClass + "'><span class='hl2'>" + item.WebSalePrice + "</span>" + gPPriceHtml + "</p>");
	}
}

/// <summary>
/// 本方法通过异步程序来处理单品页购买记录、评论、问答
/// </summary>
function ShowPageInfo() {
	var params = "'styleId':'" + styleEntityListJson[0].StyleId
                    + "','classId3':'" + styleEntityListJson[0].ClassId3
                    + "','originalStyleId':'" + styleEntityListJson[0].OriginalStyleId
                    + "'";

	$("#buy-annal").append("<p align='center'><img src='http://img.m18.com/web/i/comm/load.gif' /></p>");
	$("#buyer-comment").append("<p align='center'><img src='http://img.m18.com/web/i/comm/load.gif' /></p>");
	$("#buyer-leaveword").append("<p align='center'><img src='http://img.m18.com/web/i/comm/load.gif' /></p>");

	$.ajax(
        {
        	type: "POST",
        	contentType: "application/json",
        	url: ajaxServiceAddress.GetStyleDetailInfo,
        	data: "{" + params + "}",
        	dataType: 'json', //返回的类型为Json
        	success: function(result) {
        		var styleData = eval("(" + result.d + ")");

        		//2.向购买记录区域填充显示数据
        		$("#buy-annal p").remove();
        		var buyAnnal = eval(styleData.BuyAnnal);
        		if (typeof (buyAnnal) == undefined || buyAnnal == null) {
        			$("#buy-annal").append("<p class='no-content'>暂时没有此商品的购买记录</p>");
        			return;
        		}
        		FillBuyAnnal(buyAnnal);

        		//3.向买家评论区域填充显示数据
        		$("#buyer-comment p").remove();
        		var buyComment = eval(styleData.BuyerComment);
        		if (typeof (buyComment) == undefined || buyComment == null) {
        			$("#buyer-comment").append("<p class='no-content'>暂时没有顾客评论此商品</p>");
        			return;
        		}
        		FillBuyerComment(buyComment);

        		//4.向买家问答区域填充显示数据
        		$("#buyer-leaveword p").remove();
        		var buyLeaveword = eval(styleData.BuyerLeaveword);
        		if (typeof (buyLeaveword) == undefined || buyLeaveword == null) {
        			$("#buyer-leaveword").append("<p class='no-content'>暂时没有买家询问此商品</p>");
        			return;
        		}
        		FillBuyerLeaveword(buyLeaveword);
        	},
        	error: function(result, status) { //如果没有上面的捕获出错会执行这里的回调函数
        	$("#buy-annal p").remove();
        		$("#buyer-comment p").remove();
        		$("#buyer-leaveword p").remove();
        		$("#buy-annal").append("<p class='no-content'>暂时没有此商品的购买记录</p>");
        		$("#buyer-comment").append("<p class='no-content'>暂时没有顾客评论此商品</p>");
        		$("#buyer-leaveword").append("<p class='no-content'>暂时没有买家询问此商品</p>");
        		if (status == 'error') {
        			return;
        		}
        	}
        });
};

/// <summary>
/// 本方法通过异步程序来处理单品页最近浏览商品的展示和对cookie的操作
/// </summary>
function ShowLastestViewedItems() {
	//0、清除以前的cookie
	if (typeof ($.cookie("LatestViewedItem")) != undefined && $.cookie("LatestViewedItem") != null) {
		$.cookie("LatestViewedItem", "", { expires: -1, path: "/", domain: "m18.com", secure: true });
	}

	//1、异步读取cookie并展示
	if (typeof ($.cookie("LastView")) != undefined && $.cookie("LastView") != null) {
		//获取cookie
		var viewedItemArray = $.cookie("LastView").split("$");
		//1. 读取Cookie
		//获取每次浏览记录的数组
		var viewedItemRetunArray = new Array();

		//使用Ajax方式
		//构建Ajax请求的参数
		var params = "'styleIds':'";
		for (var i in viewedItemArray) {
			//若当前浏览记录为空，则跳过进行下次循环
			if (viewedItemArray[i] == null) {
				continue;
			}

			params += viewedItemArray[i];
			if (i != viewedItemArray.length - 1) {
				params += ",";
			}
		}
		params += "'";

		$.ajax(
        {
        	type: "POST",
        	contentType: "application/json",
        	url: ajaxServiceAddress.GetLastView,
        	data: "{" + params + "}",
        	dataType: 'json', //返回的类型为Json
        	success: function(result) {
        		var styleList = eval("(" + result.d + ")");

        		//构建来自服务端的List<LastViewStyleBizeEntity>数据
        		for (var i in styleList) {
        			styleList[i].ImgPath = "http://img.m18.com/GOODS/LARGEMAP/" + styleList[i].ImgPath;
        			var href = "http://product.m18.com";
        			switch (styleList[i].StyleType) {
        				case "Sku":
        					href += "/p-" + styleList[i].StyleId + ".htm";
        					break;
        				case "Kit":
        					href += "/k-" + styleList[i].StyleId + ".htm";
        					break;
        				case "Fix":
        					href += "/f-" + styleList[i].StyleId + ".htm";
        					break;
        				default:
        					href += "/#";
        					break;
        			}
        			styleList[i].Href = href;
        			viewedItemRetunArray.push(styleList[i]);
        		}

        		//展示cookie
        		try {
        			FillViewedItems(viewedItemRetunArray);
        		}
        		catch (e) {
        			
        		}
        	},
        	error: function(result, status) { //如果没有上面的捕获出错会执行这里的回调函数
        		if (status == 'error') {
        			return;
        		}
        	}
        });
	}

	//2.写入cookie
	var styleId = $("#styleId").text();
	//当前浏览的商品信息
	var latestViewedItem = styleId;

	//判断Cookie中是否存在信息
	if (typeof ($.cookie("LastView")) != undefined && $.cookie("LastView") != null && viewedItemArray.length > 0 && viewedItemArray[0]) {
		//标识是否添加当前的商品信息
		var canAddFlag = true;

		//判断是否需要添加商品信息
		for (var i in viewedItemArray) {
			var viewItems = viewedItemArray[i].split("^");
			//若当前商品编号已存在与cookie中，则不添加
			if (styleId == viewItems[0]) {
				canAddFlag = false;
			}
		}

		//获取老cookie字符串
		var oldLatestViewedItems = $.cookie("LastView");
		//若需要添加cookie，则将当前的cookie信息与老的cookie合并
		if (canAddFlag) {
			//当存有5条LastViewedItem信息时，移除最后一条
			if (viewedItemArray.length >= 5) {
				viewedItemArray.pop();
			}

			//构建移掉末尾元素的cookie
			var newLatestViewedItems = "";
			for (var i in viewedItemArray) {
				//最后一个元素末尾不加分隔符$
				if (i == viewedItemArray.length - 1) {
					newLatestViewedItems += viewedItemArray[i];
				}
				else {
					newLatestViewedItems += viewedItemArray[i] + "$";
				}
			}
			$.cookie('LastView', latestViewedItem + "$" + newLatestViewedItems, { expires: 7, path: "/", domain: "m18.com", secure: false });
		}
		else {
			//不需要添加cookie，则写入cookie仍是老cookie
			$.cookie('LastView', oldLatestViewedItems, { expires: 7, path: "/", domain: "m18.com", secure: false });
		}
	}
	else {
		$.cookie('LastView', latestViewedItem, { expires: 7, path: "/", domain: "m18.com", secure: false });
	}
};

/// <summary>
/// 向最近浏览商品区域填充显示数据
/// </summary>
function FillViewedItems(jsonObj) {
	if (jsonObj == undefined || jsonObj == null) {
		return;
	}

	$("#viewed .h2").eq(0).after("<ul></ul>");
	for (var index in jsonObj) {
		$("#viewed ul").eq(0).append("<li></li>");
		$("#viewed ul li:last-child").append("<a title='" + jsonObj[index].ChineseName + "' href='" + jsonObj[index].Href + "' target='_blank'></a>");
		$("#viewed ul li:last-child a").append("<img src='" + jsonObj[index].ImgPath + "' alt='" + jsonObj[index].ChineseName + "Y01' class='s-pic'/>");
		$("#viewed ul li:last-child a").append("<span>" + jsonObj[index].ChineseName + "</span>");
		var gPPriceHtml = "";
		if (jsonObj[index].GPPrice > 0) {
			gPPriceHtml = "+<em class='hl'>" + jsonObj[index].GPPrice + "积分</em>";
		}
		$("#viewed ul li:last-child a").append("<span>￥" + jsonObj[index].WebSalePrice + gPPriceHtml + "</span>");
		$("#viewed ul li:last-child a").append("<span class='lower'>" + jsonObj[index].TradeMarkName + "</span>");
	}
};

/// <summary>
/// 向购买记录区域填充显示数据
/// </summary>
function FillBuyAnnal(buyHistoryList) {
	//此商品无购买记录
	if (buyHistoryList == null || buyHistoryList.length == 0) {
		$("#buy-annal").append("<p class='no-content'>暂时没有此商品的购买记录</p>");
		return;
	}

	//构建表格
	$("#buy-annal").append("<table cellspacing='0' class='buy-record' summary='客户购买记录'></table>");
	$("#buy-annal table").eq(0).append("<thead><tr class='thead'><th scope='col' class='t1'>购买人</th><th scope='col' class='t2'>会员级别</th><th scope='col' class='t4'>数量</th><th scope='col'> </th><th scope='col' class='t3'>购买时间</th></tr></thead>");
	//是否为tr加底色
	var bcColorFlag = false;
	$("#buy-annal table").eq(0).append("<tbody></tbody>");
	for (var index in buyHistoryList) {
		//填充数据到table中
		var trClass = bcColorFlag ? "alt" : "";
		var trStr = "<tr class='" + trClass + "'><td>" + buyHistoryList[index].BuyerName
				+ "</td><td>" + buyHistoryList[index].MembershipName + "</td><td>" + buyHistoryList[index].OrderCount
				+ "</td><td> </td><td class='lower tr'>" + buyHistoryList[index].OrderDate + "</td></tr>";
		$("#buy-annal table tbody").append(trStr);
		bcColorFlag = !bcColorFlag;
	}
};

/// <summary>
/// 向买家评论区域填充显示数据
/// </summary>
function FillBuyerComment(commentList) {
	//此商品无买家评论记录
	if (commentList == null || commentList.length == 0) {
		$("#buyer-comment").append("<p class='no-content'>暂时没有顾客评论此商品</p>");
		return;
	}

	//构建ul元素
	$("#buyer-comment").append("<ul class='discusslist'></ul>");


	for (var i in commentList) {
		$("#buyer-comment ul").eq(0).append("<li class='clearfix mb10'><div class='dis-content'></div></li>");

		var innerHtml = "<div class='hy-con'><p class='tr lower mb5'><span class='fl'>"
							+ commentList[i].CommenterName + " (" + commentList[i].MembershipName + ")</span>";

		if (commentList[i].StisficationScore > 0) {
			innerHtml += "<span class='" + commentList[i].StisficationScoreClass + "'></span>";
		}

		innerHtml += commentList[i].CommentTime + "</p><p>" + commentList[i].Content + "</p></div>";
		$("#buyer-comment ul li:last-child .dis-content").append(innerHtml);
		//判断是否有回复
		if (commentList[i].ReplysList.length > 0) {
			for (var j in commentList[i].ReplysList) {
				//构建回复区域
				$("#buyer-comment ul li:last-child .dis-content").append("<div class='mt10 call-con'><p class='tr lower'><span class='block hl2 fl'>"
																		+ commentList[i].ReplysList[j].ReplyName + "</span>" + commentList[i].ReplysList[j].ReplyTime
																		+ "</p>" + commentList[i].ReplysList[j].ReplyContent + "</div>");
			}
		}
	}

	var href = "http://comm.m18.com/comment/" + styleEntityListJson[0].StyleId + "-1.htm";
	//若有评论，在底部增加 我要评论 的按钮，加强用户体验
	$("#buyer-comment").append("<div class='clearfix tr'><a target='_blank' class='a2' href='"
		+ href + "'>查看更多评论</a><a class='btn-dis ml10' href='"
		+ href + "' target='_blank'><span>我要评论</span></a></div>");
};

/// <summary>
/// 向买家问答区域填充显示数据
/// </summary>
function FillBuyerLeaveword(questionList) {
	//此商品无买家问答记录
	if (questionList == null || questionList.length == 0) {
		$("#buyer-leaveword").append("<p class='no-content'>暂时没有买家询问此商品</p>");
		return;
	}

	//构建ul元素
	$("#buyer-leaveword").append("<ul class='faq  mb10'></ul>");

	for (var i in questionList) {
		$("#buyer-leaveword .faq").eq(0).append("<li class='clearfix'><div class='faq-q'><div class='tr lower'><span class='fl'>"
												+ questionList[i].Name + " (" + questionList[i].MembershipName + ")</span>"
												+ questionList[i].QuestionTime + "</div><p>" + questionList[i].Content + "</p></div></li>");
		//判断是否有回答
		if (questionList[i].Answer.length > 0) {
			//构建回答区域
			$("#buyer-leaveword .faq .clearfix:last-child").append("<div class='faq-arrow'><span class='uparrow'></span><ul class='faq-f'></ul></div>");
			for (var j in questionList[i].Answer) {
				//判断是否第一条
				var firstClass = "";
				if (j == 0) {
					firstClass = "first";
				}

				//判断是否是客服
				var csClass = "";
				if (questionList[i].Answer[j].ReplierType == 1) {
					//是客服
					csClass = " callcenter";
				}

				//构建li
				$("#buyer-leaveword .faq .clearfix:last-child .faq-f").eq(0).append("<li class='" + firstClass + csClass
																		+ "'><div class='tr lower'><span class='fl'>" + questionList[i].Answer[j].ReplyName
																		+ "</span>" + questionList[i].Answer[j].ReplyTime + "</div><p>"
																		+ questionList[i].Answer[j].ReplyContent + "</p></li>");
			}
		}
	}
};

/// <summary>
/// 这个方法用来控制页面tab的切换
/// </summary>
function BindSwitchTab() {
	$(".tab1 a").click(function() {
		var type = $(this).attr("id");

		$(".tab1 a[class=cur]").attr("class", "");
		$(this).attr("class", "cur");

		switch (type) {
			//商品信息                 
			case "id-goods-info":
				$("#goods-info").show();
				$("#buy-annal").show();
				$("#buyer-comment").show();
				$("#buyer-leaveword").show();
				break;
			//购买记录                  
			case "id-buy-annal":
				$("#goods-info").hide();
				$("#buy-annal").show();
				$("#buyer-comment").hide();
				$("#buyer-leaveword").hide();
				break;
			//买家评论                    
			case "id-buyer-comment":
				$("#goods-info").hide();
				$("#buy-annal").hide();
				$("#buyer-comment").show();
				$("#buyer-leaveword").hide();
				break;
			//买家留言                    
			case "id-buyer-leaveword":
				$("#goods-info").hide();
				$("#buy-annal").hide();
				$("#buyer-comment").hide();
				$("#buyer-leaveword").show();
				break;
			default:
				break;
		}

		//去掉焦点虚线
		$(this).blur();
		return false;
	});
};

/// <summary>
/// 为LargMap图片加上mousemove事件，并去掉Click的链接功能
/// </summary>
function BindPicEvent() {
	$(".thumbpic li a").bind("mousemove", function() {
		if (this.innerText == "更多图片") {
			return;
		}

		//选中标识
		$(".thumbpic li a[class=cur]").attr("class", "");
		$(this).attr("class", "cur");

		var newPic = $(this).attr("href");
		$(".bigpic&.fl img").eq(0).attr("src", newPic);
	});

	$(".thumbpic li a").bind("click", function() {
		if (this.innerText == "更多图片") {
			return;
		}
		return false;
	});
};

function BindClearCookieButton() {
	$("#viewed .handle").bind("click", function() {
		$.cookie("LastView", "", { expires: -1, path: "/", domain: "m18.com", secure: true });
		$("#viewed ul").eq(0).hide();
		return false;
	});
};

function SpecialClassLogic() {
	//获取当前单品页的各级ClassId
	var classId3 = styleEntityListJson[0].ClassId3;
	var classId1 = classId3.substring(0, 2);
	var classId2 = classId3.substring(0, 4);

	var parentObj = $("div.choicebox");

	//1、 当除指定classId外，如果二维显示是“均码”，则不显示维度2，并已选择中不显示“均码”(详见bug 691)
	if (parentObj.find(".sku-size-select li").size() == 1) {

		if ((classId3 != "N30101" && classId3 != "N30102" && classId3 != "N30103" && classId3 != "N30104"
				&& classId3 != "N20201" && classId3 != "N20202" && classId3 != "N20203" && classId3 != "N20205"
				&& classId2 != "N703" && classId2 != "N704")) {

		}
		else {
			//1、隐藏维度2区域
			parentObj.find(".sku-size-title").hide();
			parentObj.find(".sku-size-select").hide();
			//2、隐藏已选择中的尺寸
			parentObj.find("span#sku-select-size").hide();
			//3、未当前维度1、维度2的所有按钮按钮绑定click事件
			parentObj.find(".sku-color-select li").bind("click", function() {
				parentObj.find("span#sku-select-size").hide();
			});
			parentObj.find(".sku-size-select li").bind("click", function() {
				parentObj.find("span#sku-select-size").hide();
			});
		}
	}
};

//用来表示skuDiv是否显示
var skuDivShowFlag = false;

///	<summary>
///	在界面中间弹出维度选择层，并添加遮罩层
///	<summary>
function PopSKUDiv() {
	//弹出层
	var width = $("#skuDiv").width();
	var height = $("#skuDiv").height();

	document.getElementById("skuDiv").style.position = 'absolute';
	document.getElementById("skuDiv").style.display = "block";
	document.getElementById("skuDiv").style.left = ($(window).width() - width) / 2 + $(window).scrollLeft() + "px";
	document.getElementById("skuDiv").style.top = ($(window).height() - height) / 2 + $(window).scrollTop() + "px";

		

	document.getElementById("skuDiv").style.zIndex = 1000;
	skuDivShowFlag = true;
	MaskSKUDiv();
	$(window).resize(MaskSKUDiv);
	return false;
}

function MaskSKUDiv() {
	if (skuDivShowFlag) {
		//mask遮罩层
		if ($("#mask").size() == 0) {
			$('<div id="mask"></div>').appendTo('body').css({ opacity: 0.5, width: $(document).width(), height: $(document).height(), top: 0, left: 0, position: 'absolute', background: '#000', 'z-index': 20 });
		} 
		else {
			$('#mask').css({ opacity: 0.5, width: $(document).width(), height: $(document).height(), top: 0, left: 0, position: 'absolute', background: '#000', 'z-index': 20 });
		}
	}
}
///	<summary>
///	关闭维度选择层和遮罩层
///	<summary>
function CloseSKUDiv() {

	skuDivShowFlag = false;
	if (null != document.getElementById("skuDiv")) {
		document.getElementById("skuDiv").style.display = "none";
	}

	if (null != document.getElementById("mask")) {
		document.body.removeChild(document.getElementById("mask"));
	}

	void (0);
}

/****************************SizeLink****************************/
$(document).ready(function() { $('<a href="#" id="gotop">返回顶部</a>').appendTo('body').hide().click(function() { $(document).scrollTop(0); $(this).hide(); return false }); var $gotop = $('#gotop'); function backTopLeft() { var btLeft = $(window).width() / 2 + 478; if (btLeft <= 950) { $gotop.css({ 'left': 955 }) } else { $gotop.css({ 'left': btLeft }) } } backTopLeft(); $(window).resize(backTopLeft); $(window).scroll(function() { if ($(document).scrollTop() === 0) { $gotop.hide() } else { $gotop.show() } if ($.browser.msie && $.browser.version == 6.0 && $(document).scrollTop() !== 0) { $gotop.css({ 'opacity': 1 }) } }) });
$(function() {
	var $brand = $('#iteminfo .brand').text();
	var $price = $('#iteminfo .price').text()
	$price = $price.substring(0, $price.length - 3);
	if ($price >= 299) {
		$('#spromotion li:eq(3)').show();
	}
	if ($('#iteminfo del').length == 0 && $brand == 'RAMPAGE') {
		$('#spromotion li:eq(0)').show();
		$('#spromotion li:eq(1)').show();
	}
});

//此方法由吕明增加
function sizeLink() {
	var classid3 = styleEntityListJson[0].ClassId3;
	var classid1 = classid3.substring(0, 2);
	var classid2 = classid3.substring(0, 4);

	if ($('ul.sku-size-select a:first').eq(0).text() == '均码' || classid1 != 'N1') {
		return;
	}
	if($('#iteminfo').find('#sizeLink').size() == 0) {
		$('<li id="sizeLink">查看适合我的尺码</li>').appendTo('#iteminfo .sku-size-select').show();
	}
	$('#sizeLink,questionSizeLink').bind('click', function() {
		$('#sizepop2').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop1').show().css({ top: 230 + $(window).scrollTop() });
		$('#sizepopwrap .mask').show().width($(document).width()).height($(document).height());
	});

};

function questionSizeLink() {
	var classid3 = styleEntityListJson[0].ClassId3;
	var classid1 = classid3.substring(0, 2);
	var classid2 = classid3.substring(0, 4);

	if ($('ul.sku-size-select a:first').eq(0).text() == '均码' || classid1 != 'N1') {
		return;
	}

	$('#buyerLeaveword').before('<a class="sizeLink fr" href="#">查看适合我的尺码</a>').show();
	$('#sizeLink,questionSizeLink').bind('click', function() {
		$('#sizepop2').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop1').show().css({ top: 230 + $(window).scrollTop() });
		$('#sizepopwrap .mask').show().width($(document).width()).height($(document).height());
	});
}


$(function() {
	var classid3 = styleEntityListJson[0].ClassId3;
	var classid1 = classid3.substring(0, 2);
	var classid2 = classid3.substring(0, 4);

	$('.sizeLink,.sizelink').live('click', function() {
		$('#sizepop2').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop1').show().css({ top: 230 + $(window).scrollTop() });
		$('#sizepopwrap .mask').show().width($(document).width()).height($(document).height());
		return false;
	});
	var size = $('#rsize');
	var bust = $('#sbust');
	var waist = $('#swaist');
	var hip = $('#ship');
	var sizebg = $('#sizepop2 .sizecon');
	var measure = $('#sizepop3 .measurements');
	function showS() {
		$('#sizepop1').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop2').show().css({ top: 230 + $(window).scrollTop() });
		sizebg.attr('id', 'sizes');
		size.text('S');
		bust.text('70A-70B');
		waist.text('1.8-1.9');
		hip.text('2.4-2.5');
	}
	function showM() {
		$('#sizepop1').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop2').show().css({ top: 230 + $(window).scrollTop() });
		sizebg.attr('id', 'sizem');
		size.text('M');
		bust.text('70C-75A');
		waist.text('2.0-2.1');
		hip.text('2.6-2.7');
	}
	function showL() {
		$('#sizepop1').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop2').show().css({ top: 230 + $(window).scrollTop() });
		sizebg.attr('id', 'sizel');
		size.text('L');
		bust.text('75B-75C');
		waist.text('2.1-2.2');
		hip.text('2.7-2.8');
	}
	function showXL() {
		$('#sizepop1').hide();
		$('#sizepop3').hide();
		$('#sizepop4').hide();
		$('#sizepop2').show().css({ top: 230 + $(window).scrollTop() });
		sizebg.attr('id', 'sizexl');
		size.text('XL');
		bust.text('80A-80B');
		waist.text('2.2-2.3');
		hip.text('2.8-2.9');
	}
	if (classid2 == 'N101' || classid2 == 'N102' || classid2 == 'N103' || classid2 == 'N104' || classid2 == 'N105' || classid2 == 'N106') {
		$('#waistlist').hide();
		$('#hiplist').hide();
		measure.text('胸围');
	}
	if (classid2 == 'N107') {
		$('#bustlist').hide();
		$('#hiplist').hide();
		measure.text('腰围');
	}
	if (classid2 == 'N109' || classid2 == 'N111') {
		$('#bustlist').hide();
		$('#waistlist').hide();
		measure.text('臀围');
	}
	if (classid2 == 'N108') {
		$('#hiplist').hide();
		measure.text('胸围，腰围');
	}
	function calcSize() {
		var sheight = $('#sheight').val();
		var weight = $('#sweight').val();
		if (isNaN(sheight) || isNaN(weight)) {
			alert('请您输入数字表示的身高体重，谢谢')
			return;
		}
		if (sheight >= 190 || sheight <= 140 || weight >= 90 || weight < 30) {
			alert('请您输入正常范围内的身高体重，谢谢')
			return;
		}
		if (sheight >= 154 && sheight <= 158 && weight >= 51 && weight < 54) {
			showS();
			return;
		}
		if (sheight >= 159 && sheight <= 163 && weight >= 54 && weight < 57) {
			showM();
			return;
		}
		if (sheight >= 164 && sheight <= 168 && weight >= 57 && weight < 60) {
			showL();
			return;
		}
		if (sheight >= 169 && sheight <= 173 && weight >= 60 && weight <= 65) {
			showXL();
			return;
		}
		$('#sizepop1').hide();
		$('#sizepop3').show().css({ top: 230 + $(window).scrollTop() });
	}
	$('#choices').click(function() { showS(); return false; })
	$('#choicem').click(function() { showM(); return false; })
	$('#choicel').click(function() { showL(); return false; })
	$('#choicexl').click(function() { showXL(); return false; })
	$('#sizepopwrap .close').click(function() {
		$(this).parents('.sizepos').hide();
		$('#sizepopwrap .mask').hide();
		return false;
	});
	$('#sizepopwrap .viewAllSize').click(function() {
		$(this).parents('.sizepos').hide();
		$('#sizepop4').show().css({ top: 230 + $(window).scrollTop() });
		return false;
	});
	$('#sizepopwrap .mask').click(function() {
		$(this).hide().siblings().hide();
		return false;
	});
	$('#sizeSub').click(calcSize);
	//new add for 查看我的适合尺码
	if ($("#size-content")) {
		$("#size-content").wrap('<div class="my-size"></div>');
		$("div.my-size").append('<div id="size-form"><span><label for="my-height">身高</label><input class="shadow" type="text" id="my-height" name="my-height" />厘米</span><span class="ml10 mr10"><label for="my-weight">体重</label><input class="ml5 shadow" type="text" id="my-weight" name="my-weight" />kg</span><input class="blod" id="size-count" type="button" value="计&nbsp;算" /></div>');
	};
	function calcSize2() {
		var myHeight = $('#my-height').val();
		var myWeight = $('#my-weight').val();
		if (isNaN(myHeight) || isNaN(myWeight)) {
			alert('请您输入数字表示的身高体重，谢谢')
			return;
		}
		if (myHeight >= 190 || myHeight <= 140 || myWeight >= 90 || myWeight < 30) {
			alert('请您输入正常范围内的身高体重，谢谢')
			return;
		}
		$('#sizepopwrap div.mask').show().width($(document).width()).height($(document).height());
		if (myHeight >= 154 && myHeight <= 158 && myWeight >= 51 && myWeight < 54) {
			showS();
			return;
		}
		if (myHeight >= 159 && myHeight <= 163 && myWeight >= 54 && myWeight < 57) {
			showM();
			return;
		}
		if (myHeight >= 164 && myHeight <= 168 && myWeight >= 57 && myWeight < 60) {
			showL();
			return;
		}
		if (myHeight >= 169 && myHeight <= 173 && myWeight >= 60 && myWeight <= 65) {
			showXL();
			return;
		}
		$('#sizepop1').hide();
		$('#sizepop3').show().css({ top: 230 + $(window).scrollTop() });
	}

	$('#size-count').click(calcSize2);
});
$(window).load(function() {
	var classid3 = styleEntityListJson[0].ClassId3;
	var classid1 = classid3.substring(0, 2);
	var classid2 = classid3.substring(0, 4);

	if ($('ul.sku-size-select a:first').eq(0).text() == '均码' || classid1 != 'N1') {
		$('#buyer-leaveword a.sizeLink').hide();
	}
});
/****************************SizeLink****************************/

