﻿/*!
 * Ext JS Library 3.4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
SampleGrid = function(limitColumns){

    function italic(value){
        return '<i>' + value + '</i>';
    }

    function change(val){
        if(val > 0){
            return '<span style="color:green;">' + val + '</span>';
        }else if(val < 0){
            return '<span style="color:red;">' + val + '</span>';
        }
        return val;
    }

    function pctChange(val){
        if(val > 0){
            return '<span style="color:green;">' + val + '%</span>';
        }else if(val < 0){
            return '<span style="color:red;">' + val + '%</span>';
        }
        return val;
    }


    var columns = [
        {id:'company',header: "定单号", width: 160, sortable: true, dataIndex: 'company'},
        {header: "金额", width: 75, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
        {header: "积分", width: 75, sortable: true, renderer: change, dataIndex: 'change'},
        {header: "总金额", width: 75, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
        {header: "时间", width: 85, sortable: true, renderer: Ext.util.Format.dateRenderer('m/d/Y'), dataIndex: 'lastChange'}
    ];

    // allow samples to limit columns
    if(limitColumns){
        var cs = [];
        for(var i = 0, len = limitColumns.length; i < len; i++){
            cs.push(columns[limitColumns[i]]);
        }
        columns = cs;
    }

    SampleGrid.superclass.constructor.call(this, {
        store: new Ext.data.Store({
            reader: new Ext.data.ArrayReader({}, [
                   {name: 'company'},
                   {name: 'price', type: 'float'},
                   {name: 'change', type: 'float'},
                   {name: 'pctChange', type: 'float'},
                   {name: 'lastChange', type: 'date', dateFormat: 'n/j h:ia'}
              ]),
            data: [
                ['20120909098989',3986,3986,3986,'9/1 12:00am'],
                ['20129898989898',6546,6546,6546,'9/1 12:00am'],
                ['20129879898989',2341,2341,2341,'9/1 12:00am'],
                ['20129878786868',5255,5255,5255,'9/1 12:00am'],
                ['20128788768786',6413,6413,6413,'9/1 12:00am'],
                ['20128786787867',3161,3161,3161,'9/1 12:00am'],
                ['20128787878787',7543,7543,7543,'9/1 12:00am'],
                ['20129878665555',6727,6727,6727,'9/1 12:00am'],
                ['20127685875758',4937,4937,4937,'9/1 12:00am'],
                ['20128787868686',4048,4048,4048,'9/1 12:00am']
            ]
        }),
        columns: columns,
        autoExpandColumn: 'company',
        height:250,
        width:600
    });


}
SampleGrid1 = function(limitColumns){

    function italic(value){
        return '<i>' + value + '</i>';
    }

    function change(val){
        if(val > 0){
            return '<span style="color:green;">' + val + '</span>';
        }else if(val < 0){
            return '<span style="color:red;">' + val + '</span>';
        }
        return val;
    }

    function pctChange(val){
        if(val > 0){
            return '<span style="color:green;">' + val + '%</span>';
        }else if(val < 0){
            return '<span style="color:red;">' + val + '%</span>';
        }
        return val;
    }


    var columns = [
        {id:'company',header: "用户名", width: 160, sortable: true, dataIndex: 'company'},
        {header: "金额", width: 75, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
        {header: "登陆次数", width: 75, sortable: true, renderer: change, dataIndex: 'change'},
        {header: "购买金额", width: 75, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
        {header: "时间", width: 85, sortable: true, renderer: Ext.util.Format.dateRenderer('m/d/Y'), dataIndex: 'lastChange'}
    ];

    // allow samples to limit columns
    if(limitColumns){
        var cs = [];
        for(var i = 0, len = limitColumns.length; i < len; i++){
            cs.push(columns[limitColumns[i]]);
        }
        columns = cs;
    }

    SampleGrid.superclass.constructor.call(this, {
        store: new Ext.data.Store({
            reader: new Ext.data.ArrayReader({}, [
                   {name: 'company'},
                   {name: 'price', type: 'float'},
                   {name: 'change', type: 'float'},
                   {name: 'pctChange', type: 'float'},
                   {name: 'lastChange', type: 'date', dateFormat: 'n/j h:ia'}
              ]),
            data: [
                ['20120909098989',3986,3986,3986,'9/1 12:00am'],
                ['20129898989898',6546,6546,6546,'9/1 12:00am'],
                ['20129879898989',2341,2341,2341,'9/1 12:00am'],
                ['20129878786868',5255,5255,5255,'9/1 12:00am'],
                ['20128788768786',6413,6413,6413,'9/1 12:00am'],
                ['20128786787867',3161,3161,3161,'9/1 12:00am'],
                ['20128787878787',7543,7543,7543,'9/1 12:00am'],
                ['20129878665555',6727,6727,6727,'9/1 12:00am'],
                ['20127685875758',4937,4937,4937,'9/1 12:00am'],
                ['20128787868686',4048,4048,4048,'9/1 12:00am']
            ]
        }),
        columns: columns,
        autoExpandColumn: 'company',
        height:250,
        width:600
    });


}
SampleGrid2 = function(limitColumns){

    function italic(value){
        return '<i>' + value + '</i>';
    }

    function change(val){
        if(val > 0){
            return '<span style="color:green;">' + val + '</span>';
        }else if(val < 0){
            return '<span style="color:red;">' + val + '</span>';
        }
        return val;
    }

    function pctChange(val){
        if(val > 0){
            return '<span style="color:green;">' + val + '%</span>';
        }else if(val < 0){
            return '<span style="color:red;">' + val + '%</span>';
        }
        return val;
    }


    var columns = [
        {id:'company',header: "名称", width: 160, sortable: true, dataIndex: 'company'},
        {header: "金额", width: 75, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
        {header: "购买次数", width: 75, sortable: true, renderer: change, dataIndex: 'change'},
        {header: "价格", width: 75, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
        {header: "时间", width: 85, sortable: true, renderer: Ext.util.Format.dateRenderer('m/d/Y'), dataIndex: 'lastChange'}
    ];

    // allow samples to limit columns
    if(limitColumns){
        var cs = [];
        for(var i = 0, len = limitColumns.length; i < len; i++){
            cs.push(columns[limitColumns[i]]);
        }
        columns = cs;
    }

    SampleGrid.superclass.constructor.call(this, {
        store: new Ext.data.Store({
            reader: new Ext.data.ArrayReader({}, [
                   {name: 'company'},
                   {name: 'price', type: 'float'},
                   {name: 'change', type: 'float'},
                   {name: 'pctChange', type: 'float'},
                   {name: 'lastChange', type: 'date', dateFormat: 'n/j h:ia'}
              ]),
            data: [
                ['20120909098989',3986,3986,3986,'9/1 12:00am'],
                ['20129898989898',6546,6546,6546,'9/1 12:00am'],
                ['20129879898989',2341,2341,2341,'9/1 12:00am'],
                ['20129878786868',5255,5255,5255,'9/1 12:00am'],
                ['20128788768786',6413,6413,6413,'9/1 12:00am'],
                ['20128786787867',3161,3161,3161,'9/1 12:00am'],
                ['20128787878787',7543,7543,7543,'9/1 12:00am'],
                ['20129878665555',6727,6727,6727,'9/1 12:00am'],
                ['20127685875758',4937,4937,4937,'9/1 12:00am'],
                ['20128787868686',4048,4048,4048,'9/1 12:00am']
            ]
        }),
        columns: columns,
        autoExpandColumn: 'company',
        height:250,
        width:600
    });


}
Ext.extend(SampleGrid, Ext.grid.GridPanel);
Ext.extend(SampleGrid1, Ext.grid.GridPanel);
Ext.extend(SampleGrid2, Ext.grid.GridPanel);