﻿
/* 此javascript用于用户的异步登陆，在用户登陆成功后执行相关的操作
** 在用户点执行相关的操作以后，第一步检查用户是否已经登陆，如果没有登陆就弹出登陆界面，如果已经登陆就真接执行相关的操作
** 创建一个对象用于处理所有的用户行为*/

var MiniLogin = {};

MiniLogin.CheckLogin = function(myCallback, title, content) { //检查用户是否登陆
	var myobj = myCallback;
	$.ajax({
		type: "POST",  //请求方式
		url: ajaxServiceAddress.CheckLogin,
		data: "{}",
		contentType: "application/json; charset=utf-8",
		success: function(json) {
			var strJson = eval('(' + json + ')');
			var strResult = strJson.d;
			if (strResult == "YES") {
				myobj.Callback();
				//ShowLoginForm(myCallback); //没有登陆的用记则显示登框，提示用户登陆
			}
			else {
				MiniLogin.ShowLoginForm(myCallback, title, content); //没有登陆的用记则显示登框，提示用户登陆
			}
		},
		error: function(x, e) {
			alert("服务器连接失败！");
		},
		complete: function(x) {
			//alert(x.responseText);
		}
	});
}
//在用户没有登陆的时候要执行的方法，用于将登陆对话框显示出来
MiniLogin.ShowLoginForm = function(myCallback, title, content) {
	// 在用户登陆成功后，执行 UserAction 方法
	// 否则等待，只到用户关闭此对话框
	//    if ($("#login-pop") != undefined) {
	//        return;
	//    }
	var loginDiv = $("<div id=\"login-pop\" ></div>");
	$("body").append(loginDiv);
	$.get(ajaxServiceAddress.LoginForm, function(data) {
		//载入登陆页数据
		var pop = $("#login-pop");
		pop.html(data);
		var popmask = $('#login-pop').find(".mask");
		popmask.width($(document).width()).height($(document).height());
		pop.slideDown(300);

		$('.overlay').css({ 'marginTop': $(window).scrollTop() - 200 });
		$('.overlaymain').css({ 'marginTop': $(window).scrollTop() - 190 });

		//关闭登陆页
		$("#CloseLogin").bind("click", function() {
			MiniLogin.CloseLoginForm();
			return false;
		});
		//用户注册后的返回页面设置
		//$("#login-pop .handle a ").attr("href", "http://login.m18.com/ContactSimpleRegister.aspx?ReturnUrl=" + location.href);
		$("#login-pop .handle a ").bind("click", function(e) {
			e.preventDefault();
			location.href = "http://login.m18.com/ContactSimpleRegister.aspx?ReturnUrl=" + escape(location.href);
		});
		//回车事件
		$("#Password").keypress(function(event) {
			if (event.which == 13) {
				$("#btnLogin").trigger("click");
			}
		});
		$("select").hide();
		// 用记点击登陆操作
		$("#btnLogin").bind("click", function() {
			var UserToken = $("#UserName").val(); //取用户名
			var PasswordWord = $("#Password").val(); //取用户密码
			if (MiniLogin.ValidateData(UserToken, PasswordWord)) {  //验证登陆信息
				MiniLogin.LoginNow(myCallback, UserToken, PasswordWord);
			}
		});
		MiniLogin.LoginTip(title, "", content);
	});
};

//关闭登陆的提示框
MiniLogin.CloseLoginForm = function() {
	//$.unblockUI();
	$("select").show();
	var pop = $("#login-pop");
	pop.remove();
};
//用户登陆的方法
MiniLogin.LoginNow = function(myCallback, UserToken, PasswordWord) {
	var myObj = myCallback;
	$.ajax({                   // 异步登陆操作
		type: "POST",  //请求方式
		url: ajaxServiceAddress.UserLogin,
		data: "{email:'" + UserToken + "',pwd:'" + PasswordWord + "'}",
		contentType: "application/json; charset=utf-8",
		success: function(json) {
			var strJson = eval('(' + json + ')');
			var strResult = eval(strJson.d);
			if (strResult[0].Result == "YES")//登陆成功"{Result:\"YES\",MemberShipId:" + passProt.MemberShipId + "}";
			{
				MiniLogin.CloseLoginForm();  //登陆成功了，关闭登陆显示层
				//跨域写用户会话信息
				var transUrl = strResult[0].Url + "?q=" + strResult[0].Param;
				$("body").append("<img src='" + transUrl + "' border='0' height='0' width='0' />");
				window.setTimeout(function() {myObj.Callback(strResult[0].MemberShipId, strResult[0].IsInvite); }, 500);
				//$("div").data("blah", strResult[0].MemberShipId);

			}
			else//登陆失败了
			{
				// 在登陆失败后提示相关的错误信息
				MiniLogin.LoginTip("", "用户名或密码不正确，请重新输入！", "");
			}
		},
		error: function(x, e) {
			alert("服务器连接失败！");
		},
		complete: function(x) {
			// alert(x.responseText);
		}
	});

};

//验证登陆信息
MiniLogin.ValidateData = function(UserToken, PasswordWord) { //用户输入验证方法
	var reEmail = /^(?:\w+\.?)*\w+@(?:\w+\.)+\w+$/;
	if ($.trim(PasswordWord).length <= 0 || $.trim(UserToken).length <= 0) {
		MiniLogin.LoginTip("", "用户名或密码不能为空，请重新输入！", "");
		return false;
	}
	//	if (reEmail.test(UserToken) == false) {
	//		MiniLogin.LoginTip("", "请输入正确的Email地址！", "");
	//		return false;
	//	}
	return true;
}
//提示信息
MiniLogin.LoginTip = function(title, message, content) { //用户登陆的相关提示信息
	//操作相关的提示信息
	if ($.trim(title) != "")
		$("#logTitle").text(title);
	if ($.trim(content) != "") {
		$("#loginContent").html(content).show();
	}
	if ($.trim(message) != "")
		$("#login_error").text(message);
};


//方法入口
MiniLogin.Action = function(myCallback, title, content) {
	this.CheckLogin(myCallback, title, content);
}



