﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Web;
using System.Windows.Forms;
using mshtml;

namespace MallHelper {
    public partial class frmMain : Form {
        Dictionary<WebBrowserEx, string> browsers = new Dictionary<WebBrowserEx, string>();
        Dictionary<string, Encoding> urls = new Dictionary<string, Encoding>();

        public frmMain() {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e) {

            PrepareUrls();

            browsers.Clear();
            tabControl1.TabPages.Clear();

            string keyword = textBox1.Text;
            if (String.IsNullOrEmpty(keyword))
                return;

            foreach (var item in urls) {

                TabPage page = new TabPage();
                page.Text = "正在加载数据...";

                WebBrowserEx browser = new WebBrowserEx();
                browser.Dock = DockStyle.Fill;
                browser.ScriptErrorsSuppressed = true;
                browser.AllowWebBrowserDrop = false;
                browser.WebBrowserShortcutsEnabled = false;
                browser.IsWebBrowserContextMenuEnabled = false;
                browser.Navigated += browser_Navigated;
                browser.DocumentCompleted += browser_DocumentCompleted;

                page.Controls.Add(browser);

                string keyword2 = HttpUtility.UrlEncode(keyword, item.Value);
                string searchUrl = String.Format(item.Key, keyword2);
                browsers.Add(browser, searchUrl);

                tabControl1.TabPages.Add(page);
            }

            LoadBrowser();
        }

        void browser_Navigated(object sender, WebBrowserNavigatedEventArgs e) {
            WebBrowser wb = sender as WebBrowser;
            IHTMLWindow2 win = (IHTMLWindow2)wb.Document.Window.DomWindow;
            string s = "window.alert = null;\r\nwindow.confirm = null;\r\nwindow.open = null;\r\nwindow.showModalDialog = null;";
            win.execScript(s, "javascript");
        }

        private void PrepareUrls() {
            urls.Clear();
            if (chbJingdong.Checked)
                urls.Add("http://search.360buy.com/Search?keyword={0}&enc=utf-8&area=1", Encoding.GetEncoding("utf-8"));
            if (chbYamaxun.Checked)
                urls.Add("http://www.amazon.cn/s/field-keywords={0}&x=0&y=0", Encoding.GetEncoding("utf-8"));
            if (chbYihaodian.Checked)
                urls.Add("http://search.yihaodian.com/s2/c0-0/k{0}/20/", Encoding.GetEncoding("utf-8"));
            if (chbYixun.Checked)
                urls.Add("http://s.51buy.com/--------.html?q={0}&YTAG=3.21002000", Encoding.GetEncoding("gb2312"));
            if (chbEtao.Checked)
                urls.Add("http://s.etao.com/search?q={0}&tab=b2c", Encoding.GetEncoding("utf-8"));
            if (chbFeihu.Checked)
                urls.Add("http://www.efeihu.com/Pages/ProductShow/Search.aspx?searchword={0}&sword={0}", Encoding.GetEncoding("gb2312"));
            if (chbTiaomao.Checked)
                urls.Add("http://list.tmall.com/search_product.htm?q={0}", Encoding.GetEncoding("gb2312"));
            if (chbXindan.Checked)
                urls.Add("http://www.newegg.com.cn/Search.aspx?keyword={0}", Encoding.GetEncoding("gb2312"));
            if(chbKuba.Checked)
                urls.Add("http://www.coo8.com/interfaces/search/showSearchResult.action?searchKeywords={0}", Encoding.GetEncoding("gb2312"));
        }

        void browser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e) {
            WebBrowser wb = sender as WebBrowser;
            if (wb.ReadyState != WebBrowserReadyState.Complete)
                return;

            TabPage page = wb.Parent as TabPage;
            page.Text = wb.DocumentTitle;
        }

        void LoadBrowser() {
            Thread thread = new Thread(new ThreadStart(delegate {
                foreach (var item in browsers) {
                    item.Key.Navigate(item.Value);
                }
            }));
            thread.Start();
        }

        private void textBox1_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode == Keys.Enter)
                btnSearch_Click(null, null);
        }
    }
}
