﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PageArea.aspx.cs" Inherits="LMN.Web.Admin.Page.PageArea" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
<title>添加品牌</title>
<link href="../css/admin.css" rel="stylesheet" type="text/css" />
<link href="../Scripts/wbox/wbox.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../Scripts/jquery-1.4.1.min.js"></script>
<script src="../Scripts/common.js" type="text/javascript"></script>
<script src="../Scripts/wbox.js" type="text/javascript"></script>
</head>
<body>
<form id="form1" runat="server" target="iframe">
<div style="padding: 20px;">
    <h4 class="title">页面列表</h4>
    <div class="division">
        <table width="100%">
            <tr>
                <th class="w240 left view" rowspan="2" style="vertical-align: top; text-align: left;">
                    <asp:Literal ID="literalView" runat="server" />
                </th>
                <td style="vertical-align: top;">
                    <div style="padding: 5px; background: #ccc;">
                        <a href="PageArea.aspx?page=index" <%=CurrPage=="index"?" style=\"color: #f00; \"":"" %>>首页</a><asp:Repeater ID="models" runat="server">
                            <ItemTemplate>
                                &nbsp;<a href="PageArea.aspx?page=channel&model=<%#Eval("id")%>" <%#CurrPage=="channel"&&Convert.ToInt32(Eval("id"))==modelId?" style=\"color: #f00; \"":"" %>><%#Eval("name") %></a></ItemTemplate>
                        </asp:Repeater>
                        <input type="hidden" id="page" name="page" value="<%=CurrPage%>" /> <input type="hidden" id="model" name="model" value="<%=modelId%>" /> <input type="hidden" id="areaId" name="areaId" value="0" /> <input type="hidden" id="itemId" name="itemId" value="0" />
                    </div>
                    <div id="addArea" style="padding: 5px; border: 1px solid #ccc; display: none;">
                        <b>区域</b>
                        <ul>
                            <li>名称：<input type="text" id="areaName" name="areaName" size="20" /> 排序：<input type="text" id="areaSort" name="areaSort" size="10" /> <input type="button" value="提交" onclick="parea()" /> <a href="javascript:;" onclick="darea()">删除</a></li>
                        </ul>
                    </div>
                    <div id="addItem">
                        <b>条目</b>
                        <ul>
                            <li><label for="itemIsTitle" title="标题栏中显示">标题</label><input type="checkbox" id="itemIsTitle" name="itemIsTitle" value="1" /> <label for="itemIsImg" title="图片显示">图片</label><input type="checkbox" id="itemIsImg" name="itemIsImg" value="1" /> 文本：<input type="text" title="图片填写图片地址" id="itemText" name="itemText" size="20" /> <a href="javascript:;" onclick="imageSel(this)">选择图片</a></li>
                            <li>链接：<input type="text" title="纯文本保持空白" id="itemHref" name="itemHref" size="20" /></li>
                            <li>排序：<input type="text" title="数字，由小到大排序" id="itemSort" name="itemSort" size="20" /></li>
                            <li><label for="itemIsRed" title="亮色显示">亮色</label><input type="checkbox" id="itemIsRed" name="itemIsRed" value="1" /> <label for="itemIsBr" title="显示换行">换行</label><input type="checkbox" id="itemIsBr" name="itemIsBr" value="1" /> <input type="button" value="提交" onclick="pitem()" /> <a href="javascript:;" onclick="ditem()">删除</a></li>
                        </ul>
                    </div>
                    <div style="padding: 5px; border: 1px solid #ccc; margin: 10px 0 0; ">链接地址：(N、M表示数字ID)<br />
                        模型：channel.aspx?model=N，分类：category.aspx?cate=N，列表：list.aspx?cate=N、list.aspx?cate=N&amp;amp;brand=M、list.aspx?cate=N&amp;amp;value=M，产品：detail.aspx?id=N，专题：topic.aspx?id=N，广告：adv.aspx?id=N</div>
                </td>
            </tr>
        </table>
    </div>
</div>
</form>
<iframe id="iframe" name="iframe" src="about:blank" style="display: none;"></iframe>
<script type="text/javascript">
    function earea(o) {
        $("#areaId").val($(o).parent().attr("id"));
        $("#areaName").val($(o).text());
        $("#areaSort").val($(o).parent().children("i").text());
        $("#addArea").show();
    }
    function aarea(o) {
        reset();
        $("#addArea").show();
    }
    function darea() {
        var areaId = $("#areaId").val();
        if (isNaN(areaId) || areaId == "0") {
            alert("请点击要删除的区域！");
            return;
        }
        if (!confirm("确认删除？"))
            return;

        $.get("Action.aspx", "action=delearea&id=" + areaId, function(data) {
            if (data == "-") {
                alert("参数错误！");
            } else if (data == "0") {
                alert("删除失败！");
            } else if (data == "-1") {
                alert("不能删除，区域下还有记录...");
            } else {
                location.reload();
            }
        });
    }
    function parea() {
        var page = $("#page").val();
        var modelId = $("#model").val();
        var areaId = $("#areaId").val();
        var areaName = $("#areaName").val();
        if (page == "") {
            alert("有错误发生，请刷新后重试！");
            return;
        }
        if (areaName == "") {
            alert("请填写区域名称！");
            return;
        }
        var areaSort = $("#areaSort").val();
        if (isNaN(areaSort)) {
            alert("请填写排序，数字，由小到大排列！");
            return;
        }
        //alert("page=" + page + "&model=" + modelId + "&id=" + areaId + "&name=" + encodeURIComponent(areaName) + "&sort=" + areaSort);
        $.post("Action.aspx?action=editarea", "page=" + page + "&model=" + modelId + "&id=" + areaId + "&name=" + encodeURIComponent(areaName) + "&sort=" + areaSort, function(data) {
            if (data == "-") {
                alert("有错误发生！请勿非法提交数据...");
            } else if (data == "-1") {
                alert("区域已经存在！");
            } else {
                location.reload();
            }
        });
    }
    function eitem(o) {
        var areaId = $(o).parent().parent().attr("id");
        var itemId = $(o).attr("id");
        //alert("id=" + itemId + "&area=" + areaId);
        $.get("Action.aspx?action=getitem&id=" + itemId + "&area=" + areaId, function(data) {
            //alert(data);
            if (data == "-") {
                alert("参数错误！请重试...");
            } else if (data == "null") {
                alert("错误！记录不存在...");
            } else {
                var obj = eval("(" + data + ")");
                $("#areaId").val(areaId);
                $("#itemId").val(itemId);
                $("#itemIsTitle").attr("checked", obj.istitle == 1);
                $("#itemIsImg").attr("checked", obj.isimg == 1);
                $("#itemText").val(obj.text);
                $("#itemHref").val(obj.href);
                $("#itemSort").val(obj.sort);
                $("#itemIsRed").attr("checked", obj.isred == 1);
                $("#itemIsBr").attr("checked", obj.isbr == 1);
                $("#addItem").show();
            }
        });
    }
    function aitem(o) {
        reset();
        $("#areaId").val($(o).parent().parent().attr("id"));
        //alert($(o).parent().attr("tagName"));
        if ($(o).parent().attr("tagName") == "DIV")
            $("#itemIsTitle").attr("checked", true);

        $("#addItem").show();
    }
    function pitem() {
        var areaId = $("#areaId").val();
        if (areaId == "0" || areaId == "") {
            alert("error.");
            location.reload();
            return false;
        }
        var itemId = $("#itemId").val();
        if (isNaN(itemId)) {
            itemId = 0;
        }
        var istitle = $("#itemIsTitle").attr("checked") ? 1 : 0;
        var isimg = $("#itemIsImg").attr("checked") ? 1 : 0;
        var text = $("#itemText").val();
        if (text == "") {
            alert("请填写显示文本内容，如果显示图片，请选择图片地址！");
            return false;
        }
        var href = $("#itemHref").val();
        var sort = $("#itemSort").val();
        if (isNaN(sort)) {
            alert("排序必须为数字！");
            return false;
        }
        var isred = $("#itemIsRed").attr("checked") ? 1 : 0;
        var isbr = $("#itemIsBr").attr("checked") ? 1 : 0;

        //alert("istitle=" + istitle + "&area=" + areaId + "&id=" + itemId + "&isimg=" + isimg + "&text=" + encodeURIComponent(text) + "&href=" + encodeURIComponent(href) + "&sort=" + sort + "&isred=" + isred + "&isbr=" + isbr);
        $.post("Action.aspx?action=edititem", "istitle=" + istitle + "&area=" + areaId + "&id=" + itemId + "&isimg=" + isimg + "&text=" + encodeURIComponent(text) + "&href=" + encodeURIComponent(href) + "&sort=" + sort + "&isred=" + isred + "&isbr=" + isbr, function(data) {
            if (data == "-") {
                alert("参数错误！");
            } else if (data == "-1") {
                alert("已经有存在的条目！");
            } else if (data == "0") {
                alert("操作失败，请重试！");
            } else {
                location.reload();
            }
        });
    }
    function ditem() {
        var itemId = $("#itemId").val();
        if (isNaN(itemId) || itemId == "0") {
            alert("请点击要删除的区域！");
            return;
        }
        if (!confirm("确认删除？"))
            return;

        $.get("Action.aspx", "action=deleitem&id=" + itemId, function(data) {
            if (data == "-") {
                alert("参数错误！");
            } else if (data == "0") {
                alert("删除失败！");
            } else {
                location.reload();
            }
        });
    }
    function reset() {
        $("#areaId").val("");
        $("#itemId").val("");
        $("#itemIsTitle").attr("checked", false);
        $("#itemIsImg").attr("checked", false);
        $("#itemText").val("");
        $("#itemHref").val("");
        $("#itemSort").val("0");
        $("#itemIsRed").attr("checked", false);
        $("#itemIsBr").attr("checked", false);
    }
</script>
</body>
</html>
