﻿//选择文件
function fileQueueError(file, errorCode, message) {
  var msg = "";
  try {
    switch (errorCode) {
      case SWFUpload.errorCode_QUEUE_LIMIT_EXCEEDED:
        msg = "文件个数超过限制...";
        break;
      case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
        msg = "文件大小错误...";
        break;
      case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
        msg = "文件大小超过限制...";
        break;
      case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
      case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
      default:
        msg = message;
        break;
    }
    $("#uploadinfo").html(msg);
  } catch (ex) {
    this.debug(ex);
  }
}
//开始上传
function fileDialogComplete(numFilesSelected, numFilesQueued) {
  try {
    if (numFilesQueued > 0) {
      this.startUpload();
    }
  } catch (ex) {
    this.debug(ex);
  }
}
//上传进度
function uploadProgress(file, bytesLoaded) {
  try {
    var percent = Math.ceil((bytesLoaded / file.size) * 100);
    if (percent != 100) {
      $("#uploadinfo").html('上传中...');
    }
  } catch (ex) {
    this.debug(ex);
  }
}
//单个文件上传成功
function uploadSuccess(file, serverData) {
  try {
    $("#uploadinfo").html('完成，下一个...');
  } catch (ex) {
    this.debug(ex);
  }
}
// 队列上传完成
function uploadComplete(file) {
  try {
    /*  I want the next upload to continue automatically so I'll call startUpload here */
    if (this.getStats().files_queued > 0) {
      this.startUpload();
    } else {
      $("#uploadinfo").html('全部完成！');
    }
  } catch (ex) {
    this.debug(ex);
  }
}
//上传错误
function uploadError(file, errorCode, message) {
  var msg = "";
  try {
    switch (errorCode) {
      case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
        msg = "上传取消";
        break;
      case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
        msg = "上传停止";
        break;
      case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
        msg = "上传超限";
        break;
      default:
        msg = message;
        break;
    }
    $("#uploadinfo").html(msg);
  } catch (ex3) {
    this.debug(ex3);
  }
}

//function addImage(src) {
//  var newImg = document.createElement("img");
//  newImg.style.margin = "5px";

//  document.getElementById("thumbnails").appendChild(newImg);
//  if (newImg.filters) {
//    try {
//      newImg.filters.item("DXImageTransform.Microsoft.Alpha").opacity = 0;
//    } catch (e) {
//      // If it is not set initially, the browser will throw an error.  This will set it if it is not set yet.
//      newImg.style.filter = 'progid:DXImageTransform.Microsoft.Alpha(opacity=' + 0 + ')';
//    }
//  } else {
//    newImg.style.opacity = 0;
//  }

//  newImg.onload = function() {
//    fadeIn(newImg, 0);
//  };
//  newImg.src = src;
//}

//function fadeIn(element, opacity) {
//  var reduceOpacityBy = 5;
//  var rate = 30; // 15 fps

//  if (opacity < 100) {
//    opacity += reduceOpacityBy;
//    if (opacity > 100) {
//      opacity = 100;
//    }

//    if (element.filters) {
//      try {
//        element.filters.item("DXImageTransform.Microsoft.Alpha").opacity = opacity;
//      } catch (e) {
//        // If it is not set initially, the browser will throw an error.  This will set it if it is not set yet.
//        element.style.filter = 'progid:DXImageTransform.Microsoft.Alpha(opacity=' + opacity + ')';
//      }
//    } else {
//      element.style.opacity = opacity / 100;
//    }
//  }

//  if (opacity < 100) {
//    setTimeout(function() {
//      fadeIn(element, opacity);
//    }, rate);
//  }
//}

///* ******************************************
//*	FileProgress Object
//*	Control object for displaying file info
//* ****************************************** */

//function FileProgress(file, targetID) {
//  this.fileProgressID = "divFileProgress";

//  this.fileProgressWrapper = document.getElementById(this.fileProgressID);
//  if (!this.fileProgressWrapper) {
//    this.fileProgressWrapper = document.createElement("div");
//    this.fileProgressWrapper.className = "progressWrapper";
//    this.fileProgressWrapper.id = this.fileProgressID;

//    this.fileProgressElement = document.createElement("div");
//    this.fileProgressElement.className = "progressContainer";

//    var progressCancel = document.createElement("a");
//    progressCancel.className = "progressCancel";
//    progressCancel.href = "#";
//    progressCancel.style.visibility = "hidden";
//    progressCancel.appendChild(document.createTextNode(" "));

//    var progressText = document.createElement("div");
//    progressText.className = "progressName";
//    progressText.appendChild(document.createTextNode(file.name));

//    var progressBar = document.createElement("div");
//    progressBar.className = "progressBarInProgress";

//    var progressStatus = document.createElement("div");
//    progressStatus.className = "progressBarStatus";
//    progressStatus.innerHTML = "&nbsp;";

//    this.fileProgressElement.appendChild(progressCancel);
//    this.fileProgressElement.appendChild(progressText);
//    this.fileProgressElement.appendChild(progressStatus);
//    this.fileProgressElement.appendChild(progressBar);
//    this.fileProgressWrapper.appendChild(this.fileProgressElement);

//    document.getElementById(targetID).appendChild(this.fileProgressWrapper);
//    fadeIn(this.fileProgressWrapper, 0);
//  } else {
//    this.fileProgressElement = this.fileProgressWrapper.firstChild;
//    this.fileProgressElement.childNodes[1].firstChild.nodeValue = file.name;
//  }
//  this.height = this.fileProgressWrapper.offsetHeight;
//}
//FileProgress.prototype.setProgress = function(percentage) {
//  this.fileProgressElement.className = "progressContainer green";
//  this.fileProgressElement.childNodes[3].className = "progressBarInProgress";
//  this.fileProgressElement.childNodes[3].style.width = percentage + "%";
//};
//FileProgress.prototype.setComplete = function() {
//  this.fileProgressElement.className = "progressContainer blue";
//  this.fileProgressElement.childNodes[3].className = "progressBarComplete";
//  this.fileProgressElement.childNodes[3].style.width = "";
//};
//FileProgress.prototype.setError = function() {
//  this.fileProgressElement.className = "progressContainer red";
//  this.fileProgressElement.childNodes[3].className = "progressBarError";
//  this.fileProgressElement.childNodes[3].style.width = "";
//};
//FileProgress.prototype.setCancelled = function() {
//  this.fileProgressElement.className = "progressContainer";
//  this.fileProgressElement.childNodes[3].className = "progressBarError";
//  this.fileProgressElement.childNodes[3].style.width = "";
//};
//FileProgress.prototype.setStatus = function(status) {
//  this.fileProgressElement.childNodes[2].innerHTML = status;
//};

//FileProgress.prototype.toggleCancel = function(show, swfuploadInstance) {
//  this.fileProgressElement.childNodes[0].style.visibility = show ? "visible" : "hidden";
//  if (swfuploadInstance) {
//    var fileID = this.fileProgressID;
//    this.fileProgressElement.childNodes[0].onclick = function() {
//      swfuploadInstance.cancelUpload(fileID);
//      return false;
//    };
//  }
//};
