﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CategoryAdd.aspx.cs" Inherits="LMN.Web.Admin.Shop.CategoryAdd" %>

<%@ Import Namespace="LMN.Common" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<title></title>
<link href="../css/admin.css" rel="stylesheet" type="text/css" />
<link href="../Scripts/wbox/wbox.css" rel="stylesheet" type="text/css" />
<script src="../Scripts/jquery-1.4.1.min.js" type="text/javascript"></script>
<script src="../Scripts/wbox.js" type="text/javascript"></script>
<script src="../Scripts/common.js" type="text/javascript"></script>
</head>
<body>
<form id="form1" runat="server" target="iframe">
    <div style="padding: 20px;">
        <h4 class="title">分类信息</h4>
        <div class="division">
            <table width="100%">
                <tr>
                    <th class="w120">分类名称: </th>
                    <td><input type="text" runat="server" value="" name="name" id='name' class='x-input' /></td>
                </tr>
                <tr>
                    <th>上级分类:</th>
                    <td><select size="1" name="parentid" id="parentid">
                        <option value="0">----无----</option>
                        <%=CategorySelectList%></select> <span class="notice-inline">顶级分类请选择"无"</span></td>
                </tr>
                <tr>
                    <th>商品类型:</th>
                    <td><select name="modelid" id="modelid" size="1">
                        <option value="0">请选择...</option>
                        <%=ModelSelectList%></select></td>
                </tr>
                <tr>
                    <th>排序:</th>
                    <td><input runat="server" style="width: 50px;" value="0" name="sort" id="sort" class="_x_ipt" /> <span class="notice-inline">数字越小越靠前</span></td>
                </tr>
            </table>
        </div>
        <h4 class="title">关联品牌：</h4>
        <div class="division">
            <table>
                <tr>
                    <th class="right w120">品牌关联:</th>
                    <td>
                        <asp:Repeater ID="Repeater1" runat="server">
                            <ItemTemplate>
                                <input type="checkbox" id="brand_<%#Eval("id") %>" name="brand" value="<%#Eval("id") %>" /><label for="brand_<%#Eval("id") %>"><%#Eval("name") %></label>
                            </ItemTemplate>
                        </asp:Repeater>
                    </td>
                </tr>
            </table>
        </div>
        <h4 class="title">扩展属性：<a id="attrAdd" href="javascript:;">+<span>添加</span></a></h4>
        <div class="division">
            <table>
                <tr class="left">
                    <th class="chk">搜索</th>
                    <th class="w120">属性名称</th>
                    <th class="w120" title="后台添加以及前台显示类型">显示类型</th>
                    <th>备选属性[以|分隔]</th>
                    <th class="w20">排序</th>
                    <th class="w60">刪除</th>
                </tr>
                <tbody id="attrBox">
                </tbody>
                <%--<tr>
                    <td colspan="7"><span class="sysiconBtn">添加扩展属性</span><span class="notice-inline"></span></td>
                </tr>--%>
            </table>
        </div>
        <h4 class="title">模型规格：<a id="specAdd" href="javascript:;">+<span>添加</span></a></h4>
        <div class="division">
            <table>
                <tr>
                    <th class="right w120">规格列表</th>
                    <td>
                        <ul id="specBox">
                        </ul>
                    </td>
                </tr>
                <%--<tr>
                    <td colspan="2"><span id="specAdd" class="sysiconBtn">添加规格</span></td>
                </tr>--%>
            </table>
        </div>
        <h4 class="title">优化信息</h4>
        <div class="division">
            <table width="100%">
                <tr>
                    <th class="w120">页面标题</th>
                    <td><input runat="server" type="text" id="title" name="title" style="width: 360px" maxlength="255" value="" /></td>
                </tr>
                <tr>
                    <th>页面关键词</th>
                    <td><input runat="server" type="text" id="keywords" name="keywords" style="width: 360px" maxlength="255" value="" /></td>
                </tr>
                <tr>
                    <th>页面描述</th>
                    <td>
                        <textarea runat="server" id="description" name="description" rows="4" style="width: 360px" cols="35" maxlength="255"></textarea></td>
                </tr>
                <tr>
                    <th>&nbsp;</th>
                    <td><b class="submitBtn"><input type="submit" value="保存" /></b></td>
                </tr>
            </table>
        </div>
    </div>
</form>
<iframe id="iframe" name="iframe" src="about:blank" style="display: none;"></iframe>
<script type="text/javascript">
var categoryId = <%=RequestHelper.QueryInt("id") %>;

// 初始化
$(document).ready(function() {
    if(categoryId!=0) {
        // 加载属性
        $.get("Action.aspx?action=categoryattrs&id=" + categoryId + "&" + new Date(), function(data) {
            if (data != "" && data != "null") {
                var attrJson = eval(data);
                for (var j = 0; j < attrJson.length; j++) {
                    var str = "";
                    if (attrJson[j].values != "" && attrJson[j].values != null) {
                        var v = attrJson[j].values; // eval();
                        for (var k = 0; k < v.length; k++) {
                            str += (str == "" ? "" : "|") + v[k].value;
                        }
                    }

                    $("#attrBox").append(attrRow(attrJson[j].id, attrJson[j].name, attrJson[j].type, str, attrJson[j].search, attrJson[j].sort));
                }
            }
        });

        // 加载规格
        $.get("Action.aspx?action=categoryspecs&id=" + categoryId + "&" + new Date(), function(data) {
            if (data != "" && data != "null") {
                var specJson = eval(data);
                for (var j = 0; j < specJson.length; j++) {
                    if ($("input[name=spec]").length > 0) {
                        var temp = ",";
                        $("input[name=spec]").each(function() {
                            temp += $(this).val() + ",";
                        });
                        if (temp.indexOf("," + specJson[j].id + ",") == -1) {
                            $("#specBox").append(specRow(specJson[j].id, specJson[j].name, specJson[j].note));
                        }
                    } else {
                        $("#specBox").append(specRow(specJson[j].id, specJson[j].name, specJson[j].note));
                    }
                }
            }
        });

        $.get("Action.aspx?action=categorybrands&id=" + categoryId + "&" + new Date(), function(data) {
            if (data != "" && data != "null") {
                var brands = ",";
                var brandJson = eval(data);
                for (var j = 0; j < brandJson.length; j++) {
                    brands += brandJson[j].id + ",";
                }
                if(brands==",") return;
                $("input[type=checkbox][name=brand]").each(function() {
                    var brandId = "," +$(this).val() + ",";
                    $(this).attr("checked", brands.indexOf( brandId) != -1);
                });
            }
        });
    }
});

$("#btnSave").click(function() {
  if ($("#name").val() == "") {
    $("#name").css("background", "#ff0000").focus();
    return false;
  }
  if ($("#path").val() == "") {
    $("#path").css("background", "#ff0000").focus();
    return false;
  }

  $("#form1").attr("target", "iframe").submit();
  return true;
});

function swch(o) {
    var obj = $(o);
    if (obj.text() == "是") {
        obj.text("否");
        obj.parent().children("input[type=hidden]").val("0");
    } else {
        obj.text("是");
        obj.parent().children("input[type=hidden]").val("1");
    }
    //alert(obj.parent().children("input[type=hidden]").val());
}
// 属性
function attrRow(i, n, s, v, c, t) {
  var str = '<tr>';
  str += '<td><a href="javascript:;" onclick="swch(this)">' + (c == 1 ? '是' : '否') + '</a><input type="hidden" id="attrSearch" name="attrSearch" value="'+c+'" /></td>';
  str += '<td><input type="hidden" id="attrId" name="attrId" value="' + i + '" /><input type="text" size="10" id="attrName" name="attrName" value="' + n + '" /></td>';
  str += '<td><select id="attrType" name="attrType"><option value="1"' + (s == 1 ? ' selected="selected"' : '') + '>单选框</option><option value="2"' + (s == 2 ? ' selected="selected"' : '') + '>复选框</option><option value="3"' + (s == 3 ? ' selected="selected"' : '') + '>下拉框</option></select></td>';
  // <option value="4"' + (s == 4 ? ' selected="selected"' : '') + '>输入框</option>
  str += '<td><input type="text" id="attrValue" name="attrValue" size="60" value="' + v + '" /></td>';
  str += '<td><input type="text" id="attrSort" name="attrSort" size="5" value="' + t + '" /></td>';
  str += '<td style="text-align: center;"><a href="javascript:;" onclick="attrDele(this)" style="color: #f00;">删除</a></td>';
  str += '</tr>';
  return str;
}
$("#attrAdd").click(function() {
  $("#attrBox").append(attrRow(0, "", "", "", 1, 9));
});
function attrDele(o) {
  if (!confirm("确认删除？"))
    return false;

  var id = $(o).parent().parent().find("input[name=attrId]").val();
  if (id == undefined || parseInt(id) == NaN) {
    alert("Err. 请重试。");
    return false;
  }
  if (parseInt(id) != 0) {
    $.get("Action.aspx?action=attrdelete&id=" + id, function(data) {
      //alert(data);
      var result = parseInt(data);
      if (result < 0) {
        alert("参数错误！");
        return false;
      } else if (result == 0) {
        alert("删除失败！");
        return false;
      } else {
        alert("删除成功！请点击“保存”保存修改...");
        $(o).parent().parent().remove();
        return true;
      }
    });
  } else {
    $(o).parent().parent().remove();
  }
  return true;
}
// 规格
function specRow(i, n, d) {
  return '<li><input type="hidden" id="spec_' + i + '" name="spec" value="' + i + '" />' + n + ' [' + d + ', <a href="javascript:;" onclick="specDele(this)">X</a>]</li>';
}
var wBox = $("#specAdd").wBox({
  requestType: "ajax",
  title: "添加商品规格",
  target: "Action.aspx?action=loadspec&" + new Date()
});
function addSpec() {
  var obj = $(".valueList input[name=color]:checked");
  if (obj.length != 1 || isNaN(obj.val())) {
    alert("请选择颜色类规格且最多只能选择一项！");
    return false;
  }
  var val = obj.val();
  obj = $(".valueList input[name=size]:checked");
  if (obj.length > 0 && obj.length != 1) {
    alert("尺码类规格最多只能选择一项！");
    return false;
  }
  if (!isNaN(obj.val())) {
    val += "," + obj.val();
  }
  // alert(val);
  $.get("Action.aspx?action=getspec&id=" + val + "&" + new Date(), function(data) {
    if (data != "null") {
      var specJson = eval(data);
      for (var j = 0; j < specJson.length; j++) {
        if ($("input[name=spec]").length > 0) {
          var temp = ",";
          $("input[name=spec]").each(function() {
            temp += $(this).val() + ",";
          });
          // alert(temp);
          if (temp.indexOf("," + specJson[j].id + ",") == -1) {
            $("#specBox").append(specRow(specJson[j].id, specJson[j].name, specJson[j].note));
          }
        } else {
          $("#specBox").append(specRow(specJson[j].id, specJson[j].name, specJson[j].note));
        }
        wBox.close();
      }
    } else {
      alert("请选择要添加的规则！");
    }
  });
}
function specDele(o) {
  if (!confirm("确认删除？"))
    return false;
  
  if(categoryId!=0) {
    var val = $(o).parent().children("input[name=spec]").val();
    $.get("Action.aspx?action=categoryspecdelete&id=" + categoryId + "&sid=" + val + "&" + new Date(), function(data) {
      if (data == "-1") {
        alert("error.");
        return false;
      }
      if (data == "0") {
        alert("删除失败！");
        return false;
      }
    });
  }
  $(o).parent().remove();
  return true;
}
</script>
</body>
</html>
