﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="index.aspx.cs" Inherits="Maticsoft.Web.team.index" %>

<%@ Register Src="../UserControls/CHeaderControl.ascx" TagName="CHeaderControl" TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="../UserControls/CFooterControl.ascx" TagName="CFooterControl" TagPrefix="uc2" %>
<%@ Register Src="../UserControls/blocksubscribe.ascx" TagName="blocksubscribe" TagPrefix="uc3" %>
<script runat="server" language="c#">
    protected override void OnLoad(EventArgs e)
    {

        base.OnLoad(e);
        systemModel = systembll.GetModel(1);
        if (systemModel != null && systemModel.Displayfailure == 1)
        {
            result = true;
        }
        SetTitle("往期团购");
        initNav();
        if (!Page.IsPostBack)
        {
            initPage();
        }
    }
    protected void pager_PageChanged(object sender, EventArgs e)
    {
        initPage();
    }

    protected void initNav()
    {
        StringBuilder sb = new StringBuilder();
        string strGID = "";
        if (Request["gid"] == null || Request["gid"].ToString() == "")
        {
            strGID = "";
            if (Request["typeid"] == null || Request["typeid"].ToString() == "")
            {
                sb.Append("<li class=\"current\"><a href=\"/team/index.aspx\">所有</a><span></span></li>");

            }
            else
            {
                sb.Append("<li ><a href=\"/team/index.aspx\">所有</a><span></span></li>");
            }
            strTitle = "所有往期团购";
            initNav(sb);
            Maticsoft.BLL.Category bCategory = new Maticsoft.BLL.Category();
            if (ASSystem != null)
            {
                if (ASSystem.cateteam == 1)
                {
                    System.Data.DataSet ds = bCategory.GetList(" Zone='group' and Display='Y' order by Sort_order desc ,Id desc ");
                    if (ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                            {
                                System.Data.DataRow dr = ds.Tables[0].Rows[i];
                                sb.Append("<li ");

                                if (strGID == dr["id"].ToString())
                                {
                                    sb.Append("class=\"current\" ");

                                }
                                sb.Append(" ><a href=\"/team/index.aspx?gid=" + dr["id"].ToString() + "\">" + dr["Name"].ToString() + "</a><span></span></li>");

                            }

                        }
                    }
                }

            }

        }
        else
        {
            strGID = Request["gid"].ToString();
            sb.Append("<li ><a href=\"/team/index.aspx\">所有</a><span></span></li>");
            initNav(sb);

            Maticsoft.BLL.Category bCategory = new Maticsoft.BLL.Category();
            if (ASSystem != null)
            {
                if (ASSystem.cateteam == 1)
                {
                    System.Data.DataSet ds = bCategory.GetList(" Zone='group' and Display='Y' order by Sort_order desc ,Id desc");
                    if (ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                            {
                                System.Data.DataRow dr = ds.Tables[0].Rows[i];
                                sb.Append("<li ");

                                if (strGID == dr["id"].ToString())
                                {
                                    sb.Append("class=\"current\" ");
                                    strTitle = dr["Name"].ToString() + "往期团购";
                                }
                                sb.Append(" ><a href=\"/team/index.aspx?gid=" + dr["id"].ToString() + "\">" + dr["Name"].ToString() + "</a><span></span></li>");

                            }

                        }
                    }
                }

            }


        }
        strNav = sb.ToString();
    }

    protected void initNav(StringBuilder sb)
    {

        if (Request["typeid"] == null || Request["typeid"].ToString() == "")
        {
            sb.Append("<li><a href=\"/team/index.aspx?typeid=1\">今日团购</a><span></span></li>");
            sb.Append("<li><a href=\"/team/index.aspx?typeid=3\">成功团购</a><span></span></li>");
            if (ASSystem != null)
            {
                if (ASSystem.Displayfailure == 1)
                {
                    sb.Append("<li><a href=\"/team/index.aspx?typeid=2\">失败团购</a><span></span></li>");
                }
            }

        }
        else
        {
            if (Request["typeid"].ToString() == "1")
            {
                sb.Append("<li class=\"current\"><a href=\"/team/index.aspx?typeid=1\">今日团购</a><span></span></li>");
                sb.Append("<li><a href=\"/team/index.aspx?typeid=3\">成功团购</a><span></span></li>");
                if (ASSystem != null)
                {
                    if (ASSystem.Displayfailure == 1)
                    {
                        sb.Append("<li><a href=\"/team/index.aspx?typeid=2\">失败团购</a><span></span></li>");
                    }
                }
                strTitle = "今日往期团购";
            }
            if (Request["typeid"].ToString() == "3")
            {
                sb.Append("<li ><a href=\"/team/index.aspx?typeid=1\">今日团购</a><span></span></li>");
                sb.Append("<li class=\"current\"><a href=\"/team/index.aspx?typeid=3\">成功团购</a><span></span></li>");
                if (ASSystem != null)
                {
                    if (ASSystem.Displayfailure == 1)
                    {
                        sb.Append("<li><a href=\"/team/index.aspx?typeid=2\">失败团购</a><span></span></li>");
                    }
                }
                strTitle = "成功往期团购";
            }
            if (Request["typeid"].ToString() == "2")
            {
                sb.Append("<li ><a href=\"/team/index.aspx?typeid=1\">今日团购</a><span></span></li>");
                sb.Append("<li><a href=\"/team/index.aspx?typeid=3\">成功团购</a><span></span></li>");
                if (ASSystem != null)
                {
                    if (ASSystem.Displayfailure == 1)
                    {
                        sb.Append("<li  class=\"current\"><a href=\"/team/index.aspx?typeid=2\">失败团购</a><span></span></li>");
                    }
                }
                strTitle = "失败往期团购";
            }

        }

    }


    protected void initPage()
    {

        string strSqlWhere = "  Team_type='normal'";


        string strGID = "";
        if (Request["gid"] == null || Request["gid"].ToString() == "")
        {
            strGID = "";
        }
        else
        {
            strGID = Request["gid"].ToString();
        }
        if (!Utils.Utility.IsNum(strGID))
        {
            SetError("参数有误！");
            return;
        }


        string strType = Utils.Helper.GetString(Request["typeid"], String.Empty);
        switch (strType)
        {
            case "1":
                strSqlWhere = strSqlWhere + " and Begin_time<=GetDate() and End_time >=GetDate()";
                break;
            case "3":
                strSqlWhere = strSqlWhere + " and Begin_time<=GetDate() and  End_time <GetDate() ";
                break;
            case "2":
                strSqlWhere = strSqlWhere + " and Begin_time<=GetDate() and  End_time <GetDate() ";
                break;
            default:
                strSqlWhere = strSqlWhere + " and Begin_time<=GetDate()  ";
                break;
        }
        if (!result)
        {
            strSqlWhere = strSqlWhere + " and not (End_time<GetDate() and Now_number<Min_number)";
            
        }

        if (strGID != "")
        {
            strSqlWhere = strSqlWhere + " and Group_id=" + strGID;
        }
        if (Request["id"] != null && Request["id"].ToString() != "")
        {
            strSqlWhere = strSqlWhere + " and id=" + Request["id"].ToString();
        }
        int recordCount;
        Maticsoft.BLL.Team bTeam = new Maticsoft.BLL.Team();
        StringBuilder sb = new StringBuilder();
        System.Data.DataSet ds = Maticsoft.DBUtility.DbHelperSQL.Page(10, pager.CurrentPageIndex, "Team", strSqlWhere, " begin_time desc,Sort_order desc ,Id desc", "*", out recordCount);

        if (ds != null)
        {
            if (ds.Tables.Count > 0)
            {
                if (ds.Tables[0].Rows.Count > 0)
                {
                    for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                    {
                        System.Data.DataRow dr = ds.Tables[0].Rows[i];
                        string Currency = "";
                        int Moneysave = 0;
                        if (ASSystem != null)
                        {
                            Currency = ASSystem.Currency;
                            
                            Moneysave = int.Parse(float.Parse(ASSystem.Moneysave.ToString()).ToString());
                        }

                        sb.Append("<li class=\" first\">");
                        sb.Append("<p class=\"time\">" + DateTime.Parse(dr["Begin_time"].ToString()).ToString("yyyy-MM-dd").ToString() + "</p>");

                        sb.Append("<h4><a href=\"/team.aspx?id=" + dr["id"].ToString() + "\" title=\"" + dr["Title"].ToString() + "\" target=\"_blank\">" + dr["Title"].ToString() + "</a></h4>");
                        sb.Append("<div class=\"pic\">");
                        //判断项目状态
                        //如果开始时间小等于当前时间，并且结束时间大于等于当前的时间卖光或者正在进行。
                        if (Convert.ToDateTime(dr["End_time"].ToString()) >= time)
                        {
                            //如果最大购买人数不等于0 并且最大购买人数小于等于当前购买人数则这个项目属于卖光
                            if (Convert.ToInt32(dr["Max_number"].ToString()) != 0)
                            {
                                
                                if (Convert.ToInt32(dr["Now_number"].ToString()) >= Convert.ToInt32(dr["Max_number"].ToString()))
                                {
                                    //这个项目属于卖光
                                    sb.Append("<div class='isopen'></div>");

                                }
                                else
                                {
                                    //否则这个项目属于正在进行中
                                    sb.Append("<div class='normal_on'></div>");
                                }
                            }
                            else
                            {
                                //否则这个项目属于正在进行中
                                sb.Append("<div class='normal_on'></div>");
                            }

                        }
                        else
                        {
                            //否则这个项目结束
                             sb.Append("<div class='normal_off' ></div>");
                        }

                        sb.Append("<a href=\"/team.aspx?id=" + dr["id"].ToString() + "\" class=\"isopenlink\" title=\"" + dr["Title"].ToString() + "\" target=\"_blank\"> width=\"200\" height=\"121\"></a>");
                        sb.Append("<a href=\"/team.aspx?id=" + dr["id"].ToString() + "\" title=\"" + dr["Title"].ToString() + "\" target=\"_blank\"><img alt=\"" + dr["Title"].ToString() + "\" src=\"" + dr["Image"].ToString() + "\" width=\"200\" height=\"121\"></a>");
                        sb.Append("</div>");
                        sb.Append("<div class=\"info\">");
                        sb.Append("<p class=\"total\"><strong class=\"count\">" + dr["Now_number"] + "</strong>人购买</p>");
                        sb.Append("<p class=\"total\"></p>");
                        string discount = Utils.WebSiteHelper.GetDiscount(Utils.Helper.GetDecimal(dr["Market_price"], 0), Utils.Helper.GetDecimal(dr["Team_price"], 0));
                        sb.Append("<p class=\"price\">原价：<strong class=\"old\"><span class=\"money\">¥</span>" + GetMoney(dr["Market_price"]) + "</strong><br />折扣：<strong class=\"discount\">" + discount + "</strong><br />现价：<strong><span class=\"money\">¥</span>" + GetMoney(dr["Team_price"]) + "</strong><br />节省：<strong><span class=\"money\">¥</span>" + GetMoney((float.Parse(dr["Market_price"].ToString()) - float.Parse(dr["Team_price"].ToString()))) + "</strong><br /></p>");
                        sb.Append("</div>");

                        if (Moneysave == 1)
                        {
                            float sum = (float.Parse(dr["Market_price"].ToString()) - float.Parse(dr["Team_price"].ToString())) * float.Parse(dr["Now_number"].ToString());
                            sb.Append("<div id=\"info_a\">共为用户节省:<strong class=\"count\">" + GetMoney(sum) + "</strong></div>");
                        }
                        sb.Append("</li>");
                    }
                }
            }
        }

        ltTeam.Text = sb.ToString();
        pager.RecordCount = recordCount;
    }
</script>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" id="">
<head id="Head1" runat="server">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
</head>
<body class="newbie">
    <form id="form1" runat="server">
    <div id="pagemasker">
    </div>
    <div id="dialog">
    </div>
    <div id="doc">
        <uc1:CHeaderControl ID="CHeaderControl1" runat="server" />
        <div id="bdw" class="bdw">
            <div id="bd" class="cf">
                <div id="recent-deals">
                    <div class="dashboard" id="dashboard">
                        <ul>
                            <%=strNav %></ul>
                    </div>
                    <div id="content">
                        <div class="box">
                            <div class="box-content">
                                <div class="head">
                                    <h2>
                                        <%=strTitle %></h2>
                                </div>
                                <div class="sect">
                                    <ul class="deals-list">
                                        <asp:Literal ID="ltTeam" runat="server"></asp:Literal>
                                    </ul>
                                    <div class="clear">
                                    </div>
                                    <div>
                                        <ul class="paginator">
                                            <li>
                                                <webdiyer:AspNetPager ID="pager" runat="server" OnPageChanged="pager_PageChanged">
                                                </webdiyer:AspNetPager>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="sidebar">
                        <uc3:blocksubscribe ID="blocksubscribe1" runat="server" />
                        <div class="bottom">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- bd end -->
    </div>
    <!-- bdw end -->
    <uc2:CFooterControl ID="CFooterControl1" runat="server" />
    </div>
    </form>
</body>
</html>
