﻿
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'ask' AND type = 'U')
   DROP table ask
;

CREATE TABLE [Ask](
	[Id] [int] IDENTITY(1,1) primary key,
	[User_id] [int] NOT NULL,
	[Team_id] [int] NOT NULL default 0,
	[City_id] [int] NOT NULL  DEFAULT 0,
	[Content] [text]  NOT NULL,
	[Comment] [text] NULL,
	[Create_time] datetime NOT NULL DEFAULT (getdate())
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Card' AND type = 'U')
   DROP table Card
;

CREATE TABLE [Card](
	[Id] [varchar](16) primary key not null,
	[Code] [varchar](16)  NOT NULL,
	[Partner_id] [int] NOT NULL,
	[Team_id] [int] NOT NULL  DEFAULT 0,
	[Order_id] [int] NOT NULL DEFAULT ((0)),
	[Credit] [int] NOT NULL,
	[consume] [varchar](1)  DEFAULT ('N'),
	[Ip] [varchar](16)  NULL,
	[Begin_time] datetime NOT NULL,
	[End_time] datetime NOT NULL,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'orderdetail' AND type = 'U')
   DROP table [orderdetail]
;
CREATE TABLE [orderdetail](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Order_id] [int] not null,
	[Num] [int] not null default 1,
	[Teamid] [int] not null,
	[Teamprice] [decimal](18, 2) not null default 0,
	[result] [text] null,
	[carno] varchar(16) null,
	[Credit] int not null default 0,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Category' AND type = 'U')
   DROP table Category
;
CREATE TABLE [Category](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Zone] [varchar](16)  NOT NULL,
	[Czone] [varchar](32)  NULL,
	[Name] [varchar](32)  NOT NULL,
	[Ename] [varchar](16)  NULL,
	[Letter] [varchar](1)  NULL,
	[Sort_order] [int] NOT NULL  DEFAULT ((0)),
	[Display] [varchar](1)  NOT NULL   DEFAULT ('N'),
) 
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Coupon' AND type = 'U')
   DROP table Coupon
;
CREATE TABLE [Coupon](
	[Id] [varchar](12) NOT NULL primary key,
	[User_id] [int] NOT NULL,
	[Partner_id] [int] NOT NULL,
	[Team_id] [int] NOT NULL,
	[Order_id] [int] NOT NULL,
	[Type] [varchar](10)  NOT NULL  DEFAULT ('consume'),
	[Credit] [int] NOT NULL DEFAULT ((0)),
	[Secret] [varchar](10)  NOT NULL,
	[Consume] [varchar](1) NULL,
	[IP] [varchar](16)  NULL,
	[Sms] [int] NOT NULL  DEFAULT ((0)),
	[Expire_time] [datetime] NOT NULL,
	[Consume_time] [datetime] NULL,
	[Create_time] [datetime] NOT NULL  DEFAULT (getdate()),
	[Sms_time] [datetime] NULL,
	[start_time] datetime null,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Feedback' AND type = 'U')
   DROP table Feedback
;
CREATE TABLE [Feedback](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[City_id] [int] NOT NULL DEFAULT ((0)),
	[User_id] [int] NOT NULL  DEFAULT ((0)),
	[Category] [varchar](10) NOT NULL,
	[title] [varchar](128)  NOT NULL,
	[Contact] [varchar](255)  NOT NULL,
	[Content] text  NOT NULL,
	[Create_time] [datetime] NOT NULL DEFAULT (getdate()),
 )
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Flow' AND type = 'U')
   DROP table Flow
;
CREATE TABLE [Flow](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[User_id] [int] NOT NULL,
	[Admin_id] [int] NOT NULL,
	[Detail_id] [varchar](32) NOT NULL,
	[Detail] [varchar](255) NULL,
	[Direction] [varchar](10) NOT NULL,
	[Money] [decimal](10, 2) NOT NULL,
	[Action] [varchar](16)  NOT NULL,
	[Create_time] [datetime] NOT NULL  DEFAULT (getdate()),
 )
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Mailer' AND type = 'U')
   DROP table Mailer 
;
CREATE TABLE [Mailer](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Email] [varchar](128)  NOT NULL,
	[City_id] [int] NOT NULL  DEFAULT ((0)),
	[Secret] [varchar](32)  NOT NULL,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Order' AND type = 'U')
   DROP table [Order] 
;
CREATE TABLE [Order](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Pay_id] [varchar](32)   NULL,
	[Service] [varchar](16)  NULL,
	[User_id] [int] NOT NULL,
	[Admin_id] [int] NOT NULL  DEFAULT ((0)),
	[Team_id] [int] NOT NULL,
	[City_id] [int] NOT NULL  DEFAULT ((0)),
	[Card_id] [varchar](16)  NULL,
	[State] [varchar](10) NOT NULL  DEFAULT ('unpay'),
	[Quantity] [int] NOT NULL  DEFAULT ((1)),
	[Realname] [varchar](128)  NULL,
	[Mobile] [varchar](128) NULL,
	[Zipcode] [varchar](16)  NULL,
	[Address] [varchar](128)  NULL,
	[Express] [varchar](1) NOT NULL  DEFAULT ('N'),
	[Express_xx] [varchar](128)  NULL,
	[Express_id] [int] NOT NULL  DEFAULT ((0)),
	[Express_no] [varchar](32) NULL,
	[Price] [decimal](10, 2) NOT NULL,
	[Money] [decimal](10, 2) NOT NULL,
	[Origin] [decimal](10, 2) NOT NULL,
	[Credit] [decimal](10, 2) NOT NULL,
	[Card] [decimal](10, 2) NOT NULL,
	[Fare] [decimal](10, 2) NOT NULL,
	[Remark] [text] NULL,
	[Create_time] [datetime] NOT NULL  DEFAULT (getdate()),
	[Pay_time] [datetime] NULL,
	[IP_Address] [varchar](500) null,
	[fromdomain] [varchar](500) null,
	[result] [text] null,
	[refundtype] int not null default 0,
	[adminremark] text null,
	
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Page' AND type = 'U')
   DROP table Page 
;
CREATE TABLE [Page](
	[Id] [varchar](16)  NOT NULL primary key,
	[Value] [text]  NULL,
)
;
insert into page(id,value)values('help_tour','玩转艾尚团购');
;
insert into page(id,value)values('help_faqs','常见问题');
;
insert into page(id,value)values('help_asdht','什么是艾尚团购');
;
insert into page(id,value)values('help_api','<p>Baidu API</p><p>http://您的网址/api.aspx?key=baidu</p><p>Sohu API</p><p>http://您的网址/api.aspx?key=sohu</p><p>Soso API</p><p>http://您的网址/api.aspx?key=soso</p><p>tuan123 API</p><p>http://您的网址/api.aspx?key=tuan123</p><p>tuan800 API</p><p>http://您的网址/api.aspx?key=tuan800</p><p>Tuanp API</p><p>http://您的网址/api.aspx?key=tuanp</p>');
;
insert into page(id,value)values('about_contact','联系方式');
;
insert into page(id,value)values('about_job','工作机会');
;
insert into page(id,value)values('about_us','艾尚团购');
;
insert into page(id,value)values('about_terms','用户协议');
;
insert into page(id,value)values('about_privacy','隐私声明');
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Partner' AND type = 'U')
   DROP table Partner 
;
CREATE TABLE [Partner](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Username] [varchar](32)  NOT NULL,
	[Password] [varchar](32)  NOT NULL,
	[Title] [varchar](128)  NOT NULL,
	[Group_id] [int] NOT NULL DEFAULT ((0)),
	[Homepage] [varchar](128)  NULL,
	[City_id] [int] NOT NULL  DEFAULT ((0)),
	[Bank_name] [varchar](128)  NULL,
	[Bank_no] [varchar](128)  NULL,
	[Bank_user] [varchar](128) NULL,
	[Location] [text] NOT NULL,
	[Contact] [varchar](32) NULL,
	[Image] [varchar](128) NOT NULL,
	[Image1] [varchar](128) NULL,
	[Image2] [varchar](128) NULL,
	[Phone] [varchar](18) NULL,
	[Address] [varchar](128) NULL,
	[Other] [text] NULL,
	[Mobile] [varchar](12) NULL,
	[Open] [varchar](1) NOT NULL DEFAULT ('N'),
	[Enable] [varchar](1) NOT NULL DEFAULT ('Y'),
	[Head] [bigint] NOT NULL DEFAULT ((0)),
	[User_id] [int] NOT NULL,
	[Create_time] [datetime] NOT NULL DEFAULT (getdate()),
	[area] varchar(1000) null,
 )
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Pay' AND type = 'U')
   DROP table Pay  
;
CREATE TABLE [Pay](
	[Id] [varchar](32) NOT NULL primary key,
	[Order_id] [int] NOT NULL default 0,
	[Bank] [varchar](32) NOT NULL,
	[Money] [decimal](18, 2) NOT NULL,
	[Currency] [varchar](10) NOT NULL DEFAULT ('''CNY'''),
	[Service] [varchar](16) NOT NULL,
	[Create_time] [datetime] NOT NULL DEFAULT (getdate()),
 )
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Smssubscribe' AND type = 'U')
   DROP table Smssubscribe  
;
CREATE TABLE [Smssubscribe](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Mobile] [varchar](18)  NOT NULL,
	[City_id] [int] NOT NULL DEFAULT ((0)),
	[Secret] [varchar](6) NOT NULL,
	[Enable] [varchar](1) NOT NULL DEFAULT ('N'),
 )
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'system' AND type = 'U')
   DROP table system  
;
CREATE TABLE [system](
	[id] [int] NOT NULL primary key,
	[sitename] [varchar](500) NULL,
	[sitetitle] [varchar](500) NULL,
	[abbreviation] [varchar](500) NULL,
	[couponname] [varchar](500) NULL,
	[currency] [varchar](500) NOT NULL DEFAULT ('￥'),
	[currencyname] [varchar](500) NULL,
	[invitecredit] [decimal](18, 2) NOT NULL DEFAULT ((0)),
	[sideteam] [int] NOT NULL DEFAULT ((20)),
	[headlogo] [varchar](256) NULL,
	[footlogo] [varchar](256) NULL,
	[emaillogo] [varchar](256) NULL,
	[printlogo] [varchar](256) NULL,
	[conduser] [int] NOT NULL DEFAULT ((0)),
	[partnerdown] [int] NOT NULL DEFAULT ((0)),
	[kefuqq] [varchar](500) NULL,
	[kefumsn] [varchar](500) NULL,
	[icp] [varchar](500) NULL,
	[statcode] [varchar](500) NULL,
	[Navpartner] [int] NOT NULL DEFAULT ((0)),
	[navseconds] [int] NOT NULL DEFAULT ((0)),
	[navgoods] [int] NOT NULL DEFAULT ((0)),
	[navforum] [int] NOT NULL DEFAULT ((0)),
	[Displayfailure] [int] NOT NULL DEFAULT ((0)),
	[teamask] [int] NOT NULL DEFAULT ((0)),
	[creditseconds] [int] NOT NULL DEFAULT ((0)),
	[smssubscribe] [int] NOT NULL DEFAULT ((0)),
	[trsimple] [int] NOT NULL DEFAULT ((0)),
	[moneysave] [int] NOT NULL DEFAULT ((0)),
	[teamwhole] [int] NOT NULL DEFAULT ((0)),
	[encodeid] [int] NOT NULL DEFAULT ((0)),
	[cateteam] [int] NOT NULL DEFAULT ((0)),
	[catepartner] [int] NOT NULL DEFAULT ((0)),
	[citypartner] [int] NOT NULL DEFAULT ((0)),
	[cateseconds] [int] NOT NULL DEFAULT ((0)),
	[categoods] [int] NOT NULL DEFAULT ((0)),
	[emailverify] [int] NOT NULL DEFAULT ((0)),
	[needmobile] [int] NOT NULL DEFAULT ((0)),
	[gobalbulletin] [text] NULL,
	[bulletin] [text] NULL,
	[alipaymid] [varchar](100) NULL,
	[alipaysec] [varchar](100) NULL,
	[alipayacc] [varchar](100) NULL,
	[yeepaymid] [varchar](100) NULL,
	[yeepaysec] [varchar](100) NULL,
	[chinabankmid] [varchar](100) NULL,
	[chinabanksec] [varchar](100) NULL,
	[tenpaymid] [varchar](100) NULL,
	[tenpaysec] [varchar](100) NULL,
	[billmid] [varchar](100) NULL,
	[billsec] [varchar](100) NULL,
	[paypalmid] [varchar](100) NULL,
	[paypalsec] [varchar](100) NULL,
	[mailhost] [varchar](100) NULL,
	[mailport] [varchar](100) NULL,
	[mailuser] [varchar](100) NULL,
	[mailssl] [int] not null default 0,
	[mailpass] [varchar](100) NULL,
	[mailfrom] [varchar](100) NULL,
	[mailreply] [varchar](100) NULL,
	[mailinterval] [int] NOT NULL DEFAULT ((0)),
	[subscribehelpphone] [varchar](100) NULL,
	[subscribehelpemail] [varchar](100) NULL,
	[smsuser] [varchar](100) NULL,
	[smspass] [varchar](100) NULL,
	[smsinterval] [int] NOT NULL DEFAULT ((0)),
	[skintheme] [varchar](500) NULL,
	[siteversion] [decimal](18, 2) NULL DEFAULT ((2.11)),
	[mailss] int not null default 0,
	[sinablog] varchar(500) null,
	[qqblog] varchar(500) null,
	[jobtime] ntext null,
	[freepost] int not null default 0,
	[enablesohulogin] int not null default 0,
	[sohuloginkey] varchar(500) null,
	[title] varchar(500) null,
	[keyword] varchar(500) null,
	[description] varchar(200) null,
	[gouwuche] int not null default 0,
	[needmoretuan] int not null default 0,
	[guowushu] int not null default 0,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Team' AND type = 'U')
   DROP table [Team];  
;
CREATE TABLE [Team](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[User_id] [int] NOT NULL,
	[Title] [varchar](500) NOT NULL,
	[Summary] [text] NULL,
	[City_id] [int] NOT NULL DEFAULT ((0)),
	[Group_id] [int] NOT NULL DEFAULT ((0)),
	[Partner_id] [int] NOT NULL DEFAULT ((0)),
	[System] [varchar](1) NOT NULL,
	[Team_price] [decimal](18, 2) NOT NULL,
	[Market_price] [decimal](18, 2) NOT NULL,
	[Product] [varchar](500) NOT NULL,
	[Per_number] [int] NOT NULL DEFAULT ((0)),
	[Min_number] [int] NOT NULL DEFAULT ((1)),
	[Max_number] [int] NOT NULL DEFAULT ((0)),
	[Now_number] [int] NOT NULL DEFAULT ((0)),
	[Manualupdate] [int] NOT NULL DEFAULT ((0)),
	[Image] [varchar](128) NOT NULL,
	[Image1] [varchar](128) NULL,
	[Image2] [varchar](128) NULL,
	[Flv] [varchar](128) NULL,
	[Mobile] [varchar](16) NULL,
	[Credit] [int] NOT NULL DEFAULT ((0)),
	[Card] [int] NOT NULL DEFAULT ((0)),
	[Fare] [int] NOT NULL DEFAULT ((0)),
	[Farefree] [int] NOT NULL DEFAULT ((0)),
	[Bonus] [int] NULL,
	[Address] [varchar](128) NULL,
	[Detail] [text] NULL,
	[Systemreview] [text] NULL,
	[Userreview] [text] NULL,
	[Notice] [text] NULL,
	[Express] [text] NULL,
	[Delivery] [varchar](10) NOT NULL DEFAULT ('coupon'),
	[State] [varchar](10) NOT NULL DEFAULT ('none'),
	[Conduser] [varchar](1) NOT NULL DEFAULT ('N'),
	[Buyonce] [varchar](1) NOT NULL DEFAULT ('Y'),
	[Team_type] [varchar](20) NOT NULL DEFAULT ('''normal'''),
	[Sort_order] [int] NOT NULL DEFAULT ((0)),
	[Expire_time] [datetime] NOT NULL DEFAULT (getdate()),
	[Begin_time] [datetime] NOT NULL DEFAULT (getdate()),
	[End_time] [datetime] NOT NULL DEFAULT (getdate()),
	[Reach_time] [datetime] NULL,
	[Close_time] [datetime] NULL,
		[bulletin] [text] null,
	[update_value] [int] not null default 0,
	[time_state] [int] not null default 0,
	[time_interval] [int] not null default 0,
	[autolimit] int not null default 0,
	[freighttype] int not null default 0,
	[start_time] datetime null,

)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'topic' AND type = 'U')
   DROP table topic  
;
CREATE TABLE [topic](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Parent_id] [int] NOT NULL DEFAULT ((0)),
	[User_id] [int] NOT NULL,
	[Title] [varchar](128)  NULL,
	[Team_id] [int] NOT NULL DEFAULT ((0)),
	[City_id] [int] NOT NULL DEFAULT ((0)),
	[Public_id] [int] NOT NULL DEFAULT ((0)),
	[Content] [text] NULL,
	[Head] [bigint] NOT NULL DEFAULT ((0)),
	[Reply_number] [int] NOT NULL DEFAULT ((0)),
	[View_number] [int] NOT NULL DEFAULT ((0)),
	[Last_user_id] [int] NOT NULL DEFAULT ((0)),
	[Last_time] [datetime] NOT NULL  DEFAULT (getdate()),
	[create_time] [datetime] NOT NULL DEFAULT (getdate()),
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'User' AND type = 'U')
   DROP table [User]  
;
CREATE TABLE [User](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Email] [varchar](128) NOT NULL,
	[Username] [varchar](128) NOT NULL,
	[Realname] [varchar](128) NULL,
	[Password] [varchar](32) NOT NULL,
	[Avatar] [varchar](128) NULL,
	[Gender] [varchar](2) NULL,
	[Newbie] [varchar](1) NOT NULL DEFAULT ('N'),
	[Mobile] [varchar](16) NULL,
	[Qq] [varchar](16) NULL,
	[Money] [decimal](18, 2) NOT NULL DEFAULT ((0)),
	[Score] [int] NOT NULL DEFAULT ((0)),
	[Zipcode] [varchar](16) NULL,
	[Address] [varchar](255)  NULL,
	[City_id] [int] NOT NULL DEFAULT ((0)),
	[Enable] [varchar](1) NOT NULL DEFAULT ((1)),
	[Manager] [varchar](1) NOT NULL DEFAULT ('N'),
	[Secret] [varchar](32) NULL,
	[Recode] [varchar](32) NULL,
	[Sns] [varchar](32) NULL,
	[IP] [varchar](16) NOT NULL,
	[Login_time] [datetime] NOT NULL DEFAULT (getdate()),
	[Create_time] [datetime] NOT NULL DEFAULT (getdate()),
	[msn] [varchar](128) NULL,
	[auth] [varchar](50) NULL,
	[IP_Address] [varchar](500) null,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'vote_feedback' AND type = 'U')
   DROP table vote_feedback 
;
CREATE TABLE [vote_feedback](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Username] [varchar](32) NULL,
	[User_id] [int] NOT NULL DEFAULT ((0)),
	[Ip] [varchar](16) NOT NULL,
	[Addtime] [datetime] NOT NULL DEFAULT (getdate()),
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'vote_feedback_input' AND type = 'U')
   DROP table vote_feedback_input
;
CREATE TABLE [vote_feedback_input](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[feedback_id] [int] NOT NULL,
	[options_id] [int] NOT NULL,
	[value] [varchar](256) NOT NULL,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'vote_feedback_question' AND type = 'U')
   DROP table vote_feedback_question  
;
CREATE TABLE [vote_feedback_question](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[feedback_id] [int] NOT NULL,
	[question_id] [int] NOT NULL,
	[options_id] [int] NOT NULL,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Invite' AND type = 'U')
   DROP table Invite   
;
CREATE TABLE [Invite](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[User_id] [int] NOT NULL,
	[Admin_id] [int] NOT NULL  DEFAULT ((0)),
	[User_ip] [varchar](16)  NULL,
	[Other_user_id] [int] NOT NULL,
	[Other_user_ip] [varchar](16) NULL,
	[Team_id] [int] NOT NULL  DEFAULT ((0)),
	[Pay] [varchar](1) NOT NULL  DEFAULT ('N'),
	[Credit] [int] NOT NULL  DEFAULT ((0)),
	[Buy_time] [datetime] NULL,
	[Create_time] [datetime] NOT NULL  DEFAULT (getdate()),
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'vote_options' AND type = 'U')
   DROP table vote_options  
;
CREATE TABLE [vote_options](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[question_id] [int] NOT NULL,
	[name] [varchar](60) NOT NULL,
	[is_br] [int] NOT NULL DEFAULT ((0)),
	[is_input] [int] NOT NULL DEFAULT ((0)),
	[is_show] [int] NOT NULL DEFAULT ((1)),
	[order] [int] NOT NULL DEFAULT ((0)),
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'vote_question' AND type = 'U')
   DROP table vote_question 
;
CREATE TABLE [vote_question](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Title] [varchar](100) NOT NULL,
	[Type] [varchar](50) NOT NULL DEFAULT ('radio'),
	[is_show] [int] NOT NULL DEFAULT ((1)),
	[Addtime] [datetime] NOT NULL DEFAULT (getdate()),
	[order] [int] NOT NULL DEFAULT ((0)),
 )
;
insert into system(id,sitename,headlogo,footlogo,emaillogo,printlogo,siteversion)values(1,'艾尚团购','/upfile/img/logo.png','/upfile/img/logo-footer.png','/upfile/img/mail-tpl-logo.png','/upfile/img/coupon-tpl-logo.jpg',1.0)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Friendlink' AND type = 'U')
   DROP table Friendlink  
;
CREATE TABLE [Friendlink](
	[Id] [int] IDENTITY(1,1) NOT NULL primary key,
	[Title] [varchar](255) NULL,
	[url] [varchar](255) NULL,
	[Logo] [varchar](255) NULL,
	[Sort_order] [int] NOT NULL DEFAULT ((0))
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'Location' AND type = 'U')
   DROP table [Location]
;
CREATE TABLE [Location](
	[id] [int] IDENTITY(1,1) NOT NULL primary key,
	[locationname] [text] NULL,
	[pageurl] [varchar](500) NULL,
	[image] [varchar](200) NULL,
	[location] [int] not null default 0,
	[createdate] [datetime] NULL default getdate(),
	[visibility] [int] NOT NULL default 0,
	[type] [int] not null default 0,
	[width] [varchar](50) NULL,
	[height] [varchar](50) NULL,
	[begintime][datetime] NOT NULL default getdate(),
    	[endtime][datetime] NOT NULL default getdate(),
    	[decpriction][text] null,
)
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'View_GetCoupon' AND type = 'V')
   DROP view View_GetCoupon
;

create view View_GetCoupon
as 
SELECT   [User].Username, [User].Email, Team.Title,team.city_id, Coupon.* FROM         Coupon LEFT OUTER JOIN Team ON Coupon.Team_id = Team.Id LEFT OUTER JOIN [User] ON Coupon.User_id = [User].Id
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'V_GetAsk' AND type = 'V')
   DROP view V_GetAsk
;
create view V_GetAsk
as 
SELECT  Ask.*, Team.Title FROM   Ask INNER JOIN Team ON Ask.Team_id = Team.Id
;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'sp_GetListByPageAndFileds' AND type = 'P')
   DROP PROCEDURE sp_GetListByPageAndFileds
;
CREATE PROCEDURE [sp_GetListByPageAndFileds]
( 
	@pageSize  int,     
	@currentPage int = 1,    
	@fields   varchar(2000), 
	@tablename  varchar(200),   
	@orderString varchar(1000),   
	@whereString varchar(1000)   
)
AS
BEGIN
 DECLARE @sql varchar(2000)
 DECLARE @strOrder varchar(2000)
 DECLARE @strWhere varchar(2000)
 declare @recordcount int 
 declare @convertorderstr varchar(100)
declare @countsql nvarchar(500)
declare @totalpage int
 set @strOrder = REPLACE(RTRIM(LTRIM(@orderString)),'order by','')
 if @strOrder != ''
  set @strOrder = ' order by ' + @strOrder
 else
  set @strOrder = ' order by ID DESC'
set @strOrder=lower(@strOrder)
set @convertorderstr=replace(@strOrder,'desc','d_e_s_c')
set @convertorderstr=replace(@convertorderstr,'asc','desc')
set @convertorderstr=replace(@convertorderstr,'d_e_s_c','asc')
 set @strWhere = REPLACE(RTRIM(LTRIM(@whereString)),'where','')
 if @strWhere != ''
  set @strWhere = ' where ' + @strWhere

set @countsql='select @a=count(*) from ' + @tablename + @strWhere
exec  sp_executesql @countsql,N'@a int output',@recordcount output 


 if @pageSize = 0
  set @sql = 'select ' + @fields + ' from ' + @tablename + @strWhere + @strOrder
 else
 begin
		if @recordcount%@pageSize=0
			set @totalpage=@recordcount/@pageSize
		else
			set @totalpage=@recordcount/@pageSize+1
	if @totalpage <=1
	 set @currentPage=1 
	 if @totalpage <@currentPage 
	  set @currentPage=@totalpage
  if @currentPage = 1
   set @sql = 'select top ' + Str(@pageSize)+' '+ @fields + ' from ' + @tablename + @strWhere + @strOrder
  else
	if (@currentPage - 1) * @pageSize > @recordcount / 2
		set @sql = 'select top ' + str(@pageSize) + ' * from (select top ' + str((@recordcount - (@currentPage - 1) * @pageSize)) + ' ' + @fields + ' from ' + @tablename + @strWhere + @convertorderstr + ') as t1  ' + @strOrder
	else
		set @sql = 'select * from(select top ' + str(@pageSize) + ' * from (select top ' + str(@pageSize * @currentPage) + ' ' + @fields + ' from ' + @tablename + @strWhere + @strOrder + ') as t1  ' + @convertorderstr + ') as t2  ' + @strOrder
	end
	set @sql = @sql + '; select '+str(@recordcount)+' as cnt'
 exec(@sql)

END

;
IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'V_GetOrder' AND type = 'V')
   DROP view V_GetOrder
;
CREATE VIEW [V_GetOrder]
AS
SELECT     [Order].*, [User].Email, [User].Username, [User].Mobile AS Expr1
FROM         [Order] INNER JOIN
                      [User] ON [Order].User_id = [User].Id
