﻿using System;
using System.IO;
using System.Text;
using System.Web;
using System.Web.UI;
using TaoBaoAPI;

public class StaticFileCachePageBase : Page
{
    protected override void Render(HtmlTextWriter writer)
    {
        StringWriter sw = new StringWriter();
        HtmlTextWriter htmlw = new HtmlTextWriter(sw);
        base.Render(htmlw);
        htmlw.Flush();
        htmlw.Close();
        string pageContent = sw.ToString();
        if (Config.isCache == "0")
        {
            base.Response.Write(pageContent);
        }
        else
        {
            string path = base.Server.MapPath("~/CacheFile/");
            if (!Directory.Exists(path))
            {
                Directory.CreateDirectory(path);
            }
            string pageUrl = StaticFileCacheModule.GetFileName(HttpContext.Current);
            Encoding code = Encoding.GetEncoding("UTF-8");
            using (StreamWriter stringWriter = new StreamWriter(path + pageUrl, false, code))
            {
                stringWriter.Write(pageContent);
            }
            base.Response.Write(pageContent);
        }
    }
}
