﻿namespace TaoBaoAPI
{
    using System;
    using System.Data;
    using System.Xml;
    using Taobao.Top.Api;
    using Taobao.Top.Api.Request;

    public class TaoBaoItem
    {
        private static string app_key = Config.app_key;
        private static string app_secret = Config.app_secret;
        private static string Fields = "cid,parent_cid,name,is_parent,status,sort_order";

        public static DataSet GetItemCats(string parent_cid)
        {
            DataSet ds = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    ds = GetItemCats(parent_cid, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return ds;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetItemCats(parent_cid, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return ds;
        }

        public static DataSet GetItemCats(string parent_cid, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            ItemcatsGetRequest req = new ItemcatsGetRequest();
            req.ParentCid = new long?((long) Convert.ToUInt32(parent_cid));
            req.Fields = Fields;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return Utility.GetDataSet("item_cats", xmlDocument);
        }

        public static XmlNode GetParentItemCats(string cids)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetParentItemCats(cids, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetParentItemCats(cids, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetParentItemCats(string cids, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            ItemcatsGetRequest req = new ItemcatsGetRequest();
            req.Cids = cids;
            req.Fields = Fields;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.SelectNodes("itemcats_get_response/item_cats/item_cat[cid='" + cids + "']").Item(0);
        }
    }
}

