﻿namespace TaoBaoAPI
{
    using System;
    using System.Data;
    using System.Runtime.InteropServices;
    using System.Xml;
    using Taobao.Top.Api;
    using Taobao.Top.Api.Request;

    public class TaoBaoKe
    {
        private string _area;
        private string _auto_send;
        private string _cid;
        private string _end_commissionNum;
        private string _end_commissionRate;
        private string _end_credit;
        private string _end_price;
        private string _is_guarantee;
        private string _keyword;
        private string _page_no;
        private string _page_size;
        private string _sort;
        private string _start_commissionNum;
        private string _start_commissionRate;
        private string _start_credit;
        private string _strat_price;
        private static string app_key = Config.app_key;
        private static string app_secret = Config.app_secret;
        private static string Fields = "iid,num_iid,title,nick,pic_url,price,click_url,commission,commission_rate,commission_num,commission_volume,shop_click_url,seller_credit_score,item_location,volume,taobaoke_cat_click_url,keyword_click_url";
        private static string nick = Config.nick;

        public static XmlNode GetItemsConvert(string iid)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetItemsConvert(iid, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetItemsConvert(iid, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetItemsConvert(string iid, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            TaobaokeItemsConvertRequest req = new TaobaokeItemsConvertRequest();
            req.Fields = Fields;
            req.Nick = Config.nick;
            req.Iids = iid;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.DocumentElement.ChildNodes.Item(0).FirstChild;
        }

        public static XmlNode GetItemsDetail(string num_iids)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetItemsDetail(num_iids, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetItemsDetail(num_iids, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        private static XmlNode GetItemsDetail(string num_iids, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            TaobaokeItemsDetailGetRequest req = new TaobaokeItemsDetailGetRequest();
            req.Fields = "click_url,shop_click_url,seller_credit_score,iid,detail_url,num_iid,title,nick,type,cid,seller_cids,props,input_pids,input_str,desc,pic_url,num,valid_thru,list_time,delist_time,stuff_status,location,price,post_fee,express_fee,ems_fee,has_discount,freight_payer,has_invoice,has_warranty,has_showcase,modified,increment,auto_repost,approve_status,postage_id,product_id,auction_point,property_alias,itemimg,propimg,sku,outer_id,is_virtural,is_taobao,is_ex,video,volume";
            req.Nick = nick;
            req.NumIids = num_iids;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.DocumentElement.ChildNodes.Item(0).FirstChild;
        }

        public static DataSet GetItemsGet(TaoBaoKe model)
        {
            DataSet ds = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    ds = GetItemsGet(model, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return ds;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetItemsGet(model, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return ds;
        }

        public DataSet GetItemsGet(TaoBaoKe model, out int count)
        {
            DataSet ds = null;
            count = 0;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    ds = this.GetItemsGet(model, app_key, app_secret, out count);
                }
                catch
                {
                    return null;
                }
                return ds;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return this.GetItemsGet(model, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount), out count);
                }
                catch
                {
                    tryCount++;
                }
            }
            return ds;
        }

        public static DataSet GetItemsGet(TaoBaoKe model, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            TaobaokeItemsGetRequest req = new TaobaokeItemsGetRequest();
            req.Fields = Fields;
            if ((model.Cid != string.Empty) && (model.Cid != "0"))
            {
                req.Cid = GetNoChengRenCid(model.Cid);
            }
            req.Nick = nick;
            req.Keyword = model.Keyword;
            req.StartPrice = model.Strat_price;
            req.EndPrice = model.End_price;
            req.Area = model.Area;
            req.StartCredit = model.Start_credit;
            req.EndCredit = model.End_credit;
            req.Sort = model.Sort;
            req.PageNo = new int?(Tools.dfStrToInt32(model.Page_no));
            req.PageSize = new int?(Tools.dfStrToInt32(model.Page_size));
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return Utility.GetDataSet("taobaoke_items", xmlDocument);
        }

        public DataSet GetItemsGet(TaoBaoKe model, string appKey, string appSecret, out int count)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            TaobaokeItemsGetRequest req = new TaobaokeItemsGetRequest();
            req.Fields = Fields;
            if ((model.Cid != string.Empty) && (model.Cid != "0"))
            {
                req.Cid = GetNoChengRenCid(model.Cid);
            }
            req.Nick = nick;
            req.Keyword = model.Keyword;
            req.StartPrice = model.Strat_price;
            req.EndPrice = model.End_price;
            req.Area = model.Area;
            req.StartCredit = model.Start_credit;
            req.EndCredit = model.End_credit;
            req.Sort = model.Sort;
            req.PageNo = Tools.dfStrToInt32(model.Page_no);
            req.PageSize =Tools.dfStrToInt32(model.Page_size);
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            try
            {
                count = int.Parse(xmlDocument.SelectSingleNode("//total_results").InnerText);
            }
            catch
            {
                count = 0;
            }
            count = (count > 0xfa0) ? 0xfa0 : count;
            return Utility.GetDataSet("taobaoke_items", xmlDocument);
        }

        public static string GetNoChengRenCid(string cid)
        {
            if ((((((cid == "2813") || (cid == "50003114")) || ((cid == "281307") || (cid == "281301"))) || (((cid == "281302") || (cid == "50006274")) || ((cid == "281304") || (cid == "281303")))) || (((cid == "50010385") || (cid == "50012829")) || ((cid == "50008889") || (cid == "50012786")))) || (cid == "50012785"))
            {
                return "16";
            }
            return cid;
        }

        public static XmlNode GetShopConvert(string sids)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetShopConvert(sids, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetShopConvert(sids, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetShopConvert(string sids, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            TaobaokeShopsConvertRequest req = new TaobaokeShopsConvertRequest();
            req.Fields = "user_id,shop_title,click_url,shop_commission.rate";
            req.Nick = Config.nick;
            req.Sids = sids;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.DocumentElement.ChildNodes.Item(0).FirstChild;
        }

        public string Area
        {
            get
            {
                return this._area;
            }
            set
            {
                this._area = value;
            }
        }

        public string Auto_send
        {
            get
            {
                return this._auto_send;
            }
            set
            {
                this._auto_send = value;
            }
        }

        public string Cid
        {
            get
            {
                return this._cid;
            }
            set
            {
                this._cid = value;
            }
        }

        public string End_commissionNum
        {
            get
            {
                return this._end_commissionNum;
            }
            set
            {
                this._end_commissionNum = value;
            }
        }

        public string End_commissionRate
        {
            get
            {
                return this._end_commissionRate;
            }
            set
            {
                this._end_commissionRate = value;
            }
        }

        public string End_credit
        {
            get
            {
                return this._end_credit;
            }
            set
            {
                this._end_credit = value;
            }
        }

        public string End_price
        {
            get
            {
                return this._end_price;
            }
            set
            {
                this._end_price = value;
            }
        }

        public string Is_guarantee
        {
            get
            {
                return this._is_guarantee;
            }
            set
            {
                this._is_guarantee = value;
            }
        }

        public string Keyword
        {
            get
            {
                return this._keyword;
            }
            set
            {
                this._keyword = value;
            }
        }

        public string Page_no
        {
            get
            {
                return this._page_no;
            }
            set
            {
                this._page_no = value;
            }
        }

        public string Page_size
        {
            get
            {
                return this._page_size;
            }
            set
            {
                this._page_size = value;
            }
        }

        public string Sort
        {
            get
            {
                return this._sort;
            }
            set
            {
                this._sort = value;
            }
        }

        public string Start_commissionNum
        {
            get
            {
                return this._start_commissionNum;
            }
            set
            {
                this._start_commissionNum = value;
            }
        }

        public string Start_commissionRate
        {
            get
            {
                return this._start_commissionRate;
            }
            set
            {
                this._start_commissionRate = value;
            }
        }

        public string Start_credit
        {
            get
            {
                return this._start_credit;
            }
            set
            {
                this._start_credit = value;
            }
        }

        public string Strat_price
        {
            get
            {
                return this._strat_price;
            }
            set
            {
                this._strat_price = value;
            }
        }
    }
}

