﻿namespace TaoBaoAPI
{
    using System;
    using System.Xml;
    using Taobao.Top.Api;
    using Taobao.Top.Api.Request;

    public class TaoBaoUser
    {
        private static string app_key = Config.app_key;
        private static string app_secret = Config.app_secret;
        private static string Fields = "user_id,nick,sex,buyer_credit,seller_credit,location,created,last_visit,birthday,type,has_more_pic,item_img_num,item_img_size,prop_img_num,prop_img_size,auto_repost,promoted_type,status,alipay_bind,consumer_protection";
        private static string nick = Config.nick;

        public static XmlNode GetUser(string nick)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetUser(nick, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetUser(nick, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetUser(string nick, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            UserGetRequest req = new UserGetRequest();
            req.Fields = Fields;
            req.Nick = nick;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.DocumentElement.ChildNodes.Item(0);
        }
    }
}

