﻿namespace TaoBaoAPI
{
    using System;
    using System.Collections.Generic;
    using System.Data;
    using System.IO;
    using System.Net;
    using System.Text;
    using System.Text.RegularExpressions;
    using System.Threading;
    using System.Web;
    using System.Web.Security;
    using System.Xml;

    public class Utility
    {
        public static int AppKeyCount()
        {
            if (Config.app_key.Contains("|") || Config.app_secret.Contains("|"))
            {
                return Config.app_key.Split(new char[] { '|' }).Length;
            }
            return 0;
        }

        public static string ArrAppKey(int count)
        {
            return Config.app_key.Split(new char[] { '|' })[count];
        }

        public static string ArrAppSecret(int count)
        {
            return Config.app_secret.Split(new char[] { '|' })[count];
        }

        public static string CheckStr(string html)
        {
            if (!string.IsNullOrEmpty(html))
            {
                html = Regex.Replace(html, "<a.*?>|</a>", "");
                return html;
            }
            html = string.Empty;
            return html;
        }

        public static string DecodingString(string Base64String)
        {
            return DecodingString(Base64String, Encoding.Default);
        }

        public static string DecodingString(string Base64String, Encoding Ens)
        {
            return Ens.GetString(Convert.FromBase64String(Base64String));
        }

        public static string EncodingString(string SourceString)
        {
            return EncodingString(SourceString, Encoding.Default).Replace("+", "%2B");
        }

        public static string EncodingString(string SourceString, Encoding Ens)
        {
            return Convert.ToBase64String(Ens.GetBytes(SourceString));
        }

        public static DataSet GetDataSet(XmlDocument objXmlDoc)
        {
            DataSet ds = new DataSet();
            ds.ReadXml(new XmlNodeReader(objXmlDoc));
            if (ds.Tables.Count > 0)
            {
                return ds;
            }
            return null;
        }

        public static DataSet GetDataSet(string pathName, XmlDocument objXmlDoc)
        {
            XmlNode items = objXmlDoc.GetElementsByTagName(pathName)[0];
            DataSet ds = new DataSet();
            StringReader sr = new StringReader("<" + pathName + ">" + items.InnerXml + "</" + pathName + ">");
            ds.ReadXml(sr);
            if (ds.Tables.Count > 0)
            {
                return ds;
            }
            return null;
        }

        public static string GetPostUrl(string app_secret, SortedList<string, string> parameters)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(app_secret);
            foreach (KeyValuePair<string, string> item in parameters)
            {
                sb.Append(item.Key + item.Value);
            }
            parameters.Add("sign", FormsAuthentication.HashPasswordForStoringInConfigFile(sb.ToString(), "MD5").ToUpper());
            string url = "http://gw.api.taobao.com/router/rest?";
            StringBuilder query = new StringBuilder();
            foreach (KeyValuePair<string, string> item in parameters)
            {
                query.Append(item.Key + "=" + HttpUtility.UrlEncode(item.Value, Encoding.UTF8) + "&");
            }
            return (url + query.ToString().TrimEnd(new char[] { '&' }));
        }

        public static XmlDocument GetXmlDocument(string url)
        {
            int tryCount = 0;
            XmlDocument xmlDocument = null;
            while (tryCount < 3)
            {
                try
                {
                    WebRequest webRequest = WebRequest.Create(new Uri(url));
                    webRequest.ContentType = "application/x-www-form-urlencoded";
                    webRequest.Method = "POST";
                    webRequest.Timeout = 600;
                    xmlDocument = new XmlDocument();
                    xmlDocument.Load(webRequest.GetResponse().GetResponseStream());
                    return xmlDocument;
                }
                catch
                {
                    Thread.Sleep(120);
                    tryCount++;
                }
            }
            return xmlDocument;
        }

        public static double SetDiscount(string commission, string price)
        {
            return (Convert.ToDouble(commission) + Convert.ToDouble(price));
        }
    }
}

