﻿namespace TaoBaoAPI
{
    using System;
    using System.Web;

    public class UrlWrite
    {
        public static bool isUrlWrite = Convert.ToBoolean(Convert.ToInt32(Config.isUrlWrite));
        
        public static string SetBaoBei(string num_iid)
        {
            if (isUrlWrite)
            {
                //string filepath = HttpContext.Current.Server.MapPath("/baobei-") + num_iid + ".html";
                //if (!System.IO.File.Exists(filepath))
                //{
                //    AspxToHtml.ToHtml("http://www.taohuonet.com/taobao-" + num_iid + "/", filepath);

                //} 
                return string.Format("/baobei-{0}.html", num_iid);
            }
            return string.Format("/baobei.aspx?iid={0}", num_iid);
        }

        public static string SetBaoBei(string nick, string iid)
        {
            if (isUrlWrite)
            {
                return string.Format("/baobei-{0}.html", iid);
            }
            return string.Format("/baobei.aspx?iid={0}", iid);
        }

        public static string SetCat(int cid)
        {
            if (isUrlWrite)
            {
                //string path=HttpContext.Current.Server.MapPath("/taobao-") + cid;
                //string filePath=HttpContext.Current.Server.MapPath("/taobao-") + cid + "/Index.html";
                //if (!System.IO.Directory.Exists(path))
                //{
                //    System.IO.Directory.CreateDirectory(path);
                //}
                //if (!System.IO.File.Exists(filePath))
                //{
                //    AspxToHtml.ToHtml("http://www.taohuonet.com/taobao-" + cid + "/", HttpContext.Current.Server.MapPath("/taobao-") + cid + "/Index.html");

                //}
                return string.Format("/taobao-{0}/", cid);
            }
            return string.Format("/taobao.aspx?cid={0}", cid);
        }

        public static string SetCat(int cid, int sort)
        {
            if (isUrlWrite)
            {
                return string.Format("/taobao-{0}-{1}/", cid, sort);
            }
            return string.Format("/taobao.aspx?cid={0}&sort={1}", cid, sort);
        }

        public static string SetCatPage(int cid, int sort)
        {
            if (isUrlWrite)
            {
                return string.Concat(new object[] { "/taobao-", cid, "-", sort, "/p{0}" });
            }
            return string.Concat(new object[] { "/taobao.aspx?cid=", cid, "&sort=", sort, "&page={0}" });
        }

        public static string SetSearch(string key)
        {
            if (isUrlWrite)
            {
                return string.Format("/s/{0}-0/", HttpUtility.UrlEncode(key));
            }
            return string.Format("/Search.aspx?key={0}", HttpUtility.UrlEncode(key));
        }

        public static string SetSearch(string key, int cid)
        {
            if (isUrlWrite)
            {
                return string.Format("/s/{0}-{1}/", HttpUtility.UrlEncode(key), cid);
            }
            return string.Format("/Search.aspx?key={0}&cid={1}", HttpUtility.UrlEncode(key), cid);
        }

        public static string SetSearch(string key, int cid, int sort)
        {
            if (isUrlWrite)
            {
                return string.Format("/s/{0}-{1}-{2}/", HttpUtility.UrlEncode(key), cid, sort);
            }
            return string.Format("/Search.aspx?key={0}&cid={1}&sort={2}", HttpUtility.UrlEncode(key), cid, sort);
        }

        public static string SetSearchPage(string key, int cid, int sort)
        {
            if (isUrlWrite)
            {
                return string.Concat(new object[] { "/s/", HttpUtility.UrlEncode(key), "-", cid, "-", sort, "/p{0}" });
            }
            return string.Concat(new object[] { "/Search.aspx?key=", HttpUtility.UrlEncode(key), "&cid=", cid, "&sort=", sort, "&page={0}" });
        }
    }
}

