﻿using System;
using System.Text;

namespace TaoHuoNet.Controls
{
    public partial class PageNo : System.Web.UI.UserControl
    {
        private string m_CssClass = "";
        private string m_LinkFormat = "";
        private string m_NextPageText = "下一页";
        private int m_PageNo = 0;
        private string m_PreviousPageText = "上一页";
        private short m_RowsPerPage = 10;
        private int m_TotalRows = 0;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (this.CssClass != string.Empty)
            {
                this.PageDiv.Attributes.Add("class", this.CssClass);
            }
            int intTotalPage = Convert.ToInt32((this.m_TotalRows / this.m_RowsPerPage).ToString());
            if ((this.m_TotalRows % this.m_RowsPerPage) != 0)
            {
                intTotalPage++;
            }
            if (this.m_PageNo < 1)
            {
                this.m_PageNo = 1;
            }
            if (this.m_PageNo > intTotalPage)
            {
                this.m_PageNo = intTotalPage;
            }
            int intPage1 = this.m_PageNo - 6;
            if (intPage1 < 1)
            {
                intPage1 = 1;
            }
            int intPage2 = this.m_PageNo + 5;
            if (intPage2 > intTotalPage)
            {
                intPage2 = intTotalPage;
            }
            StringBuilder strOutput = new StringBuilder();
            if (this.m_PageNo > intPage1)
            {
                strOutput.Append("<a href=\"" + string.Format(this.m_LinkFormat, this.m_PageNo - 1) + "\">" + this.m_PreviousPageText + "</a> ");
            }
            else
            {
                strOutput.Append("<span class=\"pagecur\">" + this.m_PreviousPageText + "</span> ");
            }
            for (int i = intPage1; i <= intPage2; i++)
            {
                if (i == this.m_PageNo)
                {
                    strOutput.Append("<span class=\"pagecur\">" + i.ToString() + "</span> ");
                }
                else
                {
                    strOutput.Append(string.Concat(new object[] { "<a href=\"", string.Format(this.m_LinkFormat, i), "\">", i, "</a> " }));
                }
            }
            if (this.m_PageNo < intTotalPage)
            {
                strOutput.Append("<a href=\"" + string.Format(this.m_LinkFormat, this.m_PageNo + 1) + "\">" + this.m_NextPageText + "</a>");
            }
            else
            {
                strOutput.Append("<span class=\"pagecur\">" + this.m_NextPageText + "</span> ");
            }
            this.PageDiv.InnerHtml = strOutput.ToString();
        }

   

        public string CssClass
        {
            get
            {
                return this.m_CssClass;
            }
            set
            {
                this.m_CssClass = value;
            }
        }

        public string LinkFormat
        {
            get
            {
                return this.m_LinkFormat;
            }
            set
            {
                this.m_LinkFormat = value;
            }
        }

        public string NextPageText
        {
            get
            {
                return this.m_NextPageText;
            }
            set
            {
                this.m_NextPageText = value;
            }
        }

        public int PageNoCount
        {
            get
            {
                return this.m_PageNo;
            }
            set
            {
                this.m_PageNo = value;
            }
        }

        public string PreviousPageText
        {
            get
            {
                return this.m_PreviousPageText;
            }
            set
            {
                this.m_PreviousPageText = value;
            }
        }


        public short RowsPerPage
        {
            get
            {
                return this.m_RowsPerPage;
            }
            set
            {
                this.m_RowsPerPage = value;
            }
        }

        public int TotalRows
        {
            get
            {
                return this.m_TotalRows;
            }
            set
            {
                this.m_TotalRows = value;
            }
        }
    }
}