﻿using System;
using System.Data;
using System.Web;
using System.Web.Profile;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using TaoBaoAPI;

namespace TaoHuoNet
{
    public partial class Search : System.Web.UI.Page
    {
        public string key;


        private void BindTaobo(int cid, string key)
        {
            TaoBaoKe tbk = new TaoBaoKe();
            tbk.Cid = cid.ToString();
            tbk.Keyword = (key == string.Empty) ? " " : key;
            tbk.Sort = this.GetSortAndIink(cid, key);
            tbk.Page_no = base.Request["page"];
            tbk.Page_size = "24";
            int pageCount = 0;
            DataSet ds = tbk.GetItemsGet(tbk, out pageCount);
            this.ucPageNo.TotalRows = pageCount;
            this.rptList.DataSource = ds;
            this.rptList.DataBind();
            if (this.rptList.Items.Count != 0)
            {
                int intPageIndex = Tools.dfStrToInt32(base.Request["page"]);
                if (intPageIndex < 1)
                {
                    intPageIndex = 1;
                }
                this.ucPageNo.PageNoCount = intPageIndex;
                this.ucPageNo.RowsPerPage = 0x18;
            }
            else
            {
                this.PanNoShow.Visible = true;
                this.PanShow.Visible = false;
            }
        }

        private string GetSortAndIink(int cid, string key)
        {
            string sort = "commissionNum_desc";
            this.s1.Attributes.Add("class", "cur cd");
            this.s1.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 1) + "'>销量</a>";
            this.s2.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 2) + "'>价格</a>";
            this.s3.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 4) + "'>信用</a>";
            this.s4.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 5) + "'>新品</a>";
            this.s5.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 6) + "'>推荐</a>";
            this.s6.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 7) + "'>热点</a>";
            this.s7.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 8) + "'>上架时间</a>";
            this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 1);
            if (base.Request["sort"] == null)
            {
                return sort;
            }
            if (string.IsNullOrEmpty(base.Request["sort"]))
            {
                return sort;
            }
            switch (Tools.dfStrToInt32(base.Request["sort"].ToString()))
            {
                case 1:
                    return "commissionNum_desc";

                case 2:
                    sort = "price_asc";
                    this.s1.Attributes.Add("class", "");
                    this.s2.Attributes.Add("class", "cur");
                    this.s2.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 3) + "'>价格</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 2);
                    return sort;

                case 3:
                    sort = "price_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s2.Attributes.Add("class", "desc");
                    this.s2.InnerHtml = "<a href='" + UrlWrite.SetSearch(key, cid, 2) + "'>价格</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 3);
                    return sort;

                case 4:
                    sort = "credit_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s3.Attributes.Add("class", "cur");
                    this.s3.InnerHtml = "<a href='#'>信用</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 4);
                    return sort;

                case 5:
                    sort = "delistTime_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s4.Attributes.Add("class", "cur");
                    this.s4.InnerHtml = "<a href='#'>新品</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 5);
                    return sort;

                case 6:
                    sort = "commissionRate_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s5.Attributes.Add("class", "cur");
                    this.s5.InnerHtml = "<a href='#'>推荐</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 6);
                    return sort;

                case 7:
                    sort = "commissionVolume_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s6.Attributes.Add("class", "cur");
                    this.s6.InnerHtml = "<a href='#'>热点</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 7);
                    return sort;

                case 8:
                    sort = "delistTime_asc";
                    this.s1.Attributes.Add("class", "");
                    this.s7.Attributes.Add("class", "cur");
                    this.s7.InnerHtml = "<a href='#'>上架时间</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetSearchPage(key, cid, 8);
                    return sort;
            }
            return "commissionNum_desc";
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.Page.IsPostBack)
            {
                if (base.Request["key"] != null)
                {
                    this.key = base.Request["key"];
                }
                if (base.Request["q"] != null)
                {
                    this.key = base.Request["q"];
                }
                int cid = Tools.dfStrToInt32(base.Request["cid"]);
                if (Tools.ValidGeneral(this.key))
                {
                    this.PanNoShow.Visible = true;
                    this.PanShow.Visible = false;
                }
                else
                {
                    this.BindTaobo(cid, this.key);
                }
            }
        }


    }
}
