﻿using System;
using System.Data;
using System.Web.Caching;
using System.Web.SessionState;
using System.Xml;
using TaoBaoAPI;

namespace TaoHuoNet
{
    public partial class TaoBao : StaticFileCachePageBase, IRequiresSessionState
    {
        public string catName;
        public string catNameP;
        public int cid;
        public int getSort;
        public int parent_cid;
        public string siteName;

        private void BindItems(string parent_id)
        {
            DataSet dt=TaoBaoItem.GetItemCats(parent_id);
            this.rptItems.DataSource = TaoBaoItem.GetItemCats(parent_id);
            this.rptItems.DataBind();
            //Response.Write(dt.Tables[0].Rows[0]["cid"].ToString());
        }

        private void BindTaobo(int cid)
        {
            string page = Tools.dfObjectToStr(base.Request["page"]);
            string sort = this.GetSortAndIink(cid);
            string sp = Tools.dfStrToTrimStr(base.Request["sp"]);
            string ep = Tools.dfStrToTrimStr(base.Request["ep"]);
            string getCache = cid + page + sort;
            if (base.Cache[getCache] == null)
            {
                TaoBaoKe tbk = new TaoBaoKe();
                tbk.Cid = cid.ToString();
                tbk.Sort = sort;
                if ((base.Request["sp"] != null) || (base.Request["ep"] != null))
                {
                    tbk.Strat_price = sp;
                    tbk.End_price = ep;
                    this.ucPageNo.LinkFormat = string.Concat(new object[] { "/TaoBao-", cid, "-", base.Request["sort"], "-", sp, "-", ep, "/p{0}" });
                }
                tbk.Page_no = page;
                tbk.Page_size = "24";
                DataSet ds = TaoBaoKe.GetItemsGet(tbk);
                if (ds != null)
                {
                    base.Cache.Insert(getCache, ds, null, Cache.NoAbsoluteExpiration, TimeSpan.FromDays(1.0));
                    this.SetBind(ds, page, getCache);
                }
            }
            else
            {
                this.SetBind((DataSet)base.Cache[getCache], page, getCache);
            }
        }

        private void GetItemInfo(int queryCid)
        {
            this.siteName = Config.siteName;
            XmlNode xmlNode = TaoBaoItem.GetParentItemCats(queryCid.ToString());
            this.ltlCrumb.Text = "其它分类";
            this.Page.Title = "淘宝网其它分类-" + this.siteName;
            if (xmlNode != null)
            {
                this.cid = Tools.dfStrToInt32(xmlNode["cid"].InnerText);
                this.parent_cid = Tools.dfStrToInt32(xmlNode["parent_cid"].InnerText);
                if ((this.cid != 0) && (this.parent_cid != -1))
                {
                    this.catName = xmlNode["name"].InnerText;
                    if (this.parent_cid == 0)
                    {
                        this.ltlCrumb.Text = this.catName;
                        this.BindItems(this.cid.ToString());
                         Page.Title = this.catName + " - " + siteName;
                    }
                    else
                    { 
                        
                      
                        XmlNode xmlNodeP = TaoBaoItem.GetParentItemCats(this.parent_cid.ToString());
                        int cidP = Tools.dfStrToInt32(xmlNodeP["cid"].InnerText);
                        this.ltlCrumb.Text = "<a href='" + UrlWrite.SetCat(cidP) + "'>" + xmlNodeP["name"].InnerText + "</a> > " + this.catName;
                        this.BindItems(cidP.ToString());
                        Page.Title = this.catName + " - " + xmlNodeP["name"].InnerText + " - " + siteName;
                    }
                }
            }
        }

        private string GetSortAndIink(int cid)
        {
            string sort = "commissionNum_desc";
            this.s1.Attributes.Add("class", "cur cd");
            this.s1.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 1) + "'>销量</a>";
            this.s2.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 2) + "'>价格</a>";
            this.s3.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 4) + "'>信用</a>";
            this.s4.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 5) + "'>新品</a>";
            this.s5.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 6) + "'>推荐</a>";
            this.s6.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 7) + "'>热点</a>";
            this.s7.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 8) + "'>上架时间</a>";
            this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 1);
            if (base.Request["sort"] == null)
            {
                return sort;
            }
            if (string.IsNullOrEmpty(base.Request["sort"]))
            {
                return sort;
            }
            this.getSort = Tools.dfStrToInt32(base.Request["sort"].ToString());
            switch (Tools.dfStrToInt32(base.Request["sort"].ToString()))
            {
                case 1:
                    return "commissionNum_desc";

                case 2:
                    sort = "price_asc";
                    this.s1.Attributes.Add("class", "");
                    this.s2.Attributes.Add("class", "cur");
                    this.s2.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 3) + "'>价格</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 2);
                    return sort;

                case 3:
                    sort = "price_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s2.Attributes.Add("class", "desc");
                    this.s2.InnerHtml = "<a href='" + UrlWrite.SetCat(cid, 2) + "'>价格</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 3);
                    return sort;

                case 4:
                    sort = "credit_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s3.Attributes.Add("class", "cur");
                    this.s3.InnerHtml = "<a href='#'>信用</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 4);
                    return sort;

                case 5:
                    sort = "delistTime_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s4.Attributes.Add("class", "cur");
                    this.s4.InnerHtml = "<a href='#'>新品</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 5);
                    return sort;

                case 6:
                    sort = "commissionRate_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s5.Attributes.Add("class", "cur");
                    this.s5.InnerHtml = "<a href='#'>推荐</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 6);
                    return sort;

                case 7:
                    sort = "commissionVolume_desc";
                    this.s1.Attributes.Add("class", "");
                    this.s6.Attributes.Add("class", "cur");
                    this.s6.InnerHtml = "<a href='#'>热点</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 7);
                    return sort;

                case 8:
                    sort = "delistTime_asc";
                    this.s1.Attributes.Add("class", "");
                    this.s7.Attributes.Add("class", "cur");
                    this.s7.InnerHtml = "<a href='#'>上架时间</a>";
                    this.ucPageNo.LinkFormat = UrlWrite.SetCatPage(cid, 8);
                    return sort;
            }
            return "commissionNum_desc";
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if ((!this.Page.IsPostBack && (base.Request["cid"] != null)) && !string.IsNullOrEmpty(base.Request["cid"]))
            {
                this.cid = Tools.dfStrToInt32(base.Request["cid"].ToString());
                this.BindTaobo(this.cid);
                this.GetItemInfo(this.cid);
            }
        }

        private void SetBind(DataSet ds, string page, string getCache)
        {
            this.rptList.DataSource = ds;
            this.rptList.DataBind();
            if (this.rptItems.Items.Count == 0)
            {
                base.Cache.Remove(getCache);
            }
            int intPageIndex = Tools.dfStrToInt32(page);
            if (intPageIndex < 1)
            {
                intPageIndex = 1;
            }
            this.ucPageNo.TotalRows = 0xf78;
            this.ucPageNo.PageNoCount = intPageIndex;
        }


    }
}
