using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Data;

using BookShopOnline.IDal;
using BookShopOnline.Model;
using BookShopOnline.DalFactory;
using BookShopOnline.WebConfig;

namespace BookShopOnline.Bll
{
    public class BookBll
    {
        private static readonly IBook Dal = DataAccess.CreateBook();

        public int InsertBook(Book book)
        {
            return Dal.InsertBook(book);
        }

        public int InsertBookImg(BookImg bookImg)
        {
            return Dal.InsertBookImg(bookImg);
        }

        //private DataSet SelectBookByBookTypeID(string bookTypeID)
        //{
        //    int id = 0;
        //    if (!int.TryParse(bookTypeID, out id))
        //        return null;

        //    DataSet ds= Dal.SelectBookByBookTypeID(id);

        //    SetDefaultPic(ds);

        //    return ds;
        //}

        //ȡĳһͼ¼
        //public DataSet SelectBookByBookTypeIDList(string bookTypeID)
        //{
        //    DataSet ds=Dal.SelectBookByBookTypeIDList(Convert.ToInt32(bookTypeID));

        //    SetDefaultPic(ds);

        //    return ds;
        //}

        #region ȡĳһͼ¼(ҳ
        /// <summary>
        /// ȡĳһͼ¼(ҳĬ(ϼʱ)
        /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageByDefault(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID, Config.BookListPageSize, pageIndex, BookOrderByFields.DateAdded, isDesc, out recordCount);

            SetDefaultPic(ds);

            return ds;
        }

        /// <summary>
         /// ȡĳһͼ¼(ҳ
         /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageBySoldCount(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID,Config.BookListPageSize,pageIndex,BookOrderByFields.SoldCount,isDesc,out recordCount);

            SetDefaultPic(ds);

            return ds;
        }

        /// <summary>
        /// ȡĳһͼ¼(ҳ
        /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageByVisitedCount(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID, Config.BookListPageSize, pageIndex, BookOrderByFields.VisitedCount, isDesc, out recordCount);

            SetDefaultPic(ds);

            return ds;
        }

        /// <summary>
        /// ȡĳһͼ¼(ҳۼ۸
        /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageBySellPrice(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID, Config.BookListPageSize, pageIndex, BookOrderByFields.SellPrice, isDesc, out recordCount);

            SetDefaultPic(ds);

            return ds;
        }

        /// <summary>
        /// ȡĳһͼ¼(ҳۿ
        /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageBySellOff(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID, Config.BookListPageSize, pageIndex, BookOrderByFields.SellOff, isDesc, out recordCount);

            SetDefaultPic(ds);

            return ds;
        }

        /// <summary>
        /// ȡĳһͼ¼(ҳʱ
        /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageByDatePressed(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID, Config.BookListPageSize, pageIndex, BookOrderByFields.DatePressed, isDesc, out recordCount);

            SetDefaultPic(ds);

            return ds;
        }

        /// <summary>
        /// ȡĳһͼ¼(ҳϼ
        /// </summary>
        public DataSet SelectBookByBookTypeIDListByPageByDateAdded(string bookTypeID, int pageIndex, bool isDesc, out int recordCount)
        {
            recordCount = 0;

            int tempID = 0;
            if (!int.TryParse(bookTypeID, out tempID))
                return null;

            DataSet ds= Dal.SelectBookByBookTypeIDListByPage(tempID, Config.BookListPageSize, pageIndex, BookOrderByFields.DateAdded, isDesc, out recordCount);

            SetDefaultPic(ds);

            return ds;
        }
        #endregion

        public DataSet SelectBookByBookID(string bookID)
        {
            int id = 0;
            if (!int.TryParse(bookID, out id))
            {
                return null;
            }

            DataSet ds= Dal.SelectBookByBookID(id);

            SetDefaultPic(ds);
            SetIsNotEnoughStorage(ds);
            return ds;
        }

        public DataSet SelectTopNewestBooks()
        {
            DataSet ds= Dal.SelectTopNewestBooks(Config.TopNewestBooks);

            SetDefaultPic(ds);

            return ds;
        }

        public DataSet SelectTopSoldBooks()
        {
            DataSet ds = Dal.SelectTopSoldBooks(Config.TopSoldBooks);

            SetRowNum(ds);
            SetDefaultPic(ds);

            return ds;
        }

        public DataSet SelectTopCommendedBooks()
        {
            DataSet ds = Dal.SelectTopCommendedBooks(Config.TopCommendBooks);

            SetDefaultPic(ds);

            return ds;
        }

        public DataSet SelectTopVisitedBooks()
        {
            DataSet ds=Dal.SelectTopVisitedBooks(Config.TopVisitedBooks);

            SetRowNum(ds);
            SetDefaultPic(ds);

            return ds;
        }

        //public DataSet SelectBookBySearch(string keyWord, string searchType)
        //{
        //    int typeId=0;
        //    if(!int.TryParse(searchType,out typeId))
        //        return null;

        //    DataSet ds= Dal.SelectBookBySearch(keyWord, typeId);

        //    SetDefaultPic(ds);

        //    return ds;
        //}

        public DataSet SelectBookBySearchByPage(string keyWord, string searchType, int pageIndex, string orderByField, bool isDesc, out int recordCount)
        {
            recordCount = 0;
            int tempSearchType = 0;
            if(!int.TryParse(searchType,out tempSearchType))
                return null;

            DataSet ds= Dal.SelectBookBySearchByPage(keyWord, tempSearchType, pageIndex, Config.BookListPageSize, orderByField,isDesc,out recordCount);

            SetDefaultPic(ds);
            //SetKeyWordInResult(ds,keyWord);

            return ds;
        }

        public DataSet SelectOtherBooksBoughtByTheBuyer(string bookID)
        {
            if (string.IsNullOrEmpty(bookID))
                return null;

            int tempID;
            if (int.TryParse(bookID, out tempID))
            {
                return Dal.SelectOtherBooksBoughtByTheBuyer(tempID);
            }
            else
                return null;
        }

        public DataSet SelectBooksVisited(string bookIDList)
        {
            if (string.IsNullOrEmpty(bookIDList))
                return null;

            return Dal.SelectBooksVisited(bookIDList);
        }

        public int UpdateBook(Book book)
        {
            return Dal.UpdateBook(book);
        }

        public int DeleteBook(string bookID)
        {
            return Dal.DeleteBook(Convert.ToInt32(bookID));
        }

        public int DeleteBookImg(int imgID)
        {
            return Dal.DeleteBookImg(imgID);
        }

        #region 
        //ͼͼƬֶΪգΪĬͼƬ
        private void SetDefaultPic(DataSet ds)
        {
            if (ds != null && ds.Tables[0].Rows.Count > 0)
            {
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    if(string.IsNullOrEmpty(dr["ImgPath"].ToString()))
                    {
                        dr["ImgPath"] = Config.DefaultPic;
                    }
                }
            }
        }

        //
        private void SetRowNum(DataSet ds)
        {
            if (ds != null && ds.Tables[0].Rows.Count > 0)
            {
                int rowNum=0;
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    dr["RowNum"] = ++rowNum;
                }
            }
        }

        //жǷȱ
        private void SetIsNotEnoughStorage(DataSet ds)
        {
            if (ds != null && ds.Tables[0].Rows.Count > 0)
            {
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    if (Convert.ToInt32(dr["Storage"]) > 0)
                        dr["IsNotEnoughStorage"] = false;
                    else
                        dr["IsNotEnoughStorage"] = true;
                }
               
            }
        }

        
        #endregion
    }
}
