using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

using BookShopOnline.IDal;
using BookShopOnline.Model;
using BookShopOnline.DalFactory;

namespace BookShopOnline.Bll
{
    public class BookTypeBll
    {

        private static readonly IBookType Dal = DataAccess.CreateBookType();

        public void InsertBookType(BookType bookType)
        {
            if (string.IsNullOrEmpty(bookType.BookTypeName))
                return;

            Dal.InsertBookType(bookType);
        }

        public IList<BookType> SelectRootBookType()
        {
           return Dal.SelectRootBookType();
        }

        public IList<BookType> SelectSubBooType(int parentID)
        {
           return Dal.SelectSubBooType(parentID);
        }

        public void ResetBookTypeListCached()
        {
            Dal.ResetBookTypeListCached();
        }

        public int UpdateBookType(BookType bookType)
        {
            if (string.IsNullOrEmpty(bookType.BookTypeName))
                return -1;

            return Dal.UpdateBookType(bookType);
        }

        public int DeleteBookType(int bookTypeID)
        {
            return Dal.DeleteBookType(bookTypeID);
        }
    }
}
