using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Data;

using BookShopOnline.IDal;
using BookShopOnline.Model;
using BookShopOnline.DalFactory;
using BookShopOnline.WebConfig;
using BookShopOnline.SQLServerDal;

namespace BookShopOnline.Bll
{
    public class FavoritesBll
    {
        private static readonly IFavorites Dal=DataAccess.CreateFavorites();

        public int InsertFavorites(Favorites favorites)
        {
            return Dal.InsertFavorites(favorites);
        }

        public DataSet SelectFavoritesByUserID(int userID)
        {
            return Dal.SelectFavoritesByUserID(userID);
        }

        public int DeleteFavoritesByID(string favoritesID)
        {
            int tempID = 0;
            if (!int.TryParse(favoritesID, out tempID))
                return -1;

            return Dal.DeleteFavoritesByID(tempID);
        }

        public int SelectMaxID()
        {
            return new HelpDal().SelectMaxID("Favorites", "FavoritesID");
        }
    }
}
