using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Reflection;

using BookShopOnline.IDal;
using BookShopOnline.Model;
using BookShopOnline.DalFactory;

namespace BookShopOnline.Bll
{
    public class OrdersBll
    {
        private static readonly IOrders Dal = DataAccess.CreateOrders();

        public string InsertOrders(Orders orders, DataSet shoppingCartList)
        {
            if (shoppingCartList == null || shoppingCartList.Tables[0].Rows.Count == 0)
                return null;

            return Dal.InsertOrders(orders, shoppingCartList);
        }

        public DataSet SelectOrdersByOrderID(string orderID)
        {
            return Dal.SelectOrdersByOrderID(orderID);
        }

        public DataSet SelectAllOrders()
        {
            return Dal.SelectAllOrders();
        }

        public DataSet SelectOrderStaticByOrderID(string orderID)
        {
            if (string.IsNullOrEmpty(orderID))
                return null;

            return Dal.SelectOrderStaticByOrderID(orderID);
        }

        public DataSet SelectOrderStaticTip()
        {
            return Dal.SelectOrderStaticTip();
        }

        public DataSet SelectOrdersByUserID(int userID)
        {
            return Dal.SelectOrdersByUserID(userID);
        }

        public DataSet SelectOrdersByOrderType(OrderType orderType)
        {
            return Dal.SelectOrdersByOrderType(orderType);
        }

        public DataSet SelectOrdersBySearch(string orderID, string orderDate)
        {
            if (string.IsNullOrEmpty(orderID.Trim()) && string.IsNullOrEmpty(orderDate.Trim()))
                return null;

            return Dal.SelectOrdersBySearch(orderID, orderDate);
        }
        public bool PayForOrders(int userID, string orderID, decimal payPrice)
        {
            if (payPrice <= 0||string.IsNullOrEmpty(orderID))
                return false;

            return Dal.PayForOrders(userID, orderID, payPrice);
        }

        public int UpdateOrders(Orders orders)
        {
            if (orders.UserID <= 0 || string.IsNullOrEmpty(orders.OrderID))
                return -1;

            return Dal.UpdateOrders(orders);
        }

        public bool UpdateOrderStaicAndTip(string orderID, IList<Order_OrderStatic> order_OrderStaticList, int tipID)
        {
            if (string.IsNullOrEmpty(orderID))
                return false;

            return Dal.UpdateOrderStaicAndTip(orderID, order_OrderStaticList, tipID);
        }

    }
}
