using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Data;

using BookShopOnline.IDal;
using BookShopOnline.Model;
using BookShopOnline.DalFactory;

namespace BookShopOnline.Bll
{
    public class ShoppingCartBll
    {
        private static readonly IShoppingCart Dal = DataAccess.CreateShoppingCart();

        public int InsertShoppingCart(ShoppingCart shoppingCart)
        {
            return Dal.InsertShoppingCart(shoppingCart);
        }

        public DataSet SelectShoppingCartByCartGuid(string cartGuid)
        {
            if (string.IsNullOrEmpty(cartGuid))
                return null;

            return Dal.SelectShoppingCartByCartGuid(cartGuid);
        }

        public int UpdateShoppingCart(ShoppingCart shoppingCart)
        {
            return Dal.UpdateShoppingCart(shoppingCart);
        }

        public int UpdateShoppingCart(IList<ShoppingCart> shoppingCartList)
        {
            if (shoppingCartList == null || shoppingCartList.Count == 0)
                return 0;

            return Dal.UpdateShoppingCart(shoppingCartList);
        }

        public int DeleteShoppingCartByCartID(string cartID)
        {
            return Dal.DeleteShoppingCartByCartID(Convert.ToInt32( cartID));
        }

        public int DeleteShoppingCartByCartGuid(string cartGuid)
        {
            return Dal.DeleteShoppingCartByCartGuid(cartGuid);
        }
    }
}
