using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Data;

using BookShopOnline.IDal;
using BookShopOnline.Model;
using BookShopOnline.DalFactory;
using BookShopOnline.Utility;
using BookShopOnline.WebConfig;

namespace BookShopOnline.Bll
{
    public class UserBll
    {
        private static readonly IUser Dal = DataAccess.CreateUser();

        /// <summary>
        /// ûΪշ-1ûѴڷ-2EmailѴڷ-3볤ȹ̷-4ɹ1ʧܷ0
        /// </summary>
        /// <param name="user"></param>
        /// <returns></returns>
        public int InsertUser(User user)
        {
            if (string.IsNullOrEmpty(user.UserName) || string.IsNullOrEmpty(user.UserPwd))
                return -1;

            if (Dal.CheckUserName(user.UserName))
                return -2;

            int minLength = 0;
            if (user.RoleID == (int)Role.RegisterUser)
            {
                minLength = Config.RegisterUserPwdMinLength;
            }
            else if (user.RoleID == (int)Role.AdminUser)
            {
                minLength = Config.AdminUserPwdMinLength;
            }

            if (user.UserPwd.Length < minLength)
                return -4;

            if (Dal.CheckEmail(user.Email))
                return -3;

            user.UserPwd = Password.EncryptMD5(user.UserPwd);

            return Dal.InsertUser(user);
        }

        /// <summary>
        /// ڷtrue򷵻false
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        public bool CheckUserName(string userName)
        {
            if (string.IsNullOrEmpty(userName))
                return false;

            return Dal.CheckUserName(userName);
        }

        /// <summary>
        /// ڷtrue򷵻false
        /// </summary>
        /// <param name="email"></param>
        /// <returns></returns>
        public bool CheckEmail(string email)
        {
            if(string.IsNullOrEmpty(email))
               return false;

           return Dal.CheckEmail(email);
        }

        public User CheckUserLogin(string userName, string userPwd,Role role)
        {
            if (string.IsNullOrEmpty(userName) || string.IsNullOrEmpty(userPwd))
                return null;

            return Dal.CheckUserLogin(userName, userPwd, role);
        }

        public bool EditPwd(int userID,string newPwd)
        {
            
            if (userID<=0||string.IsNullOrEmpty(newPwd))
                return false;

            newPwd = Password.EncryptMD5(newPwd);

            return Dal.EditPwd(userID, newPwd);
        }

        /// <summary>
        /// -1EmailѴڣ0ʧܣ>0:³ɹ
        /// </summary>
        public int UpdateUser(User user,string oldEmail)
        {
            if(!string.Equals(user.Email,oldEmail))//email޸ˣҪ֤µemailǷѴ
            {
                if (this.CheckEmail(user.Email))
                    return -1;
            }

            return Dal.UpdateUser(user);
        }
    }
}
