﻿using System;
using System.Reflection;

using BookShopOnline.WebConfig;
using BookShopOnline.IDal;

namespace BookShopOnline.DalFactory
{
    public class DataAccess
    {
        private static readonly string Path = Config.WebDal;

        public static ISample CreateSample()
        {
            string className = Path + ".SampleDal";
            return (ISample)Assembly.Load(Path).CreateInstance(className);
        }

        public static IBookType CreateBookType()
        {
            string className = Path + ".BookTypeDal";
            return (IBookType)Assembly.Load(Path).CreateInstance(className);
        }

        public static IBook CreateBook()
        {
            string className = Path + ".BookDal";
            return (IBook)Assembly.Load(Path).CreateInstance(className);
        }

        public static IShoppingCart CreateShoppingCart()
        {
            string className = Path + ".ShoppingCartDal";
            return (IShoppingCart)Assembly.Load(Path).CreateInstance(className);
        }

        public static IOrders CreateOrders()
        {
            string className = Path + ".OrdersDal";
            return (IOrders)Assembly.Load(Path).CreateInstance(className);
        }

        public static IOrderDetail CreateOrdeDetail()
        {
            string className = Path + ".OrderDetailDal";
            return (IOrderDetail)Assembly.Load(Path).CreateInstance(className);
        }

        public static IPortType CreatePortType()
        {
            string className = Path + ".PortTypeDal";
            return (IPortType)Assembly.Load(Path).CreateInstance(className);
        }

        public static IPayType CreatePayType()
        {
            string className = Path + ".PayTypeDal";
            return (IPayType)Assembly.Load(Path).CreateInstance(className);
        }

        public static IUser CreateUser()
        {
            string className = Path + ".UserDal";
            return (IUser)Assembly.Load(Path).CreateInstance(className);
        }

        public static IFavorites CreateFavorites()
        {
            string className = Path + ".FavoritesDal";
            return (IFavorites)Assembly.Load(Path).CreateInstance(className);
        }

        public static IAdsImg CreateAdsImg()
        {
            string className = Path + ".AdsImgDal";
            return (IAdsImg)Assembly.Load(Path).CreateInstance(className);
        }
    }
}
