using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using BookShopOnline.Model;

namespace BookShopOnline.IDal
{
    public interface IBook
    {
        int InsertBook(Book book);

        int InsertBookImg(BookImg bookImg);
       
        DataSet SelectBookByBookTypeID(int bookTypeID);

        DataSet SelectBookByBookTypeIDList(int bookTypeID);

        DataSet SelectBookByBookTypeIDListByPage(int bookTypeID,int pageSize,int pageIndex,string orderByField,bool isDesc,out int recordCount);

        DataSet SelectBookByBookID(int bookID);

        DataSet SelectTopNewestBooks(int topNewestBooks);

        DataSet SelectTopSoldBooks(int topSoldBooks);

        DataSet SelectTopCommendedBooks(int topCommendedBooks);

        DataSet SelectTopVisitedBooks(int topVisitedBooks);

        DataSet SelectBookBySearch(string keyWord, int searchType);

        DataSet SelectBookBySearchByPage(string keyWord, int searchType, int pageIndex, int pageSize,string orderByField,bool isDesc, out int recordCount);

        DataSet SelectOtherBooksBoughtByTheBuyer(int bookID);

        DataSet SelectBooksVisited(string bookIDList);

        int UpdateBook(Book book);

        int DeleteBook(int bookID);

        int DeleteBookImg(int imgID);
    }
}
