using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

using BookShopOnline.Model;

namespace BookShopOnline.IDal
{
    public interface IOrders
    {
        string InsertOrders(Orders orders, DataSet shoppingCartList);

        DataSet SelectOrdersByOrderID(string orderID);

        DataSet SelectAllOrders();

        DataSet SelectOrderStaticByOrderID(string orderID);

        DataSet SelectOrderStaticTip();

        DataSet SelectOrdersByUserID(int userID);

        DataSet SelectOrdersByOrderType(OrderType orderType);

        DataSet SelectOrdersBySearch(string orderID, string orderDate);

        bool PayForOrders(int userID,string orderID,decimal payPrice);

        int UpdateOrders(Orders orders);

        bool UpdateOrderStaicAndTip(string orderID, IList<Order_OrderStatic> order_OrderStaticList, int tipID);
        
    }
}
