using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.IDal;
using BookShopOnline.DBHelper;
using BookShopOnline.WebConfig;

namespace BookShopOnline.SQLServerDal
{
    public class BookDal:DBAccess,IBook
    {
        #region ͼ
        public int InsertBook(Book book)
        {
            int result = 0;
            SqlParameter[] parms =
                {
                    //ͼƬIDܣԭۣۼۣ,ߣ磬ʱ䣬ISBN
                    new SqlParameter("@ImgID",book.ImgID),
                    new SqlParameter("@BookName",book.BookName),
                    new SqlParameter("@BookTypeID",book.BookTypeID),
                    new SqlParameter("@Description",book.Description),
                    new SqlParameter("@OriginalPrice",book.OriginalPrice),
                    new SqlParameter("@SellPrice",book.SellPrice),
                    new SqlParameter("@Quatity",book.Quatity),
                    new SqlParameter("@Storage",book.Storage),
                    new SqlParameter("@Author",book.Author),
                    new SqlParameter("@Press",book.Press),
                    new SqlParameter("@DatePressed",book.DatePressed),
                    new SqlParameter("@ISBN",book.ISBN),
                };

            result= SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_InsertBook.ToString(), parms);
            return result;
        }
        #endregion

        #region ͼƬ
        public int InsertBookImg(BookImg bookImg)
        {
            int imgID = 0;
            SqlParameter parm = new SqlParameter("@ImgPath", bookImg.ImgPath);

            using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_InsertBookImg.ToString(), parm))
            {
                if (dr.Read())
                {
                    imgID = Convert.ToInt32(dr[0]);// dr.GetInt32(0);
                }
            }

            return imgID;
        }
        #endregion

        #region ȡĳһͼ¼
        public DataSet SelectBookByBookTypeID(int bookTypeID)
        {
            SqlParameter parm = new SqlParameter("@BookTypeID", bookTypeID);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectBookByBookTypeID.ToString(), parm);
        }
        #endregion

        #region ȡĳһͼ¼(ҳ
        public DataSet SelectBookByBookTypeIDListByPage(int bookTypeID,int pageSize,int pageIndex,string orderByField,bool isDesc,out int recordCount)
        {
            BookTypeDal bookTypeDal = new BookTypeDal();
            ArrayList arrayList = new ArrayList();
            bookTypeDal.GetBookTypeIDList(arrayList, bookTypeID);

            string bookTypeIDList = bookTypeID.ToString();
            for (int i = 0; i < arrayList.Count; i++)
            {
                bookTypeIDList += "," + arrayList[i].ToString();
            }

            SqlParameter[] parms ={
                new SqlParameter("RecordCount",SqlDbType.Int),
                new SqlParameter("@BookTypeIDList", bookTypeIDList),
                new SqlParameter("@PageSize",pageSize),
                new SqlParameter("@PageIndex",pageIndex),
                new SqlParameter("@OrderByField",orderByField),
                new SqlParameter("@IsDesc",isDesc)
                };
            parms[0].Direction = ParameterDirection.ReturnValue;

            DataSet ds= base.GetDataSet(StoredProcedureName.sp_SelectBookByBookTypeIDListByPage, parms);

            if (!int.TryParse(parms[0].Value.ToString(), out recordCount))
                recordCount = 0;

            return ds;
        }
        #endregion

        #region ȡĳһͼ¼
        public DataSet SelectBookByBookTypeIDList(int bookTypeID)
        {
            BookTypeDal bookTypeDal = new BookTypeDal();
            ArrayList arrayList = new ArrayList(); 
            bookTypeDal.GetBookTypeIDList(arrayList, bookTypeID);

            string bookTypeIDList = bookTypeID.ToString();
            for (int i = 0; i < arrayList.Count; i++)
            {
                bookTypeIDList += "," + arrayList[i].ToString();
            }

            SqlParameter parm = new SqlParameter("@BookTypeIDList", bookTypeIDList);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectBookByBookTypeIDList.ToString(), parm);
        }
        #endregion

        #region ȡĳһͼ¼
        public DataSet SelectBookByBookID(int bookID)
        {
            SqlParameter parm = new SqlParameter("@BookID", bookID);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectBookByBookID.ToString(), parm);
        }
        #endregion

        #region ȡͼ
        public DataSet SelectTopNewestBooks(int topNewestBooks)
        {
            SqlParameter parm = new SqlParameter("@TopNewestBooks", topNewestBooks);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectTopNewestBooks.ToString(), parm);
        }
        #endregion

        #region ȡа
        public DataSet SelectTopSoldBooks(int topSoldBooks)
        {
            SqlParameter parm = new SqlParameter("@TopSoldBooks", topSoldBooks);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectTopSoldBooks.ToString(), parm);
        }
        #endregion

        #region ȡƼͼ
        public DataSet SelectTopCommendedBooks(int topCommendedBooks)
        {
            SqlParameter parm = new SqlParameter("@TopCommendedBooks", topCommendedBooks);

            return SQLHelper.GetDataSet(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectTopCommendedBooks.ToString(), parm);
        }
        #endregion

        #region ȡа
        public DataSet SelectTopVisitedBooks(int topVisitedBooks)
        {
            SqlParameter parm = new SqlParameter("@TopVisitedBooks", topVisitedBooks);

            return base.GetDataSet(StoredProcedureName.sp_SelectTopVisitedBooks, parm);
        }
        #endregion

        #region ͼ
        public DataSet SelectBookBySearch(string keyWord, int searchType)
        {
            SqlParameter[] parms =
                {
                    new SqlParameter("@KeyWord",keyWord),
                    new SqlParameter("@SearchType",searchType)
                };

            return base.GetDataSet(StoredProcedureName.sp_SelectBookBySearch, parms);
        }
        #endregion

        #region ͼҳ
        public DataSet SelectBookBySearchByPage(string keyWord, int searchType, int pageIndex, int pageSize, string orderByField, bool isDesc, out int recordCount)
        {
            SqlParameter[] parms ={
                new SqlParameter("RecordCount",SqlDbType.Int),
                new SqlParameter("@KeyWord",SqlDbType.NVarChar,50),
                new SqlParameter("@SearchType",searchType),
                new SqlParameter("@PageSize",pageSize),
                new SqlParameter("@PageIndex",pageIndex),
                new SqlParameter("@OrderType",orderByField),
                new SqlParameter("@IsDesc",isDesc)
                };
            parms[0].Direction = ParameterDirection.ReturnValue;
            parms[1].Value = keyWord;
            DataSet ds = base.GetDataSet(StoredProcedureName.sp_SelectBookBySearchByPage, parms);

            if (!int.TryParse(parms[0].Value.ToString(), out recordCount))
                recordCount = 0;

            return ds;
        }
        #endregion

        #region Ҳ
        public DataSet SelectOtherBooksBoughtByTheBuyer(int bookID)
        {
            SqlParameter parm = new SqlParameter("@BookID", bookID);

            return base.GetDataSet(StoredProcedureName.sp_SelectOtherBooksBoughtByTheBuyer, parm);
        }
        #endregion

        #region ȡʷ 
        public DataSet SelectBooksVisited(string bookIDList)
        {
            SqlParameter parm = new SqlParameter("@BookIDList", bookIDList);
            try
            {
                return base.GetDataSet(StoredProcedureName.sp_SelectBooksVisited, parm);
            }
            catch
            {
                return null;
            }
        }
        #endregion

        #region ͼ¼
        public int UpdateBook(Book book)
        {
            int result = 0;

            return result;
        }
        #endregion

        #region ɾһͼ¼
        public int DeleteBook(int bookID)
        {
            int result = 0;

            return result;
        }
        #endregion

        #region ɾһͼƬ¼
        public int DeleteBookImg(int imgID)
        {
            SqlParameter parm = new SqlParameter("@ImgID", imgID);
            return SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_DeleteBookImg.ToString(), parm);
        }
        #endregion
    }
}
