using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Data;

using BookShopOnline.Model;
using BookShopOnline.IDal;
using BookShopOnline.DBHelper;
using BookShopOnline.WebConfig;

namespace BookShopOnline.SQLServerDal
{
    public class BookTypeDal:DBAccess,IBookType
    {

        #region ȡûеĽڵ
        private IList<BookType> BookTypeListCached = new List<BookType>();

        private IList<BookType> GetBookTypeListCached()
        {
            if (BookTypeListCached == null || BookTypeListCached.Count == 0)
                BookTypeListCached=SelectAllBookType();

             return BookTypeListCached;
        }

        public void ResetBookTypeListCached()
        {
            if (BookTypeListCached != null)
                BookTypeListCached.Clear();

            BookTypeListCached=SelectAllBookType();
        }
        #endregion

        #region ڵ
        public void InsertBookType(BookType bookType)
        {
            SqlParameter[] parms =
                {
                    new SqlParameter("@BookTypeName",bookType.BookTypeName),
                    new SqlParameter("@ParentID",bookType.ParentID),
                    new SqlParameter("@OrderBy",bookType.OrderBy)
                };

            SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_InsertBookType.ToString(), parms);
        }
        #endregion

        #region ɾڵ
        public int DeleteBookType(int bookTypeID)
        {
            int result = 0;

            //ȡBookTypeID=bookTypeIDӽڵBookTypeID
            ArrayList bookTypeIDList = new ArrayList();
            bookTypeIDList.Add(bookTypeID);
            GetBookTypeIDList(bookTypeIDList, bookTypeID);

            //ɾڵ,ӽڵ㵽ڵ
            SqlConnection conn = new SqlConnection(Config.SQLServerConnStr);
            conn.Open();

            for (int i = bookTypeIDList.Count - 1; i >= 0; i--)
            {
                SqlParameter parm = new SqlParameter("@bookTypeID", bookTypeIDList[i]);

                result += SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_DeleteBookType.ToString(), parm);
            }

            conn.Close();

            return result;
        }
        #endregion

        #region ޸Ľڵ
        public int UpdateBookType(BookType bookType)
        {
            int result = 0;

            SqlParameter[] parms =
                {
                    new SqlParameter("@BookTypeID",bookType.BookTypeID),
                    new SqlParameter("@BookTypeName",bookType.BookTypeName),
                    new SqlParameter("@OrderBy",bookType.OrderBy)
                };

            result = SQLHelper.ExecuteNonQuery(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_UpdateBookType.ToString(), parms);

            return result;
        }
        #endregion

        #region ȡеĽڵ
        public IList<BookType> SelectAllBookType()
        {
            IList<BookType> bookTypeList = new List<BookType>();

            using (SqlDataReader dr = base.ExecuteReader(StoredProcedureName.sp_SelectAllBookType, null))
            {
                while (dr.Read())
                {
                    BookType bookType = new BookType();
                    bookType.BookTypeID = dr.GetInt32(dr.GetOrdinal("BookTypeID"));
                    bookType.BookTypeName = dr.GetString(dr.GetOrdinal("BookTypeName"));
                    bookType.ParentID = dr.GetInt32(dr.GetOrdinal("ParentID"));
                    bookType.OrderBy = dr.GetInt32(dr.GetOrdinal("OrderBy"));
                    bookTypeList.Add(bookType);
                }
            }

            return bookTypeList;
        }
        #endregion

        #region ȡڵ
        public IList<BookType> SelectRootBookType()
        {
            IList<BookType> bookTypeList = new List<BookType>();

            foreach(BookType bookType in GetBookTypeListCached())
            {
                if(bookType.ParentID==-1)
                  bookTypeList.Add(bookType);
            }

            return bookTypeList;
        }
        #endregion

        #region ȡӽڵ
        public IList<BookType> SelectSubBooType(int parentID)
        {
            IList<BookType> bookTypeList = new List<BookType>();

            foreach (BookType bookType in GetBookTypeListCached())
            {
                if(bookType.ParentID==parentID)
                   bookTypeList.Add(bookType);
            }

            return bookTypeList;
        }
        #endregion

        #region ȡParentID=parentIDнڵBookTypeID
        public void GetBookTypeIDList(ArrayList bookTypeIDList, int parentID)
        {
            foreach (BookType bookType in GetBookTypeListCached())
            {
                if (bookType.ParentID == parentID)
                {
                    bookTypeIDList.Add(bookType.BookTypeID);
                    GetBookTypeIDList(bookTypeIDList, bookType.BookTypeID);
                }
            }
        }
        #endregion


        #region ȡݿ(ʹã
        #region ȡڵ
        //public IList<BookType> SelectRootBookType()
        //{
        //    IList<BookType> bookTypeList = new List<BookType>();

        //    using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectRootBookType.ToString(), null))
        //    {
        //        while (dr.Read())
        //        {
        //            BookType bookType = new BookType();
        //            bookType.BookTypeID = dr.GetInt32(dr.GetOrdinal("BookTypeID"));
        //            bookType.BookTypeName = dr.GetString(dr.GetOrdinal("BookTypeName"));
        //            bookType.ParentID = dr.GetInt32(dr.GetOrdinal("ParentID"));
        //            bookType.OrderBy = dr.GetInt32(dr.GetOrdinal("OrderBy"));
        //            bookTypeList.Add(bookType);
        //        }
        //    }

        //    return bookTypeList;
        //}
        #endregion

        #region ȡӽڵ
        //public IList<BookType> SelectSubBooType(int parentID)
        //{
        //    IList<BookType> bookTypeList = new List<BookType>();
        //    SqlParameter parms = new SqlParameter("@ParentID", parentID);

        //    using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectSubBooType.ToString(), parms))
        //    {
        //        while (dr.Read())
        //        {
        //            BookType bookType = new BookType();
        //            bookType.BookTypeID = dr.GetInt32(dr.GetOrdinal("BookTypeID"));
        //            bookType.BookTypeName = dr.GetString(dr.GetOrdinal("BookTypeName"));
        //            bookType.ParentID = dr.GetInt32(dr.GetOrdinal("ParentID"));
        //            bookType.OrderBy = dr.GetInt32(dr.GetOrdinal("OrderBy"));
        //            bookTypeList.Add(bookType);
        //        }
        //    }

        //    return bookTypeList;
        //}
        #endregion

        #region ȡParentID=parentIDнڵBookTypeID
        //public void GetBookTypeIDList(ArrayList bookTypeIDList, int parentID)
        //{
        //    SqlParameter parm = new SqlParameter("@ParentID", parentID);
        //    using (SqlDataReader dr = SQLHelper.ExecuteReader(Config.SQLServerConnStr, CommandType.StoredProcedure, StoredProcedureName.sp_SelectSubBooType.ToString(), parm))
        //    {
        //        while (dr.Read())
        //        {
        //            int bookTypeID=dr.GetInt32(dr.GetOrdinal("BookTypeID"));
        //            bookTypeIDList.Add(bookTypeID);
        //            GetBookTypeIDList(bookTypeIDList, bookTypeID);
        //        }
        //    }
        //}
        #endregion

        #endregion
    }
}
